var main = document.querySelector('main'),
	container = document.querySelector('.container'),
	canvas = document.getElementById('canvas'),
	ctx = canvas.getContext('2d'),
	text = document.querySelector('.text'),
	ww = window.innerWidth,
	menu = document.querySelector('.menu'),
	ul = menu.querySelector('ul'),
	video,
	idx = 0,
	count = ul.childElementCount - 1,
	toggle = true,
	frame;

// Set canvas size
canvas.width = ww / 3;
canvas.height = (ww * 0.5625) / 3;

// Generate CRT noise
function snow() {

	var w = ctx.canvas.width,
		h = ctx.canvas.height,
		d = ctx.createImageData(w, h),
		b = new Uint32Array(d.data.buffer),
		len = b.length;

	for (var i = 0; i < len; i++) {
		b[i] = ((255 * Math.random()) | 0) << 24;
	}

	ctx.putImageData(d, 0, 0);
}

function animate() {
	snow();
	frame = requestAnimationFrame(animate);
};

// Glitch
for (i = 0; i < 4; i++) {
	var span = text.firstElementChild.cloneNode(true);
	text.appendChild(span);
}

window.addEventListener('DOMContentLoaded', function(e) {
	setTimeout(function() {
		main.classList.add('on');
		main.classList.remove('off');
		animate();

		setTimeout(() => {
			menu.style.display = 'inherit';
			['click', 'keydown', 'touchstart'].forEach((eventName) => {
				window.addEventListener(eventName, eventFunction, false);
			});
		}, 3000);
	}, 1000);
});

function createPlayer() {
	  var source_MP4 = document.createElement("source");
	  source_MP4.id = "vidSource" 
	  source_MP4.type = "video/mp4";

	  //source_MP4.src = "https://untamed.zone/miscFolder/pizzaCats.mp4"; // 
	  source_MP4.src = "https://archive.org/download/80erne/_RetroVHS2_80er.mp4";

	  var videoElem = document.createElement("video");
	  videoElem.appendChild(source_MP4);
	  videoElem.id = "videoPlayer";
	  
	  videoElem.width = "100%";
	  videoElem.height = "100%";
	  //videoElem.muted = "false";
	  //videoElem.autoplay = "false";
	  videoElem.preload = "auto";
	  //videoElem.controls = "controls"; // uncomment to hide controls
	  videoElem.onclick = "this.play()";
	  videoElem.className = "video";
	  videoElem.crossOrigin = "anonymous";
	  videoElem.loop = "true";
	  //videoElem.preload = "metadata";

	  //var containerElem = document.getElementById("container");
	  container.appendChild(videoElem);

	  video = document.getElementById("videoPlayer");

	  console.log("success creating player!");
	  play();
}

function play(){
    video.muted = false;
    video.play();

    video.addEventListener('loadedmetadata', function() {

    	// video.width = "100%";
    	// video.height = "auto";
    	// video.width = video.videoWidth;
    	// video.height = video.videoHeight;
    	// console.log(video.videoWidth, video.videoHeight);
        // video.onseeking = (event) => {
        //   	var delta = video.currentTime - fixedCurrentTime;
        //   	if (Math.abs(delta) > 0.01) video.currentTime = fixedCurrentTime;
        // }

        // playerElem.ontimeupdate = (event) =>{
        //   	if (!playerElem.seeking) {
        //     	fixedCurrentTime = playerElem.currentTime;
        //     	playerElem.muted = false;
        //   	}
        // }
    });
}

var eventFunction = function(event) {
    console.log(event.type);
    event.preventDefault();
    ['click', 'keydown', 'touchstart'].forEach((eventName) => {
		window.removeEventListener(eventName, eventFunction, false);
	});
    //if (event.type == 'keydown') event.preventDefault();
    //$('#canvas').fadeOut( "slow", () => { $('#canvas').hide() });
    $('#canvas').hide();
	$('.text').hide();
    $('.menu').hide();
    container.style.display = 'flex';

    setTimeout(() => {
    	$('.container').css('background','rgba(0, 0, 0, 0.8)');
    	createPlayer();
    }, 2000);
    
};


