
var readMode = 0;
var listMode = 0;
var hist = [];
var buffer = [];
var histCount = -1;
var dotObj = toDotList(data);
var pages = {};
var pageLength;
var pageSize;
var currentPage;
var readFile;

Object.keys(dotObj).forEach(function(key, index) {
    var val = dotObj[key];
    //console.log(index,key); //,val);
});
console.log("D O G E N I G T ");
console.log("terminal script v1.0.1");
console.log(' ');

var objectsLen = Object.keys(dotObj).length-1;
for (i=objectsLen; i>=0; i--) {
  let thisObj = Object.keys(dotObj)[i];
  console.log(thisObj);
}

console.log(' ');

function toDotList(obj) {
  function walk(into, obj, prefix = []) {
    Object.entries(obj).forEach(([key, val]) => {
      //console.log("key:",key,", val:",val);
      //console.log("typeof:",typeof(val));
      if (typeof val === "object" && !Array.isArray(val)) {
         walk(into, val, [...prefix, key]);
         into[[...prefix, key].join(".")] = val;
         //console.log("walk:",into, val, prefix, key);
      } else {
         //into[[...prefix, key].join(".")] = val;
      }
    });
  }
  const out = {};
  walk(out, obj);
  return out;
}

var thisDir = 'root';
var thisTree = dotObj[thisDir];
// var thisTree = dirs[Object.keys(dirs)[level]];
// var thisDir = Object.keys(dirs)[level];

console.log(' ');

/////////////////////////////////////////////

var date = new Date();
var dateLocal = date.toLocaleString("da-DK"); //.replace(" ", "T").split(".")[0];
var dateSplit = dateLocal.split(" ")[0];
var daySplit = dateSplit.split(".")[0];
var dayPad = zeroPad(parseInt(daySplit), 2);
var monthSplit = dateSplit.split(".")[1];
var monthPad = zeroPad(parseInt(monthSplit), 2);

var timeSplit = dateLocal.split(" ")[1];
var datePad = dayPad;
datePad += '-';
datePad += monthPad;
datePad += '-';
datePad += dateSplit.split(".")[2];

var timeString = timeSplit.replaceAll(".", ":");

var dateString = datePad;
dateString += ' ';
dateString += timeString;

console.log(dateString);

let echo = true;
let commands = new Map();

document.body.onload = function () {
  // INIT vars
  let output = document.getElementById('output');
  let prompt = document.getElementById('prompt');
  let pre = document.getElementById('pre');
  let carat = document.getElementById('carat');
  let post = document.getElementById('post');
  
  prompt.innerHTML = 'User>';
  carat.innerHTML = ' ';
  document.addEventListener('keydown', handleKeypress);
  var intro = document.createElement('span');
  intro.innerHTML =  dateString;
  intro.innerHTML += '\n';
  document.getElementById('output').appendChild(intro);

  //dircmd();
};

function readcmd(args) {
   var thisFile;
   if (args[0]) {
    thisFile = args[0];
    let fileExists = thisTree[thisFile];

    if (fileExists == undefined || fileExists == 'undefined') {
      output("Requested file doesn't exist.");
      return;
    }
   } else {
    output("No filename specified.");
    return;
   }

   //console.clear();
   readMode = 1;
   lines = [];
   pageSize = 10;
   let pageCount = 0;
   let con = document.getElementById('output');
   //let conWidth = con.offsetWidth;
   let conWidth = (checkWidth() - 200);
   let charWidth = 13;
   console.log("conwidth:",conWidth);

   Object.keys(thisTree).forEach(function(key) {
      var val = thisTree[key];
      if (typeof(val) == 'string') {
        if (thisFile == key) {
          readFile = key;
          console.log("val.length * charWidth:",(val.length * charWidth));

          if ((val.length * charWidth) <= conWidth) {
            clearcmd();
            output(key+":");
            output(" ");
            output(val);
            output(" "); 
            readMode = 0;           
          } else {
            let valArray = val.split(" ");
            let line = "";

            valArray.forEach((element, index) => {
              let lineLength = ((line.length * charWidth)+element.length);                  
              let lineIndx = index;;
          
              if (element == '<br>') {
                if (line.length) {
                  lines.push(line);
                  line = "";
                } else {
                  line = " ";
                  lines.push(line);
                  line = "";
                }
              } else {
                if (lineLength <= (conWidth+2)) {
                  line += element;
                  line += " ";
                } else {
                  lines.push(line);
                  line = "";
                  line += element;
                  line += " ";
                }
              }
            });

            if (line.length) {
              line += " ";
              lines.push(line);
            }
 
            if (lines.length) {
              if (lines.length < pageSize) {
                clearcmd();
                output(key+":");
                lines.forEach((element, index) => {
                  output(index + " " + element);
                });
                readMode = 0;              
              } else {
               pageCount = (lines.length / pageSize);
               var end = 0;
               for (var p=0; p<=pageCount; p++) {
                 let start = end;
                 end = start + pageSize;
                 pages[p] = lines.slice(start,end);
               } 

               Object.entries(pages).forEach(([key, val]) => {
                //console.log(key, val);
               }); 
               pageLength = Object.keys(pages).length-1;
               currentPage = 0;
               $('#container').find('span').hide();
               readPage(currentPage);             
              }
            }
          }
        }
      }
  });
}
commands.set('read', readcmd);
//commands.set('cat', readcmd);
//commands.set('txt', readcmd);

function readPage(page) {
   var lines = pages[page];
   clearcmd();
   output(readFile+" ("+(page+1)+" of "+(pageLength+1)+")");
   output(" ")
   lines.forEach((line, index) => {
     let pageNum = index + (page * pageSize);
     output(pageNum + " " + line);  
   });

}

function cdcmd(args) {
  console.clear();
  let input = args[0];
  let splitInput;
  let firstChar;
  let request;
  let arg;

  if (!input) { 
    console.log("didn't provide arg");
    input = '';
    //return 1
  } else {
    splitInput = input.split('/').pop();
    firstChar = input.slice(0,1);
    console.log("typed:",input);
    console.log("input.split.pop:", splitInput);
    console.log("firstChar:",firstChar);
  }

  console.log("thisDir",thisDir);
  if (input.length == 0) {
    //console.log("didn't provide arg");
    thisDir = 'root'; 
    //input = ' ';
    request = thisDir;
    arg = request;
    //return 1
  } else if (input.length == 1 && firstChar == '/') {
      request = 'root';
      arg = request;
  } else if (input.length == 1 && firstChar == '.') {
      output("request is current dir.");
      request = thisDir.replaceAll('.','/');
      arg = thisDir;
  } else if (input.length == 2 && input == '..') {
      thisDir = thisDir.split(".").slice(0, -1).join('.');
      request = thisDir.replaceAll('.','/');
      arg = thisDir;
  } else {

    if (input.length == 1 && input == 'c') {
      input = 'C';
    } else if (input.split("/").includes('c')) {
      let lcArr = input.split("/");
      let lcIndx = lcArr.indexOf('c');
      lcArr[lcIndx] = 'C';
      input = lcArr.join('/');
    }

    if (firstChar == '/') {
      thisDir = 'root';
      console.log("slicing slash on",input);
      input = input.substring(1);
    }

      //request = 'root/';
    request = thisDir.replaceAll('.','/');;
    request += '/';
    request += input;
    arg = request.replaceAll('/','.');

  }  

  console.log("input.length",input.length);
  console.log("request:",request);
  console.log("arg:",arg);
  console.log(' ');

  let cdSucces = 0;

  Object.keys(dotObj).forEach(function(key) {
    var val = dotObj[key];
    if (key == arg) {
      console.log("arg matched",key,"(",val,")");
      let outpath = request.replace('root','User');
      console.log("outpath",outpath);
      if (typeof(val) == 'object') {
        cdSucces = 1;
        console.log(key,"is path");
        var prompt = document.getElementById('prompt');//.innerHTML;
        prompt.innerHTML = outpath+'>';
        //thisTree = dotObj[key][0];
        thisDir = key;
        thisTree = dotObj[key];
        console.log("thisDir",thisDir);
        console.log("thisTree",thisTree);
        //dircmd();        
      } else {
        console.log(key,"is file..");
        output("request is not a path.");
      }

    }
  });

  if (cdSucces == 0) output("no such file or dir.");
}
commands.set('cd', cdcmd);


function dircmd(args) {
  // console.clear();
  let dirTitle = thisDir.split('.').pop();
  // if (args[0].length) {
  //   console.log("dircmd: provided arg!");
  //   dirTitle = args[0];
  // }

  console.log(typeof(thisTree));
  console.log("thisTree: ",thisTree);
  output('');
  output('Directory of '+ dirTitle +':');
  // if (level == 0 && typeof(thisTree) == 'object') {
  if (typeof(thisTree) == 'object') {
    // console.log("dirs.C: ",dirs.C);
    Object.entries(thisTree).forEach(entry => {
      const [key, value] = entry;
      let thisType = null;
      if (typeof(value) == 'object') {thisType = '[DIR]';}
      else {thisType = ''}

      var dirOutput = '';
      dirOutput += ' ';
      dirOutput += key;
      dirOutput += ' ';
      dirOutput += thisType;
      output(dirOutput); 
    });
    output('');
  }
}
commands.set('dir', dircmd);
//commands.set('ls', dircmd);


function echocmd (args) {
  if (args[0].toUpperCase() == 'OFF') {
    echo = false;
    output('Echo is OFF');
  } else if (args[0].toUpperCase() == 'ON') {
    echo = true;
    output('Echo is ON');
  } else {
    output(args.join(' '));
  }
}
commands.set('echo', echocmd);


function treecmd (args) {
  // console.clear();
  // console.log("TREE:");
  // console.log("key:",dotObj['root']);
  clearcmd();
  let objectsLen = Object.keys(dotObj).length-1;
  for (i=objectsLen; i>=0; i--) {
    let thisObj = Object.keys(dotObj)[i].replaceAll('.','/');
    let outStr = thisObj.replace('/root','');
    output(' /'+thisObj);
  }
//  Object.keys(dotObj).forEach(function(key) {
//    var val = dotObj[key];
//    console.log("key:",key);
//    //console.log("key:",key,"; val:",val);
//      if (typeof(val) == 'object') {
//        console.log(key,"is path");
//      } else {
//        console.log(key,"is file..");
//      }
//  });
}
commands.set('tree', treecmd);

function clearcmd(args) {
  document.getElementById('output').innerHTML = '';
}
commands.set('clear', clearcmd);

function loadcmd(args) {
  var target = args[0];
  var cf = ['\\', '|', '/', '-'];
  var out = document.createElement('span');
  out.innerHTML = '-<br>';
  out = document.getElementById('output').appendChild(out);
  var i = 0;
  var intervalId = setInterval(() =>{
    out.innerHTML = cf[i%cf.length];
    i++;
  }, 100);
  setTimeout(() => {
    clearInterval(intervalId);
    clearcmd(); 
    if (target == 'win') window.parent.location.href = "https://dogenigt.dk/systems/windows-95/index.html#restart";
    if (target == 'ftp') window.parent.location.href = "https://dogenigt.dk/terminal/iframe/index.html";
    if (target == 'tv') window.parent.location.href = "https://dogenigt.dk/tv/index.html";
    //$('#prompt').show();
    //$('#carat').show();
  }, 2000);
   $('#prompt').hide();
   $('#carat').hide();
}
commands.set('load', loadcmd);

function helpcmd(args) {
  var helpCmds = {load: ['win','ftp','tv']};
  console.log("helpCmds:"+JSON.stringify(helpCmds));

  if (args.length == 0) {
    for (p of commands) output(' '+p[0]);
    output(' ');
  } else {
    var input = args[0];
    var entry_undefined = (helpCmds[input] === undefined);
    if (!entry_undefined) {
      var cmdList = helpCmds[input];
      console.log("cmdList:"+cmdList+", len: "+cmdList.length);    
      for (i=0;i<cmdList.length;i++) output(input+' '+cmdList[i]);
      output(' ');
    } else { 
      console.log("undefined");
    }
  }
}
commands.set('help', helpcmd);


function listcmd(text) {
  //var textTest = "hello\nthere\nme\nmate\nhello\nthere\nme\nmate\nhello\nthere\nme\nmate";
  var out = document.createElement('span');
  var textTest = "hello\nthere\nme\nmate";
  text = textTest;
  //text = textTest.replace(/\n/g, ' <br>');
  buffer = text.split('\n');
  console.log(text);
  clearcmd();
  out.innerHTML = 'list:<br>';
  out.innerHTML += '<p id="list">';

  for (i=0; i<buffer.length; i++) {
    out.innerHTML += '<span> ';
    out.innerHTML += buffer[i];
    out.innerHTML += '</span><br>';
  }
  out.innerHTML += '</p><br>';
  document.getElementById('output').appendChild(out);
  
}
commands.set('list', listcmd);

function listcmdA(text) {
  //var textTest = "hello\nthere\nme\nmate\nhello\nthere\nme\nmate\nhello\nthere\nme\nmate";
  var textTest = "hello\nthere\nme\nmate";
  var out = document.createElement('span');
  text = textTest;
  buffer = text.split('\n');

  console.log(text);
  clearcmd();
  out.innerHTML = 'list:<br> ';

  if (buffer.length > 10) {
    //text = text.replace(/\n/g, ' <br>');
  } else {
    text = buffer.join('<br> ');

    out.innerHTML += text;
    out.innerHTML += '<br><br>';
    document.getElementById('output').appendChild(out);
  }
}
//commands.set('list', listcmd);

// end Commands

//var testString = "hello\nthere\nme\nmate\nhello\nthere\nme\nmate\nhello\nthere\nme\nmate";
//console.log("testString: ",testString);
//listA(testString);

function listA(text) {
  clearcmd();
  buffer = text.split('\n');

  if (buffer.length > 10) {
    //var bufferOutput = [];
    var bufferOffset = 0;
    var bufferPages = (buffer.length / 10);
    bufferPages = Math.ceil(bufferPages);

    var out = document.createElement('span');
    out.innerHTML = ' list:<br>';

    for (p=0;p<=bufferPages;p++) {
      console.log("\nbufferPage "+p+":");
      for (i=bufferOffset;i<(bufferOffset+10);i++) {
        if (i < buffer.length) {
          out.innerHTML += buffer[i];
          out.innerHTML += '<br>';
          console.log("buffer["+i+"]: "+buffer[i]);          
        }

      }
      bufferOffset+=10;
    }
  }
  console.log("buffer len: ",buffer.length);
  console.log("bufferPages: ",bufferPages);
  //var out = document.createElement('span');
  //out.innerHTML = text.replace(/\n/g, '<br>');
  //out.innerHTML += '<br>';
  //document.getElementById('buffer').appendChild(out);
  //var bufferHeight = $('#buffer').height();
}
//commands.set('list', listcmd);

function output(text) {
  var out = document.createElement('span');
  out.innerHTML = text.replace(/\n/g, '<br>');
  out.innerHTML += '<br>';
  document.getElementById('output').appendChild(out);
  checkHeight();
}

function checkHeight() {
  const conHeight = $('#output').height();
  //console.log(conHeight);
  if (conHeight > 330) {
    if (!readMode) {
      $('#output').find('span:first').remove();
      checkHeight();
    }
  }
}

function checkWidth() {
  const conWidth = $('#output').width();
  //console.log(conHeight);
  //if ($("#pre").width() > conWidth) {
  //
  //}
  return conWidth;
}

function handleKeypress(e) {
  //console.log(e.keyCode)
  if (e.keyCode === 38) {
    if (hist.length) {
      if (histCount < hist.length-1) {
        histCount++;
        document.getElementById('pre').innerHTML = '';
        setTimeout(function(){
          document.getElementById('pre').innerHTML = hist[histCount];
        },50);
      }
    }
  } else if (e.keyCode === 40) {
    if (hist.length) {
      if (histCount > 0) {
        histCount--;
        document.getElementById('pre').innerHTML = '';
        setTimeout(function(){
          document.getElementById('pre').innerHTML = hist[histCount];
        },50);
        //printHist('this');
      }
    }
  } else if (e.keyCode === 37) {
    if (readMode) {
      if (currentPage > 0) {
        currentPage--;
        readPage(currentPage);
      }
    }
  } else if (e.keyCode === 39) {
    if (readMode) {
      if (currentPage < pageLength) {
        currentPage++;
        readPage(currentPage);
      }
    }
  }
  if (e.key.length === 1) {
    if (e.key !== '&') {
      document.getElementById('pre').innerHTML += e.key;      
    }
  } else if (e.key === 'Backspace') {
    var val = document.getElementById('pre').innerHTML;
    document.getElementById('pre').innerHTML = val.slice(0, val.length-1);
  
  } else if (e.key === 'Enter') {
    if (readMode) {
      readMode = 0;
        $('#output').find('span:first').text("Closing file..");
        $('#output').find('span:first').after('<br>');
      //output();
      setTimeout(function(){
        clearcmd();
        $('#container').find('span').show();
        },2000);
        //clearcmd();
    } else {
      var prompt = document.getElementById('prompt').innerHTML;
      var pre = document.getElementById('pre').innerHTML;
      var carat = document.getElementById('carat').innerHTML;
      var post = document.getElementById('post').innerHTML;
      var val = pre + carat + post;

      histCount = -1;
      if (pre.length > 0) {
        hist.push(pre);
      }
      if (echo) {
        output(prompt + val);
      }

      handleInput(val);
      document.getElementById('pre').innerHTML = '';
      document.getElementById('carat').innerHTML = ' ';
      document.getElementById('post').innerHTML = '';
    }
  }
}

function handleInput(input) {
  var args = input.match(/(["']).*?\1|\S+/g);
  if (args) {
    var cmd = commands.get(args.shift());    
    if (cmd) {
      cmd(args);
    } else {
      output("command not found.");
    }
  }
}

function getRandomInt(max) {
  return Math.floor(Math.random() * max);
}


function zeroPad(num, places) {
  var zero = places - num.toString().length + 1;
  return Array(+(zero > 0 && zero)).join("0") + num;
}

function printHist(amount) {
  if (amount == 'ALL') {
    console.clear();
    console.log("hist length: ", hist.length);
   
    hist.forEach(function(item) {
      console.log("hist", item);
    });    
  } else if (amount == 'this') {
    console.log("hist",histCount,":",hist[histCount]);
  }

}