//The RGB blocks to display in the output.
var blocksAcross = Math.round(window.innerWidth / 3) - 10; console.log("blocksAcross: ",blocksAcross);
var blocksDown = Math.round(window.innerHeight); console.log("blocksDown: ",blocksDown);
// var blocksAcross = 40;
// var blocksDown = 40;

//The physical output canvas size.
var outputWidth = 480 * 1.5;
var outputHeight = 360 * 1.5;

//For smaller displays, turn off the phosphor mask to brighten the image.
var showPhosphorMask = true;

//View the various buffers used to make the TV image.
var showCanvasBuffers = false;

// ------------------------------------------

var TV = null;
var ctx = null;
var video = document.createElement("video");

var sourceVideoCanvas = document.getElementById("sourceVideoCanvas");
var sourceVideoCanvasCtx = null;

var outputCanvas = document.getElementById("outputCanvas");
var outputCanvasCtx = null;

var vw = null, vh = null;
var phosphorMask = null;

if(showPhosphorMask) phosphorMask = createRGBFullMask(blocksAcross, blocksDown, outputWidth, outputHeight, createRGBCellCover());

if(!showCanvasBuffers) sourceVideoCanvas.style.display = "none";
  
video.oncanplay = function() {
  if(!sourceVideoCanvasCtx){
    vw = this.videoWidth;
    vh = this.videoHeight;
debugger;
    sourceVideoCanvas.crossOrigin = "Anonymous";
    sourceVideoCanvasCtx = sourceVideoCanvas.getContext("2d");
    sourceVideoCanvas.width = vw;
    sourceVideoCanvas.height = vh;

    outputCanvasCtx = outputCanvas.getContext("2d");
    outputCanvas.width = outputWidth;
    outputCanvas.height = outputHeight;

    TV = new convertTV(blocksAcross, blocksDown, outputWidth, outputHeight, sourceVideoCanvas, outputCanvas, phosphorMask);
    
    video.play();
    
    requestAnimationFrame(nextFrame);
  }
}


//video.muted = video.autoplay = video.loop = true;
video.loop = "loop";
video.muted = "muted";
video.autoplay = true;
video.preload = "auto";
//video.src = "//untamed.co.uk/miscImages/torus.mp4";
video.src = "https://untamed.zone/miscFolder/pizzaCats.mp4";
video.crossOrigin = "Anonymous";

//video.crossOrigin = 'Anonymous';
//video.src = "//media.w3.org/2010/05/bunny/trailer.mp4";
//video.src = "http://html5doctor.com/demos/video-canvas-magic/video.webm";

function createRGBFullMask(blocksAcross, blocksDown, width, height, cellCanvas){
  var screenMaskCanvasLarge = document.createElement("canvas");
  var screenMaskCanvasLargeCtx = screenMaskCanvasLarge.getContext("2d");
  screenMaskCanvasLarge.width = blocksAcross * 150;
  screenMaskCanvasLarge.height = blocksDown * 150;

  for(let y=0; y < blocksDown; y++){
    for(let x=0; x < blocksAcross * 3; x++){
      screenMaskCanvasLargeCtx.drawImage(cellCanvas, x * 50, y * 150);
    }
  }

  var screenMaskCanvasScaled = document.createElement("canvas");
  var screenMaskCanvasScaledCtx = screenMaskCanvasScaled.getContext("2d");
  screenMaskCanvasScaled.width = width;
  screenMaskCanvasScaled.height = height;
  screenMaskCanvasScaledCtx.imageSmoothingEnabled = true;
  screenMaskCanvasScaledCtx.drawImage(screenMaskCanvasLarge, 0, 0, width, height);

  if(showCanvasBuffers) document.body.appendChild(screenMaskCanvasScaled);
  return screenMaskCanvasScaled;
}

function createRGBCellCover(){
  var cellMaskCanvas = document.createElement("canvas");
  var cellMaskCanvasCtx = cellMaskCanvas.getContext("2d");
  cellMaskCanvas.width = 50;
  cellMaskCanvas.height = 150;
  cellMaskCanvasCtx.fillStyle = "black";
  cellMaskCanvasCtx.fillRect(0, 0, cellMaskCanvas.width, cellMaskCanvas.height);
  cellMaskCanvasCtx.shadowBlur = 10;
  cellMaskCanvasCtx.shadowColor = 'rgb(255, 255, 255)';
  cellMaskCanvasCtx.strokeStyle = "rgb(255, 255, 255)";
  cellMaskCanvasCtx.lineCap = "round";
  cellMaskCanvasCtx.lineWidth = 28;
  cellMaskCanvasCtx.beginPath();
  for(let i=0; i<3; i++){
    cellMaskCanvasCtx.moveTo(25, 25);
    cellMaskCanvasCtx.lineTo(25, 125);
    cellMaskCanvasCtx.stroke();
  }
  var imageData = cellMaskCanvasCtx.getImageData(0, 0, 50, 150);
  var imageArray = imageData.data;
  var buff8 = new Uint8ClampedArray(imageArray.buffer);
  //var buff32 = new Uint32Array(imageArray.buffer);
  var length = buff8.length;
  for(let i = 0; i < length; i +=4 ) {
    buff8[i+3] = 255 - buff8[i];
    buff8[i] = 0;
    buff8[i+1] = 0;
    buff8[i+2] = 0;
  }
  cellMaskCanvasCtx.putImageData(imageData, 0, 0);
  if(showCanvasBuffers) document.body.appendChild(cellMaskCanvas);
  return cellMaskCanvas;
}


function convertTV(blocksAcross, blocksDown, outputWidth, outputHeight, sourceCanvas, outputCanvas, mask){
  this.mask = mask;

  this.blocksAcross = blocksAcross;
  this.blocksDown = blocksDown;

  this.outputWidth = outputWidth;
  this.outputHeight = outputHeight;

  this.smallOutputCanvas = document.createElement("canvas");
  this.smallOutputCanvasCtx = this.smallOutputCanvas.getContext("2d");
  this.smallOutputCanvas.width = blocksAcross * 3;
  this.smallOutputCanvas.height = blocksDown;
  this.smallOutputWidth = this.smallOutputCanvas.width;
  this.smallOutputHeight = this.smallOutputCanvas.height;

  //if(showCanvasBuffers) document.body.appendChild(this.smallOutputCanvas);
  document.body.appendChild(this.smallOutputCanvas);
  this.outputCanvas = outputCanvas;
  this.outputCanvasCtx = outputCanvas.getContext("2d");
  this.outputCanvasCtx.imageSmoothingEnabled = false;

  this.sourceCanvas = sourceCanvas;
  this.sourceCanvasCtx = sourceCanvas.getContext("2d");
  this.sourceWidth = sourceCanvas.width;
  this.sourceHeight = sourceCanvas.height;

  this.scanStepWidth = this.sourceWidth / this.blocksAcross;
  this.scanStepHeight = this.sourceHeight / this.blocksDown;

  this.outputImageData = this.smallOutputCanvasCtx.getImageData(0, 0, this.smallOutputCanvas.width, this.smallOutputCanvas.height);
  this.outputImageArray = this.outputImageData.data;
  this.outputBuff8 = new Uint8ClampedArray(this.outputImageArray.buffer);
  this.outputBuff32 = new Uint32Array(this.outputImageArray.buffer);
}

convertTV.prototype.createMiniFrame = function(){
  var imageData = this.sourceCanvasCtx.getImageData(0, 0, this.sourceWidth, this.sourceHeight);
  var imageArray = imageData.data;
  //  var buff8 = new Uint8ClampedArray(imageArray.buffer);
  var buff32 = new Uint32Array(imageArray.buffer);
  var outY = 0;

  for(let y = 0; y < this.sourceHeight; y += this.scanStepHeight){
    var outputPixelIndex = (outY * this.smallOutputWidth) ;
    var intY = Math.round(y);
    var pixelIndex = intY * this.sourceWidth;
    for(let x = 0; x < this.sourceWidth; x += this.scanStepWidth){
      var intX = Math.round(x);
      var pixel = buff32[pixelIndex + intX];
      this.outputBuff32[outputPixelIndex++] = pixel & 0xFF0000FF;
      this.outputBuff32[outputPixelIndex++] = pixel & 0xFF00FF00;
      this.outputBuff32[outputPixelIndex++] = pixel & 0xFFFF0000;
    }
    outY +=1 ;
  }

  this.smallOutputCanvasCtx.putImageData(this.outputImageData, 0, 0);
  this.outputCanvasCtx.drawImage(this.smallOutputCanvas, 0, 0, this.outputWidth, this.outputHeight);
  if(this.mask != null) this.outputCanvasCtx.drawImage(this.mask, 0, 0, this.outputWidth, this.outputHeight);
}


function nextFrame() {
  sourceVideoCanvasCtx.drawImage(video, 0, 0, vw, vh);
  TV.createMiniFrame();
  requestAnimationFrame(function() {requestAnimationFrame(nextFrame)});
}