#/bin/bash

SCRIPT=$(readlink -f "$0")
DIR=$(cd "$(dirname $SCRIPT)" && pwd)

# ------------------------------------------------------------------------------------------------------------


WIDTH=$(cat /sys/class/graphics/fb0/stride)
HEIGHT=$(cat /sys/class/graphics/fb0/virtual_size | cut -d, -f2)

BLUE=`printf '\\\\xff\\\\x00\\\\x00\\\\x00%0.s' $(seq 1 $WIDTH)`
GREEN=`printf '\\\\x00\\\\x80\\\\x00\\\\x00%0.s' $(seq 1 $WIDTH)`
RED=`printf '\\\\x00\\\\x00\\\\xff\\\\x00%0.s' $(seq 1 $WIDTH)`
BLACK=`printf '\\\\x00\\\\x00\\\\x00\\\\x00%0.s' $(seq 1 $WIDTH)`
WHITE=`printf '\\\\xff\\\\xff\\\\xff\\\\x00%0.s' $(seq 1 $WIDTH)`
PURPLE=`printf '\\\\x80\\\\x00\\\\x80\\\\x00%0.s' $(seq 1 $WIDTH)`
GREY=`printf '\\\\x80\\\\x80\\\\x80\\\\x00%0.s' $(seq 1 $WIDTH)`
LIME=`printf '\\\\x00\\\\xff\\\\x00\\\\x00%0.s' $(seq 1 $WIDTH)`
YELLOW=`printf '\\\\x00\\\\xff\\\\xff\\\\x00%0.s' $(seq 1 $WIDTH)`
AQUA=`printf '\\\\xff\\\\xff\\\\x00\\\\x00%0.s' $(seq 1 $WIDTH)`
SILVER=`printf '\\\\xc0\\\\xc0\\\\xc0\\\\x00%0.s' $(seq 1 $WIDTH)`
FUCHSIA=`printf '\\\\xff\\\\x00\\\\xff\\\\x00%0.s' $(seq 1 $WIDTH)`
MAROON=`printf '\\\\x00\\\\x00\\\\x80\\\\x00%0.s' $(seq 1 $WIDTH)`
TEAL=`printf '\\\\x80\\\\x80\\\\x00\\\\x00%0.s' $(seq 1 $WIDTH)`
NAVY=`printf '\\\\x80\\\\x00\\\\x00\\\\x00%0.s' $(seq 1 $WIDTH)`
OLIVE=`printf '\\\\x00\\\\x80\\\\x80\\\\x00%0.s' $(seq 1 $WIDTH)`


COLORS=( $BLACK $MAROON $GREEN $OLIVE $NAVY $PURPLE $TEAL $SILVER $GREY $RED $LIME $YELLOW $BLUE $FUCHSIA $AQUA $WHITE )

declare -Ag COLORS_TABLE=( \
  [BLACK]=$BLACK \
  [MAROON]=$MAROON \
  [GREEN]=$GREEN \
  [OLIVE]=$OLIVE \
  [NAVY]=$NAVY \
  [PURPLE]=$PURPLE \
  [TEAL]=$TEAL \
  [SILVER]=$SILVER \
  [GREY]=$GREY \
  [RED]=$RED \
  [LIME]=$LIME \
  [YELLOW]=$YELLOW \
  [BLUE]=$BLUE \
  [FUCHSIA]=$FUCHSIA \
  [AQUA]=$AQUA \
  [WHITE]=$WHITE \
)

functions=( \
  drawColumns \
  drawLines \
  gradients \
  fullColorRandom \
  vaporShapes \
  drawRGBLines \
  scanlines_thick \
)

# ------------------------------------------------------------------------------------------------------------


Saver() {
  terminalLines GREEN >/dev/null 2>&1
  drawStatic 50 >/dev/null 2>&1
  fillScreenLines >/dev/null 2>&1

  while :; do
    tiles >/dev/null 2>&1
    drawCanvasRandom 1 >/dev/null 2>&1
    tilesThin 8 >/dev/null 2>&1
    drawCanvasRandom 1 >/dev/null 2>&1
    fillScreenLines >/dev/null 2>&1

    fullColorRandom >/dev/null 2>&1
    gradients >/dev/null 2>&1
    vapor >/dev/null 2>&1
    scanlines_thick >/dev/null 2>&1
    vertRandLines >/dev/null 2>&1
    drawCanvasRandom 1 >/dev/null 2>&1
    drawColumns >/dev/null 2>&1
    widthLines 3 >/dev/null 2>&1
    fullColorRandom >/dev/null 2>&1
    drawCanvasRandom 1 >/dev/null 2>&1
    vaporGlitch >/dev/null 2>&1
  done
}

# ------------------------------------------------------------------------------------------------------------

gradients() {
    for (( i=0; i<$HEIGHT; i++ )); do N=$(( (i-255)/2 )); N=${N##'-'}; printf "\x$(printf %02x $(( 255 - N )))\x$(printf %02x $N)\x$(printf %02x $(( N * 2 )))\x00%0.s" $(seq 1 $WIDTH) | dd bs=1 seek=$(( WIDTH * i )) of=/dev/fb0; done >/dev/null 2>&1
    for (( i=0; i<$HEIGHT; i++ )); do N=$(( (i-255)/2 )); N=${N##'-'}; printf "\x$(printf %02x $(( N * 2 )))\x$(printf %02x $(( 255 - N )))\x$(printf %02x $N)\x00%0.s" $(seq 1 $WIDTH) | dd bs=1 seek=$(( WIDTH * i )) of=/dev/fb0; done >/dev/null 2>&1
    for (( i=0; i<$HEIGHT; i++ )); do N=$(( i-255 )); N=${N##'-'}; printf "\x$(printf %02x $(( 255 - N )))\x$(printf %02x $N)\x$(printf %02x $N)\x00%0.s" $(seq 1 $WIDTH) | dd bs=1 seek=$(( WIDTH * i )) of=/dev/fb0; done >/dev/null 2>&1
    for (( i=0; i<$HEIGHT; i++ )); do N=$(( i-255 )); N=${N##'-'}; printf "\x$(printf %02x $(( 255 - N )))\x$(printf %02x $N)\x$(printf %02x $(( 255 - N )))\x00%0.s" $(seq 1 $WIDTH) | dd bs=1 seek=$(( WIDTH * i )) of=/dev/fb0; done >/dev/null 2>&1
    for (( i=0; i<$HEIGHT; i++ )); do N=$(( (i-255)/2 )); N=${N##'-'}; printf "\x$(printf %02x $N)\x$(printf %02x $(( 255 - N )))\x$(printf %02x $(( ( N * 2 ) % 255 )))\x00%0.s" $(seq 1 $WIDTH) | dd bs=1 seek=$(( WIDTH * i )) of=/dev/fb0; done >/dev/null 2>&1
    for (( i=0; i<$HEIGHT; i++ )); do N=$(( i-255 )); N=${N##'-'}; printf "\x$(printf %02x $N)\x$(printf %02x $N)\x$(printf %02x $(( 255 - N )))\x00%0.s" $(seq 1 $WIDTH) | dd bs=1 seek=$(( WIDTH * i )) of=/dev/fb0; done >/dev/null 2>&1
    for (( i=0; i<$HEIGHT; i++ )); do N=$(( i-255 )); N=${N##'-'}; printf "\x$(printf %02x $N)\x$(printf %02x $(( 255 - N )))\x$(printf %02x $N)\x00%0.s" $(seq 1 $WIDTH) | dd bs=1 seek=$(( WIDTH * i )) of=/dev/fb0; done >/dev/null 2>&1
}

# ------------------------------------------------------------------------------------------------------------

widthLines() {
  repeats=${1:-3}; postDel=${2:-2}

  for i in $(seq 1 $repeats); do

    COL_MAX=4; COL_COUNT=$(( ( RANDOM % $COL_MAX ) + 2 ))
    H_MAX=4; LN_H=$(( ( RANDOM % $H_MAX ) + 2 ))
    INDEX=0; COUNT=1; COL=(); for i in $(seq 0 $COL_COUNT); do COL+=("${COLORS[$((RANDOM % ${#COLORS[@]}))]}"); done

    while [[ $COUNT -le $HEIGHT ]]; do
      (( INDEX++ )); INDEX=$(( INDEX % ${#COL[@]} )); COLOR="${COL[$INDEX]}"
      for i in $(seq 1 $LN_H); do printf $COLOR; done | dd bs=$COUNT seek=$(( WIDTH * LN_H )) of=/dev/fb0 >/dev/null 2>&1; COUNT=$(( COUNT + LN_H ))
    done; sleep $postDel
  done
}

# ------------------------------------------------------------------------------------------------------------

vapor() {
  vaporShapes 2			# summer horizon
  vaporShapes 4 		# vertical lines with horizontal (3) stripes
  vaporShapes 6 		# laser etcher /w gradient lines
  vaporShapes 8 		# textile pattern
  vaporShapes 7 		# texture pattern
  vaporShapes 9 		# chrome surface /w gradient
  #vaporShapes 3 		# vertical rgb lines
}

vaporShapes() {
  mode="${1:-$(( ( RANDOM % 10 ) + 1 ))}"
  case "$mode" in
    1) for (( i=0; i<$HEIGHT; i++ )); do printf "\x$(printf %02x $(( i % 10 )) )\x$(printf %02x $i)\x$(printf %02x $(( HEIGHT % i )))\x00%0.s" $(seq 1 $WIDTH) | dd bs=1 seek=$(( i * WIDTH )) of=/dev/fb0; done ;;
    2) for (( i=0; i<$HEIGHT; i++ )); do printf "\x$(printf %02x $(( i % 128 )) )\x$(printf %02x $i)\x$(printf %02x $(( HEIGHT - i )))\x00%0.s" $(seq 1 $WIDTH) | dd bs=1 seek=$(( i * WIDTH )) of=/dev/fb0; done ;;
    3) for (( i=0; i<$HEIGHT; i++ )); do printf "\x$(printf %02x $(( 255 - ( -i ) )) )\x$(printf %02x $i)\x$(printf %02x $(( HEIGHT % 128 - i )))\x00%0.s" $(seq 1 $WIDTH) | dd bs=1 seek=$(( i * WIDTH )) of=/dev/fb0; done ;;
    4) for (( i=0; i<$HEIGHT; i++ )); do printf "\x$(printf %02x $(( ( -i % 64 ) + 20 )) )\x$(printf %02x $i)\x$(printf %02x $(( HEIGHT - i )))\x00%0.s" $(seq 1 $WIDTH) | dd bs=1 seek=$(( i * WIDTH )) of=/dev/fb0; done ;;
    5) for (( i=0; i<$HEIGHT; i++ )); do printf "\x$(printf %02x $(( ( -i % 64 ) + 20 )) )\x$(printf %02x $i)\x$(printf %02x $(( HEIGHT - i )))\x00%0.s" $(seq 1 $WIDTH) | dd bs=1 seek=$(( i * ( WIDTH - (HEIGHT*2)) )) of=/dev/fb0; done ;;
    6) for (( i=0; i<$HEIGHT; i++ )); do printf "\x$(printf %02x $(( ( -i % 32 ) + 20 )) )\x$(printf %02x $i)\x$(printf %02x $(( HEIGHT - i )))\x00%0.s" $(seq 1 $WIDTH) | dd bs=1 seek=$(( i * ( WIDTH + i ) )) of=/dev/fb0; done ;;
    7) for (( i=0; i<$HEIGHT; i++ )); do printf "\x$(printf %02x $(( 255 * (i - HEIGHT )  )) )\x$(printf %02x $i)\x$(printf %02x $(( HEIGHT - i )))\x00%0.s" $(seq 1 $WIDTH) | dd bs=1 seek=$(( i * ( WIDTH + i ) )) of=/dev/fb0; done ;;
    8) for (( i=0; i<$HEIGHT; i++ )); do printf "\x$(printf %02x $(( ( RANDOM % 255 ) - i  )) )\x$(printf %02x $i)\x$(printf %02x $(( HEIGHT - i )))\x00%0.s" $(seq 1 $WIDTH) | dd bs=1 seek=$(( i * ( WIDTH + i ) )) of=/dev/fb0; done ;;
    9) for (( i=0; i<$HEIGHT; i++ )); do printf "\x$(printf %02x $(( ( HEIGHT - i ) % ( 255 - (-i))  )) )\x$(printf %02x $i)\x$(printf %02x $(( HEIGHT - i )))\x00%0.s" $(seq 1 $WIDTH) | dd bs=1 seek=$(( i * ( WIDTH + i ) )) of=/dev/fb0; done ;;
    *) ;;
  esac
}

vaporGlitch() {
  mode="${1:-0}"
  case "$mode" in
    0 )for (( i=0; i<$WIDTH;  i++ )); do printf "\x$(printf %02x $(( ( $(( RANDOM % 255 )) * i ) - i  )) )\x$(printf %02x $i)\x$(printf %02x $(( ( ( RANDOM % 4 ) * i ) - i )) )\x00%0.s" $(seq 1 $WIDTH) | dd bs=1 seek=$((  WIDTH * i / $(( RANDOM % (i/4) )) + ( WIDTH / 2 )  )) of=/dev/fb0; done ;;
    *) ;;
  esac
}

# ------------------------------------------------------------------------------------------------------------

drawRGBLines() {
  COLORS=("$RED" "$LIME" "$BLUE"); INDEX=0
  for (( i=0; i<$HEIGHT; i++ )); do
    (( INDEX++ )); printf "${COLORS[$(( INDEX % ${#COLORS[@]} ))]}" | dd bs=1 seek=$(($i * $WIDTH )) of=/dev/fb0 &>/dev/null
  done
}

# ------------------------------------------------------------------------------------------------------------

drawStatic() {
  limit=${1:-100}
  for (( i=0; i<$limit; i++ )); do timeout 0.0145 cat /dev/urandom > /dev/fb0; sleep 0.01; done &>/dev/null
}

# ------------------------------------------------------------------------------------------------------------

drawNoise() {
  width=$(cat /sys/class/graphics/fb0/stride);  height=$(cat /sys/class/graphics/fb0/virtual_size | cut -d, -f2)
  clear && sleep 1
  for (( i=0; i<$height; i++ )); do
    cat /dev/urandom | dd bs=1 count=$width | dd bs=1 seek=$(( $i * $width + $i )) of=/dev/fb0 &>/dev/null
  done
}

# ------------------------------------------------------------------------------------------------------------

scanlines_thick() {
  width=$(cat /sys/class/graphics/fb0/stride); height=$(cat /sys/class/graphics/fb0/virtual_size | cut -d, -f2); height=$(( height / 2 ))
  for (( i=0; i<$height; i++ )); do
    GREEN=`printf '\\\\x00\\\\xff\\\\x00\\\\x00%0.s' $(seq 1 $width)`
    printf "$GREEN" | dd bs=1 seek=$(( $(( i * 2 )) * width + i )) of=/dev/fb0 &>/dev/null
  done
}

# ------------------------------------------------------------------------------------------------------------

scanlines() {
  width=$(cat /sys/class/graphics/fb0/stride); height=$(cat /sys/class/graphics/fb0/virtual_size | cut -d, -f2) #height=$(( height / 2 ))

  for (( i=0; i<$height; i++ )); do
    local ARMY=`printf '\\\\x00\\\\x80\\\\x00\\\\x00%0.s' $(seq 1 $width)`
    local GREEN=`printf '\\\\x00\\\\xff\\\\x00\\\\x00%0.s' $(seq 1 $width)`
    local BLACK=`printf '\\\\x00\\\\x00\\\\x00\\\\x00%0.s' $(seq 1 $WIDTH)`

    printf "${ARMY}" | dd bs=1 count=$width seek=$(( $i * $width )) of=/dev/fb0 &>/dev/null; (( i++ ))
    printf "${BLACK}" | dd bs=1 count=$width seek=$(( $i * $width )) of=/dev/fb0 &>/dev/null
  done

  for c in {1..2}; do
  for (( i=0; i<$height; i++ )); do
    printf "${GREEN}" | dd bs=1 count=$width seek=$(( $i * $width )) of=/dev/fb0 &>/dev/null; (( i++ ))
    printf "${BLACK}" | dd bs=1 count=$width seek=$(( $i * $width )) of=/dev/fb0 &>/dev/null
    printf "${ARMY}" | dd bs=1 count=$width seek=$(( $(( i - 1 )) * $width )) of=/dev/fb0 &>/dev/null
  done; done
  sleep 3
}

# ------------------------------------------------------------------------------------------------------------

fullColorRandom() {
  for (( i=0; i<$HEIGHT; i++ )); do printf "\x$(printf %02x $(( RANDOM % 255 )))\x$(printf %02x $(( RANDOM % 255 )))\x$(printf %02x $(( RANDOM % 255 )))\x00%0.s" $(seq 1 $WIDTH) | dd bs=1 seek=$(( i * WIDTH )) of=/dev/fb0; done
}

# ------------------------------------------------------------------------------------------------------------

drawColumns() {
  COL_W=10; COL_H=8
  W=$(( WIDTH / COL_W )); R=$(( RANDOM % 255 )); G=$(( RANDOM % 255 )); B=$(( RANDOM % 255 ));

  for (( i=1; i<HEIGHT; i++ )); do
    for (( n=0; n<COL_W; n++ )); do
      printf "\x$(printf %02x $R)\x$(printf %02x $G)\x$(printf %02x $B)\x00%0.s" $(seq 1 $W) | dd bs=1 seek=$(( ( i * WIDTH ) + ( n * W ) )) of=/dev/fb0 &>/dev/null
    done
    [[ $(( i % COL_H )) -eq 0 ]] && { R=$(( RANDOM % 255 )); G=$(( RANDOM % 255 )); B=$(( RANDOM % 255 )); }
  done
}

# ------------------------------------------------------------------------------------------------------------

paintRandom() {
  R=$(( RANDOM % 255 )); G=$(( RANDOM % 255 )); B=$(( RANDOM % 255 ))
  for (( i=0; i<$HEIGHT; i++ )); do printf "\x$(printf %02x $R)\x$(printf %02x $G)\x$(printf %02x $B)\x00%0.s" $(seq 1 $WIDTH) | dd bs=1 seek=$(( i * WIDTH )) of=/dev/fb0; done
}

# ------------------------------------------------------------------------------------------------------------

pearlescent() {
  local W=$(( WIDTH / 4 ));

  for (( l=0; l<HEIGHT; l++)); do
    for (( n=0; n<W; n++ )); do
      printf "\x$(printf '%02x' $(( RANDOM % 255 )))\x$(printf '%02x' $(( RANDOM % 255 )))\x$(printf '%02x' $(( RANDOM % 255 )))\x00" \
      | dd bs=64 count=$(( W * 2 )) | dd bs=8 seek=$(( ( ( W * 2 ) * l ) + n ))  of=/dev/fb0
    done
  done
}

# ------------------------------------------------------------------------------------------------------------

drawCanvas() {
  local CANVAS=''
  local ARG="$@"
  local COLOR=

  if [[ $# -lt 1 ]]; then
    COLOR=`printf "\\\\x$(printf %02x $(( RANDOM % 255 )))\\\\x$(printf %02x $(( RANDOM % 255 )))\\\\x$(printf %02x $(( RANDOM % 255 )))\\\\\\\\x00%0.s" $(seq 1 $WIDTH)`
  else
    if [[ $( echo "$ARG" | grep -c "[[:digit:]]") -gt 0 ]]; then
      COLOR="${COLORS[$(( $ARG % ${#COLORS[@]} ))]}"
    elif [[ $( echo "$@" | grep -c "[[:alpha:]]") -gt 0 ]]; then
      if [[ "${ARG^^}" == RANDOM ]]; then
        COLOR=`printf "\\\\x$(printf %02x $(( RANDOM % 255 )))\\\\x$(printf %02x $(( RANDOM % 255 )))\\\\x$(printf %02x $(( RANDOM % 255 )))\\\\\\\\x00%0.s" $(seq 1 $WIDTH)`
      elif [[ "${!COLORS_TABLE[@]}" =~ "${ARG^^}" ]]; then
        COLOR="${COLORS_TABLE[${ARG^^}]}"
      else
        COLOR="${COLORS[$(( RANDOM % ${#COLORS[@]} ))]}"
      fi
    fi
  fi

  for (( i=0; i<$HEIGHT; i++ )); do CANVAS+="${COLOR}"; done
  (printf "${CANVAS}" > /dev/fb0 | head -n 1) >/dev/null 2>&1
}

# ------------------------------------------------------------------------------------------------------------

drawCanvasRandom() {
  local CANVAS=
  local COLOR=
  local LOOP=${1:-1}
  local DELAY=${2:-0}

  for i in $(seq 1 $LOOP); do
    CANVAS=''; COLOR=`printf "\\\\x$(printf %02x $(( RANDOM % 255 )))\\\\x$(printf %02x $(( RANDOM % 255 )))\\\\x$(printf %02x $(( RANDOM % 255 )))\\\\\\\\x00%0.s" $(seq 1 $WIDTH)`
    for (( i=0; i<$HEIGHT; i++ )); do CANVAS+="${COLOR}"; done
    (printf "${CANVAS}" > /dev/fb0 | head -n 1) >/dev/null 2>&1
    sleep $DELAY
  done
}

# ------------------------------------------------------------------------------------------------------------

tilesThin() {
  local DIV=
  local ADD_W=${1:-20}
  local COUNT=0
  local COLOR=''

  for l in $(seq 0 $HEIGHT); do
    COUNT=0
    while [[ $COUNT -lt $WIDTH ]]; do
      DIV=$(( (RANDOM % ADD_W) + 4 ))
      COLOR=`printf "\\\\x$(printf %02x $(( RANDOM % 255 )))\\\\x$(printf %02x $(( RANDOM % 255 )))\\\\x$(printf %02x $(( RANDOM % 255 )))\\\\\\\\x00%0.s" $(seq 1 $(( WIDTH / DIV )) )`
      printf $COLOR | dd bs=1 count=$(( WIDTH / DIV )) seek=$(( COUNT + (WIDTH * l) )) of=/dev/fb0 >/dev/null 2>&1
      COUNT=$(( COUNT + ( WIDTH / DIV ) ))
    done
  done
}

# ------------------------------------------------------------------------------------------------------------

tiles() {
  local COUNT_H=1
  local COUNT_W=0
  local LINE='';

  local ADD_W=${1:-20}
  local ADD_H=${2:-8}

  local DIV_W=0
  local DIV_H=$(( ( RANDOM % ADD_H ) + 2 ))

  while [[ $COUNT_H -lt $HEIGHT ]]; do
    COUNT_W=0; LINE=''

    while [[ $COUNT_W -lt $WIDTH ]]; do
      DIV_W=$(( (RANDOM % ADD_W) + 1 ))
      COLOR=`printf "\\\\x$(printf %02x $(( RANDOM % 255 )))\\\\x$(printf %02x $(( RANDOM % 255 )))\\\\x$(printf %02x $(( RANDOM % 255 )))\\\\\\\\x00%0.s" $(seq 1 $(( WIDTH / DIV_W )) )`
      LINE=${LINE}${COLOR}
      COUNT_W=$(( COUNT_W + ( WIDTH / DIV_W ) ))
    done
    for c in $(seq 1 $ADD_H); do
      printf $LINE | dd bs=1 count=$WIDTH seek=$(( WIDTH * COUNT_H )) of=/dev/fb0 >/dev/null 2>&1
      (( COUNT_H++ ))
    done
  done
}

# ------------------------------------------------------------------------------------------------------------

shrink() {
  local BG_COLOR="${1}"
  local BLACK_PX=`printf '\\\\x00\\\\x00\\\\x00\\\\x00%0.s' $(seq 1 1)`
  local BOT=$(( HEIGHT / 2 ))

  for (( TOP=0; TOP<$(( HEIGHT / 4 )); TOP+=2 )); do
    printf $BLACK | dd bs=2 count=$(( WIDTH*2 )) seek=$(( WIDTH * TOP )) of=/dev/fb0
    printf $BLACK | dd bs=2 count=$(( WIDTH*2 )) seek=$(( WIDTH * BOT )) of=/dev/fb0
    BOT=$(( BOT - 2 ))
  done

  printf $BLACK | dd bs=1 count=$WIDTH seek=$(( WIDTH*((HEIGHT/2)+2) )) of=/dev/fb0
  [[ ${#BG_COLOR} -gt 0 ]] && printf $BG_COLOR | dd bs=1 count=$WIDTH seek=$(( WIDTH*((HEIGHT/2)+1) )) of=/dev/fb0

  for (( i=1; i<$(( WIDTH / 2 )); i+=2 )); do
    printf $BLACK_PX | dd count=$i bs=1 seek=$(( (WIDTH*((HEIGHT/2)+1))+i )) of=/dev/fb0
    printf $BLACK_PX | dd count=$i bs=1 seek=$(( (WIDTH*((HEIGHT/2)+1))+(WIDTH-i) )) of=/dev/fb0
    i=$(( i+2 ))
  done
}

# ------------------------------------------------------------------------------------------------------------

terminalLines() {
  local COUNT=1
  local COLOR=${1:-'BLACK'}

  [[ "${!COLORS_TABLE[@]}" =~ "${COLOR^^}" ]] && COLOR=${COLORS_TABLE[$COLOR]} || COLOR=$BLACK

  while [[ $COUNT -lt $HEIGHT ]]; do
    printf $COLOR | dd bs=1 count=$WIDTH seek=$(( WIDTH * COUNT )) of=/dev/fb0
    COUNT=$(( COUNT+2 ))
  done

  COUNT=1
  while [[ $COUNT -lt $HEIGHT ]]; do
    printf $LIME | dd bs=1 count=$WIDTH seek=$(( WIDTH * COUNT )) of=/dev/fb0
    COUNT=$(( COUNT+2 ))
    [[ $COUNT -gt 2 ]] && printf $COLOR | dd bs=1 count=$WIDTH seek=$(( WIDTH * ( COUNT-2 ) )) of=/dev/fb0
  done
  shrink $COLOR >/dev/null 2>&1
}

# ------------------------------------------------------------------------------------------------------------

fillScreenLines() {
  local COLOR=`printf "\\\\x$(printf %02x $(( RANDOM % 255 )))\\\\x$(printf %02x $(( RANDOM % 255 )))\\\\x$(printf %02x $(( RANDOM % 255 )))\\\\\\\\x00%0.s" $(seq 1 $WIDTH)`
  for i in $(seq 1 $HEIGHT | shuf); do printf $COLOR | dd bs=1 seek=$(( WIDTH * i )) of=/dev/fb0 >/dev/null 2>&1; done
}

# ------------------------------------------------------------------------------------------------------------

vertRandLines() {
  (cat /dev/urandom | dd bs=1 count=$(cat /sys/class/graphics/fb0/stride) > /tmp/dump) >/dev/null 2>&1
  for i in $(seq 1 $HEIGHT); do cat /tmp/dump | dd bs=1 seek=$(( $WIDTH * i )) of=/dev/fb0 >/dev/null 2>&1; done
}

# ------------------------------------------------------------------------------------------------------------

fillScreenURandLines() {
  for l in $(seq 1 $HEIGHT | shuf); do (cat /dev/urandom | dd bs=1 count=$WIDTH | dd bs=1 seek=$(( WIDTH * l )) of=/dev/fb0) >/dev/null 2>&1; done
}

# ------------------------------------------------------------------------------------------------------------

randomPixelsMono() {
  seq 1 $(( WIDTH * HEIGHT )) | shuf > /tmp/fbmatrix
  while read p; do printf '\\\\x00\\\\xff\\\\x00\\\\x00' | dd bs=1 seek=$p of=/dev/fb0 >/dev/null 2>&1; done< <(cat /tmp/fbmatrix)
  rm /tmp/fbmatrix
}

# ------------------------------------------------------------------------------------------------------------

clearBuffer() {
  (cat /dev/zero > /dev/fb0 | head -n 1) >/dev/null 2>&1
}

# ------------------------------------------------------------------------------------------------------------

if [[ "${BASH_SOURCE[0]}" == "${0}" ]]; then

  NUM="$@"

  exitFunc() {
    #export PS1="$PS1_STORED"; sudo setterm --cursor on
    JOBS=($(jobs -p)); [[ ${#JOBS[@]} -gt 0 ]] && { kill $(jobs -rp); wait $(jobs -rp) 2>/dev/null; }
    #printf 'clear\r' > /tmp/vkbdd.fifo
    #sudo -- bash -c "setterm --cursor on --term linux </dev/tty1"

    [ -f /tmp/fbmatrix ] && rm /tmp/fbmatrix
    exit
  }

  #sudo -- bash -c "setterm --cursor off --term linux </dev/tty1"
  trap 'exitFunc' EXIT SIGINT INT KILL TERM

  clear

  #drawCanvasRandom >/dev/null 2>&1
  #drawCanvas $NUM

  Saver
  exit
fi




# ____________________________________________________________________________________________________________


SaverBAK() {
  terminalLines GREEN >/dev/null 2>&1
  drawStatic 50 >/dev/null 2>&1
  fillScreenLines >/dev/null 2>&1

  while :; do
    tiles >/dev/null 2>&1
    drawCanvasRandom 1 >/dev/null 2>&1
    tilesThin 8 >/dev/null 2>&1
    drawCanvasRandom 1 >/dev/null 2>&1
    fillScreenLines >/dev/null 2>&1

    fullColorRandom >/dev/null 2>&1
    gradients >/dev/null 2>&1
    vapor >/dev/null 2>&1
    scanlines_thick >/dev/null 2>&1
    vertRandLines >/dev/null 2>&1
    drawCanvasRandom 1 >/dev/null 2>&1
    drawColumns >/dev/null 2>&1
    widthLines 3 >/dev/null 2>&1
    fullColorRandom >/dev/null 2>&1
    drawCanvasRandom 1 >/dev/null 2>&1
    vaporGlitch >/dev/null 2>&1
  done


  #drawCanvas GREEN >/dev/null 2>&1 # REM
  #fillScreenURandLines >/dev/null 2>&1
  #vertRandLines >/dev/null 2>&1
  ##drawCanvasRandom 1 >/dev/null 2>&1
  ##drawCanvas WHITE >/dev/null 2>&1
  ##randomPixelsMono
  #
  #while :; do
  #  drawCanvasRandom 1 >/dev/null 2>&1
  #  fillScreenLines >/dev/null 2>&1
  #  tiles >/dev/null 2>&1
  #  drawCanvasRandom 1 >/dev/null 2>&1
  #  fillScreenURandLines >/dev/null 2>&1
  #  drawCanvasRandom 1 >/dev/null 2>&1
  #  tilesThin 50 >/dev/null 2>&1
  #done
}

Saver_old() {
  clear
  while :; do
    #timer=$(echo $(( 10#$(date +%s) ))) # REM

    drawStatic 50 >/dev/null 2>&1
    drawRGBLines >/dev/null 2>&1
    drawCanvasRandom 5 1 >/dev/null 2>&1
    fullColorRandom >/dev/null 2>&1
    gradients >/dev/null 2>&1
    vapor >/dev/null 2>&1
    scanlines_thick >/dev/null 2>&1
    vertRandLines >/dev/null 2>&1
    drawCanvasRandom 1 >/dev/null 2>&1
    #paintRandom >/dev/null 2>&1
    drawColumns >/dev/null 2>&1
    widthLines 3 >/dev/null 2>&1
    fullColorRandom >/dev/null 2>&1
    drawCanvasRandom 1 >/dev/null 2>&1
    #paintRandom >/dev/null 2>&1
    vaporGlitch >/dev/null 2>&1

    #echo "$(( $(echo $(( 10#$(date +%s) ))) - $timer ))" | sudo tee "$DIR/script_time.log" #&>/dev/null
  done
}

# ------------------------------------------------------------------------------------------------------------

terminalLinesBAK() {
  clearBuffer

  local COUNT=1
  while [[ $COUNT -lt $HEIGHT ]]; do
    printf $GREEN | dd bs=1 count=$WIDTH seek=$(( WIDTH * COUNT )) of=/dev/fb0
    COUNT=$(( COUNT+2 ))
  done

  for i in {1..3}; do
    COUNT=1
    while [[ $COUNT -lt $HEIGHT ]]; do
      printf $LIME | dd bs=1 count=$WIDTH seek=$(( WIDTH * COUNT )) of=/dev/fb0
      COUNT=$(( COUNT+2 ))
      [[ $COUNT -gt 2 ]] && printf $GREEN | dd bs=1 count=$WIDTH seek=$(( WIDTH * ( COUNT-2 ) )) of=/dev/fb0
    done
  done
}


terminalLinesOverlay() {
  local COUNT=1
  local COLOR=${1:-'BLACK'}

  [[ "${!COLORS_TABLE[@]}" =~ "${COLOR^^}" ]] && COLOR=${COLORS_TABLE[$COLOR]} || COLOR=$BLACK

  while [[ $COUNT -lt $HEIGHT ]]; do
    printf $COLOR | dd bs=1 count=$WIDTH seek=$(( WIDTH * COUNT )) of=/dev/fb0
    COUNT=$(( COUNT+2 ))
  done

  COUNT=1
  while [[ $COUNT -lt $HEIGHT ]]; do
    printf $LIME | dd bs=1 count=$WIDTH seek=$(( WIDTH * COUNT )) of=/dev/fb0
    COUNT=$(( COUNT+2 ))
    [[ $COUNT -gt 2 ]] && printf $COLOR | dd bs=1 count=$WIDTH seek=$(( WIDTH * ( COUNT-2 ) )) of=/dev/fb0
  done
}

# ------------------------------------------------------------------------------------------------------------


_fbdraw() {
  local WIDTH=$(cat /sys/class/graphics/fb0/stride)
  local HEIGHT=$(cat /sys/class/graphics/fb0/virtual_size | cut -d, -f2)
  local MAX=${1:-1}
  local PS1_STORED=$PS1; export PS=
  local ARG=${1:-0}
  clear

  case $ARG in
  0)
    (cat /dev/urandom | dd bs=1 count=$(cat /sys/class/graphics/fb0/stride) > /tmp/dump) >/dev/null 2>&1
    for i in $(seq 1 $HEIGHT); do cat /tmp/dump | dd bs=1 seek=$(( $WIDTH * i )) of=/dev/fb0 >/dev/null 2>&1; done #) >/dev/null 2>&1
    ;;
  1)
    local COLOR=`printf "\\\\x$(printf %02x $(( RANDOM % 255 )))\\\\x$(printf %02x $(( RANDOM % 255 )))\\\\x$(printf %02x $(( RANDOM % 255 )))\\\\\\\\x00%0.s" $(seq 1 $WIDTH)`
    for i in $(seq 1 $HEIGHT | shuf); do printf $COLOR | dd bs=1 seek=$(( WIDTH * i )) of=/dev/fb0 >/dev/null 2>&1; done
    ;;
  2)
    for l in $(seq 1 $HEIGHT); do (cat /dev/urandom | dd bs=1 count=$(cat /sys/class/graphics/fb0/stride) | dd bs=1 seek=$(( WIDTH * l )) of=/dev/fb0) >/dev/null 2>&1; done
    ;;
  3)
    (cat /dev/urandom | dd bs=1 count=$(cat /sys/class/graphics/fb0/stride) > /tmp/dump) >/dev/null 2>&1
    for i in $(seq 1 $HEIGHT | shuf); do cat /tmp/dump | dd bs=1 seek=$(( $WIDTH * i )) of=/dev/fb0 >/dev/null 2>&1; done #) >/dev/null 2>&1
    ;;
  4)
    local COLOR=`printf "\\\\\\\\x00\\\\\\\\x00\\\\\\\\x00\\\\\\\\x00%0.s" $(seq 1 $WIDTH)`
    for i in $(seq 1 $HEIGHT); do printf $COLOR | dd bs=1 seek=$(( WIDTH * i )) of=/dev/fb0 >/dev/null 2>&1; done
    #local COLOR=`printf "\\\\x$(printf %02x $(( RANDOM % 255 )))\\\\x$(printf %02x $(( RANDOM % 255 )))\\\\x$(printf %02x $(( RANDOM % 255 )))\\\\\\\\x00%0.s" $(seq 1 $WIDTH)`
    #for l in $(seq 1 $HEIGHT); do (cat /dev/urandom | dd bs=1 count=$(cat /sys/class/graphics/fb0/stride) | dd bs=1 seek=$(( WIDTH * l )) of=/dev/fb0) >/dev/null 2>&1; done
    ;;
  5)
    for l in $(seq 1 $HEIGHT | shuf); do (cat /dev/urandom | dd bs=1 count=$(cat /sys/class/graphics/fb0/stride) | dd bs=1 seek=$(( WIDTH * l )) of=/dev/fb0) >/dev/null 2>&1; done
    ;;
  6)
    (cat /dev/zero > /dev/fb0 | head -n 1) >/dev/null 2>&1
    seq 1 $(( WIDTH * HEIGHT )) | shuf > /tmp/fbmatrix
    while read p; do printf '\\\\x00\\\\x80\\\\x00\\\\x00' | dd bs=1 seek=$p of=/dev/fb0 >/dev/null 2>&1; done< <(cat /tmp/fbmatrix)
    rm /tmp/fbmatrix

    #local CANVAS=''
    #local COLOR=`printf "\\\\\\\\x00\\\\\\\\x00\\\\\\\\x00\\\\\\\\x00%0.s" $(seq 1 $WIDTH)`
    #for i in $(seq 1 $HEIGHT | shuf); do printf $COLOR | dd bs=1 seek=$(( WIDTH * i )) of=/dev/fb0 >/dev/null 2>&1; done

    #local COLOR=`printf "\\\\\\\\x00\\\\\\\\x80\\\\\\\\x00\\\\\\\\x00"`
    #(cat /dev/zero > /fb0 | head -n 1 ) > /dev/null 2>&1
    #seq 1 $(( WIDTH * HEIGHT )) | shuf > /tmp/fbmatrix & wait $! #2>/dev/null
    ;;
  7)
    local DIV=
    local H=4
    for l in $(seq 0 $HEIGHT); do
    #for l in {1..10}; do
      local COUNT=0
      while [[ $COUNT -lt $WIDTH ]]; do
        DIV=$(( (RANDOM % 20) + 8 ))
        local COLOR=`printf "\\\\x$(printf %02x $(( RANDOM % 255 )))\\\\x$(printf %02x $(( RANDOM % 255 )))\\\\x$(printf %02x $(( RANDOM % 255 )))\\\\\\\\x00%0.s" $(seq 1 $(( WIDTH / DIV )) )`

        #COLOR=`printf "\\\\x$(printf %02x $(( RANDOM % 255 )))\\\\x$(printf %02x $(( RANDOM % 255 )))\\\\x$(printf %02x $(( RANDOM % 255 )))\\\\\\\\x00%0.s" $(seq 1 $(( WIDTH / DIV )) )` >/dev/null 2>&1
        printf $COLOR | dd bs=1 count=$(( WIDTH / DIV )) seek=$(( COUNT + (WIDTH * l) )) of=/dev/fb0 >/dev/null 2>&1
        COUNT=$(( COUNT + ( WIDTH / DIV ) ))
      done
    done
    ;;
  8)
    local COUNT_H=0
    local COUNT_W=0
    local LINE=
    local DIV=
    local ADD_H=$(( ( RANDOM % 14 ) + 2 ))
    local ADD_W=20

    while [[ $COUNT_H -lt $HEIGHT ]]; do
      COUNT_W=0; LINE=''
      while [[ $COUNT_W -lt $WIDTH ]]; do
        DIV=$(( (RANDOM % $ADD_W) + 8 ))
        COLOR=`printf "\\\\x$(printf %02x $(( RANDOM % 255 )))\\\\x$(printf %02x $(( RANDOM % 255 )))\\\\x$(printf %02x $(( RANDOM % 255 )))\\\\\\\\x00%0.s" $(seq 1 $(( WIDTH / DIV )) )`
        LINE=${LINE}${COLOR}
        COUNT_W=$(( COUNT_W + ( WIDTH / DIV ) ))
      done
      for c in $(seq 1 $ADD_H); do
        printf $LINE | dd bs=1 count=$WIDTH seek=$(( WIDTH * COUNT_H )) of=/dev/fb0 >/dev/null 2>&1
        (( COUNT_H++ ))
      done
    done
    ;;
  99)
    sudo bash /home/pi/fbdraw.sh >/dev/null 2>&1
    ;;
  *)
    ;;
  esac
  sleep 2; export PS1=$PS1_STORED
}



