#!/bin/bash

SCRIPT=$(readlink -f "$0"); PID=$$
DIR=$(cd "$(dirname $SCRIPT)" && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)

assets_path="$DIR/../.assets"
media_path="$assets_path/media"
list_path="$assets_path/list"

PS1_STORED=$PS1

UNMARK="$(echo -e "\e[0m")"
  MARK="$(echo -e "\e[7m")"
    NC="$(echo -e "\033[0m")"
     C="$(echo -e "\033[32m")"

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

# VARIABLES
list=(); indexes=(); timers=();
pageIndex=0; total_files=0; offset=0; active=0; prev=0; timer=0; idle_state=0; init=1; busy=0;

pages=($(awk -F'\[|\]' '{print $2}' "$list_path" | sed 's/[ ]/\n/g;' | sed ' /^$/d' | sort -u)); pages+=("ALL")
pageTitles=(' ^^ TOP GAMES ^^' ' ** GUN GAMES **' ' || ALL GAMES ||')
page="${pages[$pageIndex]}"

width=$(echo "$(tput cols)");  [[ $(( width % 2 )) > 0 ]] && width=$(( width - 1 ))
height=$(echo "$(tput lines)")
maxPage=$(( height - 1 ))

SAVER_PID=

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

#OPTIONS
colors=1
center=1
hide_term=1
screensaver=1
play_music=0
snd_vol=10
show_splash=1

t_title=2
t_fbsaver=60
t_vidsaver=$(grep -w -m1 'saver_timeout' "$HOMEDIR/ADMIN/.sys/.settings" | cut -d= -f2)
t_sleep=$(grep -w -m1 'timeout' "$HOMEDIR/ADMIN/.sys/.settings" | cut -d= -f2)

source "$assets_path/saver/saver.sh"

#________________________________________________________________________________________________________________________________________________


fbDraw() {
  while :; do
    for (( i=0; i<$HEIGHT; i++ )); do
      printf "\x$(printf %02x $(( RANDOM % 255 )))\x$(printf %02x $(( RANDOM % 255 )))\x$(printf %02x $(( RANDOM % 255 )))\x00%0.s" $(seq 1 $WIDTH) | dd bs=1 seek=$(( i * WIDTH )) of=/dev/fb0 #>/dev/null
    done
  done
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

Main() {
  Init
  setPage

  while true; do
    input=$(readInput)
    if [[ ${#input} -gt 0 ]]; then
      fbSaver 0 &>/dev/null
      navigate "$input"
    else
      if [[ $(elapsed) -ge ${timers[$idle_state]} ]]; then
	case $idle_state in
	  0) [[ $init -eq 0 ]] && { showTitle; } ;;
	  1) [[ $screensaver -gt 0 ]] && { fbSaver 1 &>/dev/null; } ;;
	  2) [[ $screensaver -gt 0 ]] && { fbSaver 0 &>/dev/null; videoSaver; idle_state=0; elapsed 0; } ;;
	  *) ;;
	esac
        [[ ! $idle_state -ge ${#timers[@]} ]] && (( idle_state++ ));
      fi
    fi
  done
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

navigate() {
  case "${1^^}" in
    'UP')    prev=$active; [[ $(( active + offset )) -gt 0 ]] && { (( active-- )); drawScreen; init=0; } ;;
    'DOWN')  prev=$active; [[ $(( active + offset )) -lt $(( total_files - 1 )) ]] && { (( active++ )); drawScreen; init=0; } ;;
    'LEFT')  (( pageIndex-- )); init=1; changePage ;;
    'RIGHT') (( pageIndex++ )); init=1; changePage ;;
    'ENTER') launchGame ;;
    'SPACE') [[ ! $page == ALL ]] && { prev=$active; slideshow; init=1; idle_state=0; } ;;
    'S')     launchGame ;;
    'ESC')   exit 0 ;;
  esac
  idle_state=0; elapsed 0;
}

markLine() {
  tput sc; tput cup $prev 0;   printer "${list[$prev]}" 0; tput rc
  tput sc; tput cup $active 0; printer "${list[$active]}" 1; tput rc
}

drawScreen() {
  if [[ $active -lt 0 ]] && [[ $offset -gt 0 ]]; then
    offset=$(( offset - maxPage )); makeList; active=$(( maxPage -1 ))
  elif [[ $active -ge ${#list[@]} ]]; then
    offset=$(( offset + maxPage )); makeList; active=0
  fi
  markLine
}

makeList() {
  list=()

  for (( i=$offset; i<$(( offset + maxPage )); i++ )); do
    [[ $i -ge $total_files ]] && break
    title=$(sed "${indexes[$i]}q;d" "$list_path" | cut -d\' -f4 | cut -d\- -f1)
    list+=("$title")
  done
  clear

  for (( i=0; i<${#list[@]}; i++ )) ; do
    printer "${list[$i]}" 0
    [[ $init -eq 1 ]] && sleep 0.03
  done;
}

changePage() {
  [[ $pageIndex -lt 0 ]] && pageIndex=$(( ${#pages[@]} - 1 )) || { \
  [[ $pageIndex -ge ${#pages[@]} ]] && pageIndex=0; }

  page="${pages[$pageIndex]}"; sendSerial "VFD 3 ${pageTitles[$pageIndex]}"
  setPage
}

setPage() {
  [[ $page == ALL ]] && pg=' ' || pg="$page"
  indexes=($(cat "$list_path" | awk -F'\[|\]' -v p="$pg" '$2 ~ p {split($0,i," "); print i[1]}'))
  total_files=${#indexes[@]}; offset=0

  clear; active=0; makeList; markLine
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

slideshow() {
  id_list=($(cat "$list_path" | awk -F'\[|\]' -v p="$page" '$2 ~ p {split($0,i," "); print i[1]}'))
  entry=$(( ( offset + active ) + 1 )); val=0

  fim -N -T 1 -d /dev/fb0 \
   -C $entry \
   --quiet \
   --execute-script "$assets_path/config/fim_slideshow.txt" \
   --read-from-stdin< <( \
	for i in "${id_list[@]}"; do \
     	  name=$(sed "${i}q;d" "$list_path" | cut -d\' -f2); \
     	  system=$(sed "${i}q;d" "$list_path" | cut -d\' -f12 | cut -d/ -f6); \
          type=$(sed "${i}q;d" "$list_path" | cut -d\' -f14); \
          img="$media_path/slideshow/$system/$name/$name.$type"; \
          [ -e "$img" ] && echo "$img" || echo "$media_path/slideshow/blank.png"; \
   	done ) > "$assets_path/slideshow.log"

  line_count=$(cat "$assets_path/slideshow.log" | wc -l )

  for ((n=$line_count; n>0; n-- )); do
    val=$(sed "${n}q;d" "$assets_path/slideshow.log")
    [[ "$val" =~ ^[0-9]+$ ]] && { val=$(( val - 1 )); break; }
  done

  offset=$(( (val / maxPage) * maxPage )); active=$(( val - offset ))
  game=$(sed "${indexes[$val]}q;d" "$list_path" | cut -d\' -f2)

  [[ $(sed '$!d' "$assets_path/slideshow.log") =~ "$game" ]] \
  && { clear; launchGame; } \
  || { init=0; makeList; markLine; }
}

launchGame() {
  entry=$(( offset + active ))
  idx=${indexes[$entry]}
  path=$(sed "${idx}q;d" "$list_path" | cut -d\' -f12)

  if [ -f "$path" ]; then
    system=$(echo "$path" | cut -d/ -f6)
    game=$(echo "$path" | grep -o '[^/]*$' | cut -d. -f1)

    sudo sed -i "/ACTIVE_GAME/ s/ACTIVE_GAME[=].*$/ACTIVE_GAME=\x27${system}\/${game}\x27/" "$HOMEDIR/CAFCA/data/.settings"

    sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --remove joystick
    sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --mode game

    sudo -u pi bash -c "python3 /opt/retropie/configs/all/CRT/bin/GeneralModule/emulator_launcher.py ${path} ${system} dummy"

    sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --grab joystick
    sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --mode menu
    sudo setterm --cursor off

    init=1; makeList; markLine
  fi
}

fbSaver() {
  action=${1:-0}
  WIDTH=$(cat /sys/class/graphics/fb0/stride); HEIGHT=$(cat /sys/class/graphics/fb0/virtual_size | cut -d, -f2)

  if [[ $action -gt 0 ]]; then
    sudo cat /dev/fb0 > "$assets_path/fb0.dump" & wait $!
    Saver >/dev/null 2>&1 &
    SAVER_PID=$!
  else
    [[ $SAVER_PID -gt 0 ]] && { \
      sudo kill -9 $SAVER_PID 2>/dev/null; wait $SAVER_PID; \
      SAVER_PID=0; init=0; \
      sudo cat "$assets_path/fb0.dump" > /dev/fb0; \
      makeList; \
    }
  fi
}

videoSaver() {
  video_path="$media_path/screensaver/vid/arcade.mp4"

  if [ -e "$video_path" ]; then
    [[ $play_music -gt 0 ]] && playMusic

    omxplayer --aspect-mode fill --key-config "$assets_path/config/omx_config.txt" "$video_path" >/dev/null 2>&1

    [[ $play_music -gt 0 ]] && { \
      sudo setterm --blank force --term linux; \
      while read line; do break; done< <(thd --dump /dev/input/event*); \
      sudo setterm --blank poke --term linux; \
      sudo killall ffplay 2>/dev/null; \
    }
    drawScreen
 fi
}

playMusic() {
  [ $# -gt 0 ] && music_path="${@}" || music_path="$media_path/audio/music/Live_to_tell.mp3"
  [ -e "$music_path" ] && ffplay -volume $snd_vol -nodisp -autoexit -infbuf -loglevel quiet "$music_path" >/dev/null 2>&1 &
}

showTitle() {
  entry=$(( offset + active ));
  idx=${indexes[$entry]}
  title=$(awk -F'\x27' -v l="$idx" 'NR==l {split($4,t," - "); print t[1],"("$6")","["$8"]"}' "$list_path")
  sendSerial "VFD 1 $title"
}

showSplash() {
  local timeout=${1:-5}
  local img_path="$media_path/splashscreen/img/splash1.jpg"
  [ -e "$img_path" ] && { sudo fbi -a -T 1 -d /dev/fb0 -t $timeout --once --noverbose "$img_path"; sleep $timeout; }
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

readInput() {
    Event=''
    read -rs -N 1 -t 0.1 Event1 >/dev/null
    [[ $? -gt 127 ]] && return

    case "$Event1" in
      $'\163')	        Event="S"	;;
      $'\n')            Event="ENTER"   ;;
      ' ')              Event="SPACE"   ;;
      [[:blank:]])      Event="TAB"     ;;
      *)
        read -t 0.01 -rsn5 Event2
        case "$Event2" in
          "[A")         Event="UP"      ;;
          "[B")         Event="DOWN"    ;;
          "[D")         Event="LEFT"    ;;
          "[C")         Event="RIGHT"   ;;
          "OS"|"[[D")   Event="F4"      ;;
          *)
            case "$Event1$Event2" in
              $'\E')    Event="ESC"     ;;
            esac
            ;;
        esac
    esac
    echo -e "${Event}"
}

printer() {
  [[ $# -lt 1 ]] && return
  txt="${1}"; mark="${2:-0}"; pad=''; str=''

  [[ $colors -gt 0 ]] && str="${C}";
  str+="${txt}"; strlen=${#str}

  if [[ $center -gt 0 ]]; then
    [[ $(( strlen % 2 )) > 0 ]] && strlen=$(( strlen - 1 ))
    strlen=$(( strlen / 2 )); length=$(( width / 2 )); length=$(( length - strlen ))
    printf -v pad '%*s' "$length"
  fi

  [[ $mark -gt 0 ]] && str="${MARK}${str}${UNMARK}"
  str="${pad}${str}";
  [[ $colors -gt 0 ]] && str+="${NC}"
  echo -e "${str}"
}

sendSerial() {
  [ $# -ge 1 ] && echo -e "$@" > /tmp/serial.fifo || return
}

elapsed() {
  [ $# -gt 0 ] \
  && timer=$(echo $(( 10#$(date +%s) ))) \
  || echo "$(( $(echo $(( 10#$(date +%s) ))) - $timer ))"
}

bgTimer() {
  timeout=$t_sleep

  while :; do
    start=$(echo $(( 10#$(date +%s | tail -c 4) )))
    sudo timeout $timeout bash -c 'while read line; do break; done< <(thd --dump /dev/input/event*)'
    end=$(echo $(( 10#$(date +%s | tail -c 4) )))
    elapsed=$(echo $(( 10#$(( end - start )) )) )

    if [[ $elapsed -ge $timeout ]]; then
      if [[ $(pgrep -xc 'omxplayer|retroarch') -lt 1 ]]; then
      #if [[ $(pgrep -xc 'omxplayer|retroarch|ffplay') -lt 1 ]]; then
        sendSerial "ASLEEP 1"
        while read line; do break; done< <(thd --dump /dev/input/event*)
        sudo setterm --blank poke --term linux
        sendSerial "ASLEEP 0"
      fi
    fi
  done
}

Init() {
  timers=( "$t_title" "$t_fbsaver" "$t_vidsaver" )

  trap 'exitFunc' EXIT SIGINT INT

  sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --grab joystick
  sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --mode menu

  [[ $hide_term -eq 1 ]] && { PS1=; stty -F /dev/tty1 -echo; sudo setterm --cursor off; }
  [[ $show_splash -eq 1 ]] && showSplash

  ## REMOVE ˅
  #while read line; do break; done< <(thd --dump /dev/input/event*)

  elapsed 0
  bgTimer &
}

exitFunc() {
  [[ $hide_term -eq 1 ]] && { export PS1="$PS1_STORED"; stty -F /dev/tty1 sane; sudo setterm --cursor on; }
  #[[ $play_music -gt 0 ]] && playMusic "$media_path/audio/music/Blade_Runner_Blues.mp3"

  sendSerial "VFD 3  G O O D B Y E "

  sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --remove joystick
  sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --mode term

  sudo kill -9 $(pgrep ffplay) &> /dev/null
  JOBS=($(jobs -p)); [[ ${#JOBS[@]} -gt 0 ]] && sudo kill -9 "${JOBS[@]}" &> /dev/null

  clear
  exit
}


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

Main

exit


#____________________________________________________________________________
