#!/bin/bash

PID=$$
SCRIPT=$(readlink -f "$0")
DIR=$(cd "$(dirname $SCRIPT)" && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)

serial_fifo='/tmp/serial.fifo'

data_dir="$DIR/data"
states_path="$data_dir/.states"
log_path="$DIR/log/CAFCA.log"
ra_log="$DIR/log/retroarch/retroarch.log"

game_info=$(grep -i -m1 'ACTIVE_GAME' "$data_dir/.settings" | cut -d\' -f2)
cafca_action=$(grep -w -m1 'ACTION' "$data_dir/.settings" | cut -d\' -f2)

declare -Ag data=(); declare -ag regs=()

# -----------------------------------------------------------------------------------

HAS_DATA=0
GAME_READY=0
IDENTIFIED=0

ADDR=''
VAL=0
LAST_VAL=

# -----------------------------------------------------------------------------------

echo -e "CAFCA $(date '+%F %T')\n"

sudo cp -r "$data_dir/.states.default" "$data_dir/.states"
[ ! -f "$data_dir/credits.log" ] && touch "$data_dir/credits.log"; sudo chown pi:root "$data_dir/credits.log"

T=$((10#$(date +%s)))

printf "C:0\nS:0\nX:0\nT:$T\n" > "$data_dir/credits.log"
printf "$T\n" > "$data_dir/tmp/start_time"

# -----------------------------------------------------------------------------------

Main() {
  STATE GAME_LOADED 1
  getData
  waitForGame
  STATE GAME_READY 1

  while [[ $(grep -wE -m1 '^X' "$data_dir/credits.log" | cut -d: -f2) -lt 1 ]]; do :; done; echo -e "CREDITS 1" > "$serial_fifo"

  if [[ $HAS_DATA -gt 0 ]]; then
    [[ "${data[REGNAM]}" == misc ]] && { checkMiscReg; } || { ADDR=$(dump_addr); IDENTIFIED=1; }
  fi

  while [[ $(pgrep retroarch | wc -c) -gt 0 ]]; do
    [[ $IDENTIFIED -gt 0 ]] \
    && VAL=$(sudo scanmem -p `pidof retroarch` -c"dump $ADDR 1;exit" 2>&1 | awk 'NR==15' | awk -F' ' '{print $2}') \
    || VAL=$(grep -wE -m1 '^X' "$data_dir/credits.log" | cut -d: -f2)

    if [[ $VAL != $LAST_VAL ]]; then
      if [[ $(printf "$VAL" | grep -c "[[:xdigit:]]") -gt 0 ]]; then
        CREDITS=$((16#$VAL))
        [[ "$CREDITS" =~ ^[0-9]+$ ]] && echo -e "CREDITS $CREDITS" > "$serial_fifo" ; echo "$ADDR : $VAL ( $CREDITS )";
      fi
      LAST_VAL=$VAL
    fi
    sleep 1
  done
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

getData() {
  data[GAME]="${game_info#*'/'}"; data[SYSTEM]="${game_info%'/'*}"
  addr_data=$(grep -w -m1 "^${data[GAME]}" "$data_dir/${data[SYSTEM]}/table" | awk -F'\[|\]' '{ gsub (" ", ",", $2); print}' | sed -e "s/  \+/ /g" | cut -d' ' -f2- | sed 's/[,].$//')

  if [[ $( echo "${addr_data}" | wc -c ) -gt 1 ]]; then
    for i in OFFSET REGNUM REGNAM VARPOS DATYPE; do (( count++ ));
      val=$(echo "$addr_data" | awk -v pos="$count" '{print $pos}'); data["$i"]="$val";
    done
    HAS_DATA=1
    for n in GAME SYSTEM OFFSET REGNUM REGNAM VARPOS DATYPE; do printf "%s\t%s\n" "$n" "${data[$n]}"; done; echo ""
  else
    echo -e "GAME:   ${data[GAME]}\nSYSTEM: ${data[SYSTEM]}\n - NO DATA FOUND!"
  fi
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

dump_addr() {
  scan_args="option region_scan_level 3; reset; dregions !${data[REGNUM]}; lregions; exit"
  REG_OFFS=$(sudo scanmem -p `pidof retroarch` -c"$scan_args" 2>&1 |& grep --line-buffered -A1 "lregions" | awk 'NR==2' | awk '$1=$1 {print}' | cut -d] -f2 | awk -F" " '{print $1}' | cut -d, -f1);REG_OFFS="0x${REG_OFFS}"
  printf -v ADDR "0x%X\n" $(( REG_OFFS + ${data[OFFSET]} )) &>/dev/null; echo "${ADDR,,}"
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

checkMiscReg() {
  regs+=("${data[REGNUM]}")
  for i in {1..10}; do regs+=("$(( ${data[REGNUM]} - i ))"); regs+=("$(( ${data[REGNUM]} + i ))"); done; #echo -e "regs: ${regs[@]})"

  for reg in "${regs[@]}"; do
    data[REGNUM]="$reg"; ADDR=$(dump_addr)
    VAL=$(sudo scanmem -p `pidof retroarch` -c"dump $ADDR 1;exit" 2>&1 | awk 'NR==15' | awk -F' ' '{print $2}')
    COINS=$(grep -E -m1 '^X' "$data_dir/credits.log" | cut -d: -f2)
    IDENTIFIED=$(( (16#$VAL) == COINS ))

    echo -e "REGNUM: ${data[REGNUM]}, ADDR: $ADDR, VAL: $VAL ( $((16#$VAL)) )"
    [[ $IDENTIFIED -gt 0 ]] && break
  done

  while [[ $(grep -E -m1 '^S' "$data_dir/credits.log" | cut -d: -f2) -lt 1 ]]; do :; done

  VAL=$(sudo scanmem -p `pidof retroarch` -c"dump $ADDR 1;exit" 2>&1 | awk 'NR==15' | awk -F' ' '{print $2}')
  COINS=$(grep -E -m1 '^X' "$data_dir/credits.log" | cut -d: -f2)
  IDENTIFIED=$(( (16#$VAL) == COINS ))

  echo -e "REGNUM: ${data[REGNUM]}, ADDR: $ADDR, VAL: $VAL ( $((16#$VAL)) ) $([[ $IDENTIFIED -gt 0 ]] && printf '- IDENTIFIED!')"
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

waitForGame() {
  local words=('hiscore.dat' 'SET_GEOMETRY')
  local T_LOAD=$(grep -w -m1 "^${data[GAME]}" "$data_dir/${data[SYSTEM]}/timers" | grep -o '[^ ]*$')

  while [[ $GAME_READY -lt 1 ]]; do GAME_READY=$(cat "$ra_log" | grep -Ec "$(for w in $(echo ${words[@]} | tr ' ' ' | '); do echo *$w*; done)"); done
  while [[ $((10#$(date +%s)-T)) -lt $T_LOAD ]]; do :; done

  echo -e "\nGAME_READY!\n"
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

STATE() {
  [ $# -lt 2 ] && return
  local KEY="${1^^}"; local VAL="${2}"; local SER=${3:-1}
  [[ $(printf "${VAL}" | grep -Ec "[[:alpha:]]") -gt 0 ]] && VAL="'${VAL}'"

  if [[ $(grep -ic "$KEY" "$data_dir/.states") -gt 0 ]]; then
    sudo sed -i "s/^$KEY.*/$KEY=$VAL/g" "$data_dir/.states"
    [[ $SER -gt 0 ]] && echo -e "$KEY $VAL" > "$serial_fifo"
  fi
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

exitFunc() {
  echo -e "GAME_STOPPED 1" >> "$serial_fifo"
  STATE 'GAME_READY' '0'; STATE 'GAME_LOADED' '0'
  JOBS=($(jobs -p)); [[ ${#JOBS[@]} -gt 0 ]] && sudo kill -9 "${JOBS[@]}" &> /dev/null
  exit
}

trap 'exitFunc' EXIT SIGINT INT

Main

exit 0








# ___________________________________________________________________________________
#
# ˅ IGNORE ˅

home_dir='/home/pi'
cafca_log='/home/pi/CAFCA/log/CAFCA.log'
cafca_states='/home/pi/CAFCA/data/.states'
ra_log='/home/pi/CAFCA/log/retroarch/retroarch.log'

timerStart=$(date +%s%3N)

game_info=$(grep -i ACTIVE_GAME "$cafca_states" | cut -d\' -f 2)
sudo cp -r "$HOMEDIR/CAFCA/data/.states.default" "$HOMEDIR/CAFCA/data/.states" 2>/dev/null


declare -A DATA=()

# ____________________________________________________________________________


#declare -A DATA=() && while read line; do k=$(echo $line | cut -d' ' -f1); v=$(echo $line | cut -d\" -f2); DATA["$k"]="$v"; done< <(cat "/home/pi/CAFCA/data/$game_info" | sed '/^$/d')

Main() {
  serialSend "GAME_LOADED 1" && sudo sed -i '/GAME_LOADED/ s/GAME_LOADED[=].*$/GAME_LOADED=1/' "$home_dir/CAFCA/data/.states"
  echo "CAFCA RUNNING"
  echo -e "DATA: $game_info"

  while read line; do
    k=$(echo $line | cut -d' ' -f1)
    v=$(echo $line | cut -d\" -f2)
    DATA["$k"]="$v"
  done< <(cat "/home/pi/CAFCA/data/$game_info" | sed '/^$/d')

  echo "DATA:"
  for i in "${!DATA[@]}"; do printf "  %s\t%s\n" "$i" "${DATA[$i]}"; done

  echo -e "GAME_TITLE ${DATA[GAME_TITLE]}"
  sleep 3 && serialSend "GAME_TITLE ${DATA[GAME_TITLE]}"

  # ---------------------------------------------

  while [[  $(grep -Ec '*SET_GEOMETRY*|*hiscore memory file*' "$ra_log") -lt 1 ]]; do sleep 0.1; done

  if [[ ${DATA[GAME_LOADTIME]} -gt 0 ]]; then
    while [[ $(( $(date +%s%3N) - timerStart )) -lt ${DATA[GAME_LOADTIME]} ]]; do
      sleep 0.1
    done
  fi

  # -------------------------------------------
  echo "READY!"
  serialSend "GAME_READY 1"
  sudo sed -i '/GAME_READY/ s/GAME_READY[=].*$/GAME_READY=1/' "$cafca_states"

  sleep 1

  if [[ ${#DATA[CAFCA_COIN]} -gt 0 ]]; then
    ADDR=$(cafca_dump)
    LAST_VAL=
    while [[ $(pgrep retroarch) -gt 0 ]]; do
      VAL=$(sudo scanmem -p `pidof retroarch` -c"dump $ADDR 1;exit" 2>&1 | awk 'NR==15' | awk -F' ' '{print $2}')
      if [[ $VAL != $LAST_VAL ]]; then
        CREDITS=$((10#$VAL))
        echo "ADDR: $ADDR - VAL: $VAL"
        serialSend "CREDITS $CREDITS"
        LAST_VAL=$VAL
        sleep 2
      fi
      sleep 1
    done
  else
    echo -e "NO DATA!"
  fi

}

cafca_dump() {
  data="${DATA[CAFCA_COIN]}"
  data_offs=$(echo "$data" | awk '{print $1}')
  data_reg=$(echo "$data" | awk '{print $2}')
  data_nom=$(echo "$data" | awk '{print $3}')

  scan_args="option region_scan_level 3; reset; dregions !$data_reg; lregions; exit"
  reg_offs=$(sudo scanmem -p `pidof retroarch` -c"$scan_args" 2>&1 |& grep --line-buffered -A1 "lregions" | awk 'NR==2' | awk '$1=$1 {print}' | cut -d] -f2 | awk -F" " '{print $1}' | cut -d, -f1)
  reg_offs="0x${reg_offs}"
  #echo "data_offs: $data_offs"; echo "reg_offs:  $reg_offs"

  printf -v ADDR "0x%X\n" $(( reg_offs + data_offs )) &>/dev/null
  ADDR=$(echo "$ADDR" | tr '[A-Z]' '[a-z]'); echo "$ADDR"
}


Main2() {

  #printf ''  | sudo tee $ra_log &>/dev/null
  printf '0' | sudo tee $coin_file &>/dev/null
  printf '0' | sudo tee $start_file &>/dev/null

  wait_for_game

  read_inputs &

  [[ $game_listed -gt 0 ]] && get_data || echo "game not listed."
  sleep 1

  dump_addr "0x$reg_offs" "$data_offs" &>/dev/null
  echo "ADDR: $ADDR"

  echo "state: 0"

  while [[ $state == 0 ]]; do
    if [[ $(cat "$coin_file") -gt 0 ]]; then
      state=1; echo "state: 1"
    else
      check_credits
    fi
    sleep 1
  done

  serialSend "CREDITS 1"
  reg_count=0

  while [[ $state == 1 ]]; do
    if [[ $(cat "$coin_file") -gt 0 ]] && [[ $(cat "$start_file") -gt 0 ]]; then
      state=2; echo "state: 2"
    else
      check_credits
    fi
    sleep 1
  done

  serialSend "CREDITS 0"
  reg_count=0

  while [[ $state == 2 ]]; do
    check_credits
    sleep 1
  done
}

# -------------------------------------------------------------------



loadTimer() {
  if [[ ${#} -gt 0 ]]; then
    if [[ ${@} == 1 ]]; then

      if [[ $(grep -w -c "$game" "$data_dir/$system/_times") -gt 0 ]]; then
        timerLimit=$(grep -m1 -w "$game" "$data_dir/$system/_times" | cut -d' ' -f2)
        debug "TIMER:\t\t$timerLimit"
      fi
    else
      if [[ $(grep -w -c "$game" "$data_dir/$system/_times") -lt 1 ]]; then
        timerLoaded=$(( $(date +%s%3N) - timerOffset ))
        echo "$game $timerLoaded" | sudo tee -a "$data_dir/$system/_times" &>/dev/null
        debug "LOAD TIME: $timerLoaded"
      fi
    fi
  else
    timerLoaded=$(( $(date +%s%3N) - timerOffset ))
  fi

  #if [[ $timerLimit -gt 0 ]]; then
  #  while [[ $(( $(date +%s%3N) - timerOffset )) -lt $timerLimit ]]; do
  #    loadTimer
  #  done
  #fi

}


get_data() {
    #[[ $misc_reg -gt 0 ]] && data_reg="$misc_reg"

    scan_args="option region_scan_level 3; reset; dregions !$data_reg; lregions; exit"
    reg_offs=$(sudo scanmem -p `pidof retroarch` -c"$scan_args" 2>&1 |& grep --line-buffered -A1 "lregions" | awk 'NR==2' | awk '$1=$1 {print}' | cut -d] -f2 | awk -F" " '{print $1}' | cut -d, -f1)

    echo "DATA:       $data"
    echo "data_reg:   $data_reg"
    echo "reg_name:   $reg_name"
    echo "data_offs:  $data_offs"
    echo "reg_offs:   0x$reg_offs"
    echo ""
}

dump_addr() {
  BASE="${1}"
  OFFS="${2}"
  printf -v ADDR "0x%X\n" $(( BASE + OFFS)) &>/dev/null
  ADDR=$(echo "$ADDR" | tr '[A-Z]' '[a-z]')
  VAL=$(sudo scanmem -p `pidof retroarch` -c"dump $ADDR 1;exit" 2>&1 | awk 'NR==15' | awk -F' ' '{print $2}')
  credits=$((10#$VAL))
  echo $credits #$((10#$VAL))

  #echo "dumpAddr(): $ADDR - VAL: $VAL"
  #echo -n "$VAL"; #[[ $(( calc_coins - VAL )) -eq 0 ]] && echo " (MATCH)" || echo " (INVALID)"
  #echo "$(( 10#$(calc_coins) )) $(( VAL ))"
  #[[ $(( 10#$(calc_coins) )) == $(( VAL )) ]] && CREDITS=$VAL
}

calc_coins() {
 c=$(cat "$coin_file"); s=$(cat "$start_file")
 coins=$(( c - s ))
 echo "$coins"
}

check_credits() {
  dump=$(dump_addr "0x$reg_offs" "$data_offs")
  coins=$(calc_coins)
  echo -e "dump: $dump\ncoins: $coins"

  if [[ $reg_name == misc ]] && [[ $state -lt 2 ]]; then
    if [[ $dump != $coins ]]; then
      if [[ $reg_count < ${#regs[@]} ]]; then
        data_reg="${regs[$reg_count]}"
        reg_count=$(( reg_count + 1 ))
        echo "REG: $data_reg"
        get_data
      fi
    fi
  else
    if [[ $state == 2 ]]; then
      credits_verified[0]="$dump"
      if [[ ${credits_verified[0]} != ${credits_verified[1]} ]]; then
        credits_verified[1]=${credits_verified[0]}
        serialsend "CREDITS ${credits_verified[0]}"
      fi
    fi
  fi
}


#loaded_str=('SET_GEOMETRY' 'hiscore memory file'); grep -c -m1 -f <(printf "%s\n" "${loaded_str[@]}") '/home/pi/CAFCA/log/retroarch/retroarch.log'

wait_for_game() {
  limit=20
  repeats=0
  last_len=0
  loaded_str=('SET_GEOMETRY' 'hiscore memory file')

  while (( ! $game_ready )); do
    log_len=$(wc -l $ra_log | cut -d' ' -f1)

    if [[ $repeats -lt $limit ]]; then
      game_ready=$(grep -c -m1 -f <(printf "%s\n" "${loaded_str[@]}") $ra_log)
      #game_ready=$(grep -Ec -m1 "${loaded_str[@]}" $ra_log)
      [[ $log_len == $last_len ]] && repeats=$(( repeats + 1 ))
      last_len=$log_len
      game_ready=1 && break
    fi
    (( ! $title_found )) && get_title
    sleep 0.5
  done

  serialSend "GAME_READY 1"
  #debug " "; debug "GAME_READY:\t1"
  #debug "last log: \x22$(awk 'END{print}' $ra_log)\x22"
}

serialSend() {
 echo -e "$@" > /tmp/serial.fifo
}


read_inputs() {
  local coins_cnt=0
  local start_cnt=0
  local limit_start=20
  local t_start=$limit_start
  local last_start=$(date +%s)

  while read -r line; do
    pressed=$(echo "$line" | grep -E "$coin_key|$start_key" | \
      awk -v C="$coin_key" -v S="$start_key" '{
        if ($2 == C) print "COIN"
        if ($2 == S) print "START"
      }')

    debug "pressed: $pressed"

    coins_cnt=$(cat "$coin_file")
    start_cnt=$(cat "$start_file")

    if [[ $pressed == COIN ]]; then
      echo "$(( coins_cnt + 1 ))" | sudo tee $coin_file &>/dev/null
    elif [[ $pressed == START ]]; then
      if [[ $coins_cnt -gt 0 ]]; then
        if [[ $start_cnt -gt 0 ]]; then
          t_start=$(( `date +%s` - $last_start ))
          if [[ $t_start -ge $limit_start ]]; then
            echo "$(( start_cnt + 1 ))" | sudo tee $coin_file &>/dev/null
            last_start=$(date +%s); t_start=0
          fi
        else
          echo "$(( start_cnt + 1 ))" | sudo tee $start_file &>/dev/null
          last_start=$(date +%s); t_start=0
        fi
      else
        loadTimer "0"
      fi
    fi

    #if [[ "$action" == SCAN ]]; then
    #  scanning=$(grep -w -m1 SCANNING "$data_dir/scan_states" | cut -d= -f2)
    #  while (( $scanning )); do
    #    scanning=$(grep -w -m1 SCANNING "$data_dir/scan_states" | cut -d= -f2)
    #  done
    #fi
  done< <(thd --dump "$teensy_kbd" 2>&1 |& grep --line-buffered -E "$coin_key|$start_key" | awk -W interactive '{$1=$1;print}' | grep --line-buffered -Ew "EV_KEY $coin_key 1|EV_KEY $start_key 1" 2>&1)
}


# -------------------------------------------------------------------

teensy_kbd='/dev/input/by-id/usb-Teensyduino_Serial_Keyboard_Mouse_Joystick_1008140-if02-event-kbd'

game_table='/home/pi/CAFCA/data/mame-libretro/game_table'
rc_log='/dev/shm/runcommand.log'

coin_file='/home/pi/CAFCA/data/tmp/cafca_coins_cnt'
start_file='/home/pi/CAFCA/data/tmp/cafca_start_cnt'

game=$(grep "lookup name" "$ra_log" | awk -F' ' '{print $8}' | cut -d. -f1)
game_listed=$(grep -wc "$game" "$game_table")
game_ready=0
matched=0
credits=0
credits_verified=(0 1)
dump=0
reg_name=''
misc_reg=0
coins=0
match=0
state=0

coin_key='KEY_C'
start_key='KEY_S'

data=$(grep -w "$game" "$game_table" | awk '$1=$1 {print}')
data_reg=$(echo "$data" | awk '{print $3}')
reg_name=$(echo "$data" | awk '{print $4}')
data_offs=$(echo "$data" | awk '{print $2}')

reg_offs=
reg_count=0

ADDR=

if [[ $reg_name == misc ]]; then
  declare -a regs=( "$(( data_reg - 1 ))" "$(( data_reg + 1 ))" "$(( data_reg - 2 ))" "$(( data_reg + 2 ))" "$(( data_reg - 3 ))" "$(( data_reg + 3 ))")
fi

#echo "GAME:       $game"
#echo "LISTED:     $game_listed"

Main



