#!/bin/bash

  /usr/bin/expect -c '
    log_user 1
    exp_internal 0

    set timeout -1
    set pid [exec pgrep -f 'boot' | head -n 1]
    spawn scanmem -p $pid

    #proc wait { time } {
    #  #send_user "waiting $time seconds..\n"
    #  set t_bak $::timeout
    #  set ::timeout $time
    #  expect -exact "<%SLEEPTIMER%>" { timeout abort }
    #  set ::timeout $t_bak
    #}

    set count 0
    #incr count
    #set count [expr {$count + 1}]
    send_user "\033c"
    #send_user "$count"
    sleep 2
    send_user "BEGIN"

    set timeout 2
    expect {
      "Please" {
        send_user "PLEASE\n"
        #send "exit\r"

        set timeout 2

        expect "*matches.*" {
          if {$count > 3} {
            send "exit\r"
          } else {
            incr count
            exp_continue
          }
        }
      }
    }

    expect eof
  '
  exit 0

# ------------------------------------------------------

  /usr/bin/expect -c '
    log_user 1
    exp_internal 0

    set timeout -1
    set pid [exec pgrep -f 'boot' | head -n 1]

    spawn scanmem -p $pid

    proc wait {} {
      exec sleep 1
    }

    expect {
      "Please" {
        exec sleep 1
        send_user "DONE"
        send "exit\r"
        #exp_continue
      }
    }
    expect eof
  '
exit 0

###################################################################################################

scan_coin() {
  /usr/bin/expect -c '
    log_user 1
    exp_internal 0

    set timeout -1
    set teensy_id '/dev/input/by-id/usb-Teensyduino_Serial_Keyboard_Mouse_Joystick_1008140-if02-event-kbd'
    set coin_key "KEY_C"

    set coin_file '/home/pi/CAFCA/data/credits.log'

    set exp_log '/home/pi/CAFCA/log/expect.log'
    log_file "$exp_log"

    # ------------------------------------------------------------

    set pid [exec pidof retroarch]
    set ready 0
    set credits 1
    set last_credits 0
    set matches 999
    set match_limit 3

    # ------------------------------------------------------------

    spawn scanmem -p $pid

    proc startscan {} {
      expect {
        "Please" {
          #exec sleep 1
          send "option region_scan_level 3\rreset\r"
          #exec sleep 1
          exp_continue
        }
        "*suitable*" {
          set ::ready 1
          #exec sleep 1
        }
      }

      while {$::matches > $::match_limit} { get_coin }
      #exec sleep 1
      send "list\r"

      expect "* 0*" {
        send "exit\r"
      }
    }

    proc get_coin {} {
      set ::credits [exec grep -m1 '^C' "$::coin_file" | cut -d: -f2 ]

      exec sleep 1

      if {$::credits != $::last_credits} {
        set ::last_credits $::credits
        #exec sleep 1
        send "$::credits\r"
        #exec sleep 1

        expect {
          "*currently*" {
            set ::matches [lindex [split [lindex [split $expect_out(buffer) "\n"] end-1 ] " " ] end-1 ]
            #exec sleep 1

            if {$::matches == 0} {
              set ::matches 999
              send "option region_scan_level 3\rreset\r"
            } elseif {$::matches == "other"} {
              set ::matches 1
            } else {
              insert_coin
            }
          }
        }
      }
    }

    proc insert_coin {} {
      exec evemu-event $::teensy_id --type EV_KEY --code $::coin_key --value 1 --sync
      exec evemu-event $::teensy_id --type EV_KEY --code $::coin_key --value 0 --sync
    }

    startscan
    interact # < REM
    expect eof
  '
  echo ""
}
