#!/bin/bash

SCRIPT=$(readlink -f "$0"); PID=$$
DIR=$(cd "$(dirname $SCRIPT)" && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)

serial_path='/tmp/serial.fifo'
roms_path=$(grep -w -m1 'dir_roms' "$HOMEDIR/ADMIN/.sys/.settings" | cut -d\' -f2)
teensy_id=$(grep -w -m1 'DEV teensy' "$HOMEDIR/ADMIN/.sys/.settings" | cut -d\' -f2)
exception_list=$(grep -w -m1 '^EXCEPTION_LIST' "$HOMEDIR/CAFCA/data/.settings" | cut -d\' -f2)

assets_path="$DIR/../.assets"
media_path="$assets_path/media"
list_path="$assets_path/list"


HEIGHT=$(cat /sys/class/graphics/fb0/virtual_size | cut -d, -f2)
WIDTH=$(cat /sys/class/graphics/fb0/stride)

PS1_STORED=$PS1

UNMARK="$(echo -e "\e[0m")"
  MARK="$(echo -e "\e[7m")"
    NC="$(echo -e "\033[0m")"
     C="$(echo -e "\033[32m")"

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

# VARIABLES
list=(); indexes=(); timers=();
pageIndex=0; total_files=0; offset=0; active=0; prev=0; timer=0; idle_state=0; init=1; busy=0;

pages=($(awk -F'\[|\]' '{print $2}' "$list_path" | sed 's/[ ]/\n/g;' | sed ' /^$/d' | sort -u)); pages+=("ALL")
pageTitles=(' ^^ TOP GAMES ^^' ' ** GUN GAMES **' ' || ALL GAMES ||')
page="${pages[$pageIndex]}"

width=$(echo "$(tput cols)");  [[ $(( width % 2 )) > 0 ]] && width=$(( width - 1 ))
height=$(echo "$(tput lines)")
maxPage=$(( height - 1 ))

SAVER_PID=
FFPLAY_PID=

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

#OPTIONS
colors=1
center=1
hide_term=1
screensaver=1
show_splash=1
show_marquee=1
post_clear=1
snd_vol=10
t_title=2
t_marquee=5
t_fbsaver=60
t_vidsaver=$(grep -w -m1 'saver_timeout' "$HOMEDIR/ADMIN/.sys/.settings" | cut -d= -f2)
t_sleep=$(grep -w -m1 'timeout' "$HOMEDIR/ADMIN/.sys/.settings" | cut -d= -f2)
play_music=$(grep -w -m1 'screensaver_music' "$HOMEDIR/ADMIN/.sys/.settings" | cut -d= -f2)

#________________________________________________________________________________________________________________________________________________

source "$assets_path/saver/saver.sh"


Main() {
  Init
  setPage

  while true; do
    input=$(readInput)

    if [[ ${#input} -gt 0 ]]; then
      [[ $play_music -gt 0 ]] && [[ $(pgrep -c ffplay) -gt 0 ]] && sudo killall ffplay 2>/dev/null
      fbSaver 0 &>/dev/null
      sudo setterm --blank poke --term linux
      navigate "$input"
    else
      if [[ $(elapsed) -ge ${timers[$idle_state]} ]]; then
	case $idle_state in
	  0) [[ $init -eq 0 ]] && { showTitle; } ;;
	  1) [[ $show_marquee -gt 0 ]] && { showMarquee; } ;;
	  2) [[ $screensaver -gt 0 ]] && { fbSaver 1 &>/dev/null; } ;;
	  3) [[ $screensaver -gt 0 ]] && { fbSaver 0 &>/dev/null; videoSaver; } ;;
          4) [[ $screensaver -gt 0 ]] && { asleep; drawScreen; idle_state=0; elapsed 0; } ;;
	  *) ;;
	esac
        [[ $idle_state -lt ${#timers[@]} ]] && (( idle_state++ ));
      fi
    fi
  done
}


showMarquee() {
  entry=$(( offset + active )); idx=${indexes[$entry]}; name=$(awk -F'\x27' -v l="$idx" 'NR==l {print $2}' "$list_path")
  file=$(find "$media_path/marquees" -type f -iname "$name*.ppm" -print -quit)

  if [ -f "$file" ]; then
    H="${file##*/}"; H="${H/.*/}"; H="${H##*_}"
    PAD=$(( (HEIGHT - H) / 2 ))
    sudo cat /dev/fb0 > "$assets_path/fb0.dump" & wait $!
    ( dd if="$file" bs=1 skip=$(( WIDTH * PAD )) count=$(( WIDTH * H )) iflag=skip_bytes,count_bytes | dd seek=$(( WIDTH * PAD )) oflag=seek_bytes of=/dev/fb0 ) >/dev/null 2>&1
  fi
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

navigate() {
  case "${1^^}" in
    'UP')    prev=$active; [[ $(( active + offset )) -gt 0 ]] && { (( active-- )); drawScreen; init=0; } ;;
    'DOWN')  prev=$active; [[ $(( active + offset )) -lt $(( total_files - 1 )) ]] && { (( active++ )); drawScreen; init=0; } ;;
    'LEFT')  (( pageIndex-- )); init=1; changePage ;;
    'RIGHT') (( pageIndex++ )); init=1; changePage ;;
    'ENTER') launchGame ;;
    'SPACE') [[ ! $page == ALL ]] && { prev=$active; slideshow; init=1; idle_state=0; } ;;
    'S')     launchGame ;;
    'ESC')   exit 0 ;;
  esac
  idle_state=0; elapsed 0;
}

markLine() {
  tput sc; tput cup $prev 0;   printer "${list[$prev]}" 0; tput rc
  tput sc; tput cup $active 0; printer "${list[$active]}" 1; tput rc
}

drawScreen() {
  if [[ $active -lt 0 ]] && [[ $offset -gt 0 ]]; then
    offset=$(( offset - maxPage )); makeList; active=$(( maxPage -1 ))
  elif [[ $active -ge ${#list[@]} ]]; then
    offset=$(( offset + maxPage )); makeList; active=0
  fi
  markLine
}

makeList() {
  list=()

  for (( i=$offset; i<$(( offset + maxPage )); i++ )); do
    [[ $i -ge $total_files ]] && break
    title=$(sed "${indexes[$i]}q;d" "$list_path" | cut -d\' -f4 | awk -F'  |\(' '{if (NF < 3){ print $1 } else { print $1,"("$3}}')
    list+=("$title")
  done
  clear

  for (( i=0; i<${#list[@]}; i++ )) ; do
    printer "${list[$i]}" 0
    [[ $init -eq 1 ]] && sleep 0.03
  done;
}

changePage() {
  [[ $pageIndex -lt 0 ]] && pageIndex=$(( ${#pages[@]} - 1 )) || { \
  [[ $pageIndex -ge ${#pages[@]} ]] && pageIndex=0; }

  page="${pages[$pageIndex]}"; sendSerial "VFD 3 ${pageTitles[$pageIndex]}"
  setPage
}

setPage() {
  [[ $page == ALL ]] && pg=' ' || pg="$page"
  indexes=($(cat "$list_path" | awk -F'\[|\]' -v p="$pg" '$2 ~ p {split($0,i," "); print i[1]}'))
  total_files=${#indexes[@]}; offset=0

  clear; active=0; makeList; markLine
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

slideshow() {
  id_list=($(cat "$list_path" | awk -F'\[|\]' -v p="$page" '$2 ~ p {split($0,i," "); print i[1]}'))
  entry=$(( ( offset + active ) + 1 )); val=0

  fim -N -T 1 -d /dev/fb0 \
   -C $entry \
   --quiet \
   --execute-script "$assets_path/config/fim_slideshow.txt" \
   --read-from-stdin< <( \
	for i in "${id_list[@]}"; do \
     	  name=$(sed "${i}q;d" "$list_path" | cut -d\' -f2); \
     	  system=$(sed "${i}q;d" "$list_path" | cut -d\' -f12 | cut -d/ -f6); \
          type=$(sed "${i}q;d" "$list_path" | cut -d\' -f14); \
          img="$media_path/slideshow/$system/$name/$name.$type"; \
          [ -e "$img" ] && echo "$img" || echo "$media_path/slideshow/blank.png"; \
   	done ) > "$assets_path/slideshow.log"

  line_count=$(cat "$assets_path/slideshow.log" | wc -l )

  for ((n=$line_count; n>0; n-- )); do
    val=$(sed "${n}q;d" "$assets_path/slideshow.log")
    [[ "$val" =~ ^[0-9]+$ ]] && { val=$(( val - 1 )); break; }
  done

  offset=$(( (val / maxPage) * maxPage )); active=$(( val - offset ))
  game=$(sed "${indexes[$val]}q;d" "$list_path" | cut -d\' -f2)

  [[ $(sed '$!d' "$assets_path/slideshow.log") =~ "$game" ]] \
  && { clear; launchGame; } \
  || { init=0; makeList; markLine; }
}

checkExceptions() {
  [ $# -lt 1 ] && return
  local mode="${1^^}"
  local game="${2}"

  case $game in
    'blktiger')
      ;;
    'loht')
      #[[ $mode == LOAD ]] && { sleep 5; for state in {1..0}; do evemu-event "$teensy_id" --type EV_KEY --code KEY_ESC --value $state --sync; sleep 0.2; done; }
      ;;
    'toki')
      if [[ $mode == LOAD ]]; then
        while [[ $(grep -w -m1 '^GAME_READY' "$HOMEDIR/CAFCA/data/.states" | cut -d= -f2) -lt 1 ]]; do :; done; sleep 1
        for state in {1..0}; do evemu-event "$teensy_id" --type EV_KEY --code KEY_S --value $state --sync; sleep 0.2; done
      fi
      ;;
    *)
      ;;
  esac
}

launchGame() {
  entry=$(( offset + active ))
  idx=${indexes[$entry]}
  path=$(sed "${idx}q;d" "$list_path" | cut -d\' -f12)

  if [ -f "$path" ]; then
    system=$(echo "$path" | cut -d/ -f6)
    game=$(echo "$path" | grep -o '[^/]*$' | cut -d. -f1)

    [[ "${game}" == @(${exception_list}) ]] && ( checkExceptions LOAD "${game}" & )

    sudo sed -i "s|ACTIVE_GAME[=].*$|ACTIVE_GAME=\x27${system}\/${game}\x27|g" "$HOMEDIR/CAFCA/data/.settings"
    sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --mode game; sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --remove joystick
    sudo -u pi bash -c "python3 /opt/retropie/configs/all/CRT/bin/GeneralModule/emulator_launcher.py ${path} ${system} dummy"
    sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --mode menu; sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --grab joystick
    sudo setterm --cursor off

    init=1; makeList; markLine
  fi
}

asleep() {
  echo -e "ASLEEP 1" > /tmp/serial.fifo
  while read line; do break; done< <(thd --dump /dev/input/event* | grep EV_KEY)
  echo -e "ASLEEP 0" > /tmp/serial.fifo
  sudo setterm --blank poke --term linux
}

fbSaver() {
  local action=${1:-0}
  local redraw=0

  if [[ $action -gt 0 ]]; then
    [ ! -f "$assets_path/fb0.dump" ] && { sudo cat /dev/fb0 > "$assets_path/fb0.dump" & wait $!; } || { sudo cat "$assets_path/fb0.dump" > /dev/fb0 & wait $!; }
    Saver >/dev/null 2>&1 & SAVER_PID=$!
  else
    [[ $SAVER_PID -gt 0 ]] && { sudo kill -9 $SAVER_PID 2>/dev/null; wait $SAVER_PID; SAVER_PID=0; redraw=1; } || { \
    [[ $show_marquee -gt 0 ]] && [ -f "$assets_path/fb0.dump" ] && redraw=1; }
    [[ $redraw -gt 0 ]] && { sudo cat "$assets_path/fb0.dump" > /dev/fb0; sudo rm "$assets_path/fb0.dump"; init=0; makeList; }
  fi
}

videoSaver() {
  video_path="$media_path/screensaver/vid/arcade.mp4"

  if [ -e "$video_path" ]; then
    [[ $play_music -gt 0 ]] && playMusic

    omxplayer --aspect-mode fill --key-config "$assets_path/config/omx_config.txt" "$video_path" >/dev/null 2>&1
    sudo setterm --blank force --term linux

    #[[ $play_music -gt 0 ]] && while [[ $(ps --no-headers -p $FFPLAY_PID | wc -c) -gt 0 ]];do :; done
    #[[ $play_music -gt 0 ]] && sudo killall ffplay 2>/dev/null

    #sudo setterm --blank force --term linux
    #while read line; do break; done< <(thd --dump /dev/input/event*)
    #sudo setterm --blank poke --term linux
 fi
}

playMusic() {
  [ $# -gt 0 ] && music_path="${@}" || music_path="$media_path/audio/music/Live_to_tell.mp3"
  [ -e "$music_path" ] && [[ $(pgrep -c 'ffplay') -lt 1 ]] && ffplay -volume $snd_vol -nodisp -autoexit -infbuf -loglevel quiet "$music_path" >/dev/null 2>&1 &
}

showTitle() {
  entry=$(( offset + active ));
  idx=${indexes[$entry]}
  title=$(awk -F'\x27' -v l="$idx" 'NR==l {split($4,t," - "); print t[1],"("$6")","["$8"]"}' "$list_path")
  sendSerial "VFD 1 $title"
}

showSplash() {
  local timeout=${1:-5}
  local img_path="$media_path/splashscreen/img/splash1.jpg"
  [ -e "$img_path" ] && { sudo fbi -a -T 1 -d /dev/fb0 -t $timeout --once --noverbose "$img_path"; sleep $timeout; }
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

readInput() {
    Event=''
    read -rs -N 1 -t 0.1 Event1 >/dev/null
    [[ $? -gt 127 ]] && return

    case "$Event1" in
      $'\163')	        Event="S"	;;
      $'\n')            Event="ENTER"   ;;
      ' ')              Event="SPACE"   ;;
      [[:blank:]])      Event="TAB"     ;;
      *)
        read -t 0.01 -rsn5 Event2
        case "$Event2" in
          "[A")         Event="UP"      ;;
          "[B")         Event="DOWN"    ;;
          "[D")         Event="LEFT"    ;;
          "[C")         Event="RIGHT"   ;;
          "OS"|"[[D")   Event="F4"      ;;
          *)
            case "$Event1$Event2" in
              $'\E')    Event="ESC"     ;;
            esac
            ;;
        esac
    esac
    echo -e "${Event}"
}

printer() {
  [[ $# -lt 1 ]] && return
  txt="${1}"; mark="${2:-0}"; pad=''; str=''

  [[ $colors -gt 0 ]] && str="${C}";
  str+="${txt}"; strlen=${#str}

  if [[ $center -gt 0 ]]; then
    [[ $(( strlen % 2 )) > 0 ]] && strlen=$(( strlen - 1 ))
    strlen=$(( strlen / 2 )); length=$(( width / 2 )); length=$(( length - strlen ))
    printf -v pad '%*s' "$length"
  fi

  [[ $mark -gt 0 ]] && str="${MARK}${str}${UNMARK}"; str="${pad}${str}";
  [[ $colors -gt 0 ]] && str+="${NC}"
  echo -e "${str}"
}

sendSerial() {
  [ $# -ge 1 ] && echo -e "$@" > /tmp/serial.fifo || return
}

elapsed() {
  [ $# -gt 0 ] \
  && timer=$(echo $(( 10#$(date +%s) ))) \
  || echo "$(( $(echo $(( 10#$(date +%s) ))) - $timer ))"
}

Init() {
  timers=( "$t_title" "$t_marquee" "$t_fbsaver" "$t_vidsaver" "$t_sleep" )
  trap 'exitFunc' EXIT SIGINT INT

  sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --mode menu; sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --grab joystick

  [[ $hide_term -eq 1 ]] && { PS1=; stty -F /dev/tty1 -echo; sudo setterm --cursor off; }
  [[ $show_splash -eq 1 ]] && showSplash
  [ -f "$assets_path/fb0.dump" ] && sudo rm "$assets_path/fb0.dump"

  elapsed 0
}

exitFunc() {
  [[ $hide_term -eq 1 ]] && { export PS1="$PS1_STORED"; stty -F /dev/tty1 sane; sudo setterm --cursor on; }

  sendSerial "VFD 3  G O O D B Y E "

  sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --mode term; sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --remove joystick

  JOBS=($(jobs -p)); [[ ${#JOBS[@]} -gt 0 ]] && sudo kill -9 "${JOBS[@]}" &> /dev/null

  [[ $post_clear -gt 0 ]] && clear
  exit
}


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

Main

exit


#____________________________________________________________________________
