#!/bin/bash

log_file='/home/pi/ADMIN/.log/serial.log'
port=$(grep 'serial_teensy' /home/pi/ADMIN/.sys/.settings | cut -d\' -f2)
PID=

cleanup() {
  stty sane
  kill $PID
  wait $PID 2>/dev/null
  printf ';' >/dev/ttyACM0
  exec 3<&-
  echo "DONE"
}

trap cleanup EXIT QUIT INT SIGTERM TERM SIGKILL KILL

[ ! -f "$log_file" ] && touch "$log_file"
sudo chmod 775 "$log_file"
printf '' | sudo tee "$log_file" &>/dev/null

# ------------------------------------------------------------------------------------------------

exec 3< /dev/ttyACM0

stty sane && stty -F /dev/ttyACM0 9600 raw -echo

cat <&3 > >( awk -v time="$(echo `date +%T`)" '{print time": "$0}' | sudo tee -a "$log_file" 2>&1) &
PID=$!

# -------------------------------------------------------------------------------------------------

while true; do
  INBOX=$(cat /tmp/pyserial.fifo)

  if [[ ${#INBOX} -gt 1 ]]; then
    echo "VFD 1 $INBOX;" > /dev/ttyACM0 && sleep 1 #&> /dev/null
  fi
done
