#!/bin/bash

SCRIPT=$(readlink -f "$0"); PID=$$
DIR=$(cd "$(dirname $SCRIPT)" && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)

file="${1:-aliens_102.ppm}"
HEIGHT="${file/.*/}";HEIGHT="${HEIGHT##*_}"
FBW=$(cat /sys/class/graphics/fb0/stride)
FBH=$(cat /sys/class/graphics/fb0/virtual_size | cut -d, -f2)
PAD=$(( (FBH - HEIGHT) / 2 ))


makeFiles() {
  local IMG_PATH="$HOMEDIR/ADMIN/FILES/IMAGES/MARQUEES/SCALED"
  for f in $IMG_PATH/*.*; do
    f=${f##*/}; echo "$IMG_PATH/$f"

    if [ ! -f "$IMG_PATH/PPM/${f%%.*}.ppm" ]; then
      sudo fbi -T 2 -d /dev/fb0 --once --noverbose "$IMG_PATH/$f"; sleep 1
      cat /dev/fb0 > "$IMG_PATH/PPM/${f%%.*}.ppm"
      while [[ $(pgrep -c fbi) -gt 0 ]]; do :; done; echo "DONE"
      sudo cp "$IMG_PATH/PPM/${f%%.*}.ppm" "$HOMEDIR/ADMIN/MENU/.assets/media/marquees/${f%%.*}.ppm"
    fi
  done
  sudo chown pi:root "$IMG_PATH"; sudo chmod -R 775 "$IMG_PATH"
}

makeFiles
exit

