#!/bin/bash

SCRIPT=$(readlink -f "$0"); PID=$$
DIR=$(cd "$(dirname $SCRIPT)" && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

key=$(grep -w -m1 'admin_menu_pass' "$HOMEDIR/ADMIN/.sys/.settings" | cut -d\' -f2)
pass=''

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

Main() {
  clear
echo "key: $key"
  echo -ne "PASS: "

  while [[ ${#pass} -lt ${#key} ]]; do
    input=$(readInput)
    if [[ ${#input} -gt 0 ]]; then
      case "${input^^}" in
        'U'|'D'|'L'|'R'|'A'|'B') echo -ne "*"; pass+="${input^^}" ;;
        'S'|'ESC') break ;;
      esac
    fi
  done
  #echo -e "\nENTERED: ${pass}"
  [[ "${pass}" == "$key" ]] && echo -e "\nVALID!" || echo -e "\nINVALID PASS.."
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

readInput() {
    Event=''
    read -rs -N 1 -t 0.1 Event1 >/dev/null
    [[ $? -gt 127 ]] && return

    case "$Event1" in
      $'\163')          Event="S"   ;;
      $'\n')            Event="A"   ;;
      ' ')              Event="B"   ;;
      *)
        read -t 0.01 -rsn5 Event2
        case "$Event2" in
          "[A")         Event="U"   ;;
          "[B")         Event="D"   ;;
          "[D")         Event="L"   ;;
          "[C")         Event="R"   ;;
          *)
            case "$Event1$Event2" in
              $'\E')    Event="ESC"     ;;
            esac
            ;;
        esac
    esac
    echo -e "${Event}"
}


Main
exit
