#!/bin/bash

log_file='/home/pi/ADMIN/.log/serial.log'
fifo_file='/tmp/serial.fifo'
path='/dev/ttyACM'

[ ! -f "$log_file" ] && touch "$log_file"; sudo chmod 775 "$log_file"
echo -e "`date +%F`\n" | sudo tee "$log_file" &>/dev/null

while IFS=$'\n' read line; do
  if [[ ${#line} -gt 1 ]]; then
    INBOX="$line"; nom='TEENSY'; dev=0; br=';'; response=''

    if [[ ${INBOX:1:1} == : ]]; then
      [[ ${INBOX:0:1} =~ ^[0-9]+$ ]] && [[ ${INBOX:0:1} > 0 ]] && { nom='PICO'; dev=1; br='\n' }
      INBOX="${INBOX:2}"
    fi

    INBOX="${INBOX}$br"

    if [ -c "$path$dev" ]; then
      stty -F "$path$dev" 9600 raw -echok -icanon -echo  min 0 time 30 && \
      printf "$INBOX" > "$path$dev" && \
      echo -ne "[ `date +%T` ] RPI: '$INBOX'\t> $nom: " | sudo tee -a "$log_file" &> /dev/null
      #head -n1 "$path$dev" > >( read response && echo "$response" | sudo tee -a "$log_file" &> /dev/null )
      sleep 0.5
    fi
  fi
done< <( cat <>"$fifo_file" )

# __________________________________________________________________________________________________

#head -n1 "$path$dev" > >( \
#  read response && echo -ne "\t$nom: " | sudo tee -a "$log_file" &> /dev/null \
#  echo -e "$( [[ ${#response} -gt 0 ]] && echo $response || echo '' )" | \
#  sed -z 's/\r//g' | sudo tee -a "$log_file" &> /dev/null \
#)

#cleanup() {
#  echo "CLEANING UP"; IFS=$' \t\n'; rm -r /tmp/new.fifo; exit
#}
#trap cleanup QUIT INT SIGTERM TERM SIGKILL KILL

