#!/bin/bash

sys_dir='/home/pi/ADMIN/.sys'
cafca_dir='/home/pi/CAFCA'

teensy_id=$(grep -w -m1 'DEV teensy' "$sys_dir/.settings" | cut -d\' -f2)
game="$(grep -w -m1 '^ACTIVE_GAME' $cafca_dir/data/.settings | cut -d\' -f2 | grep -o '[^/]*$')"
exception_list=$(grep -w -m1 '^EXCEPTION_LIST' "$cafca_dir/data/.settings" | cut -d\' -f2)

printf '' | sudo tee "$cafca_dir/log/retroarch/retroarch.log" >/dev/null 2>&1

sudo python3 /opt/retropie/configs/all/CRT/bin/GeneralModule/systems_check.py

( sudo bash "$cafca_dir/CAFCA.sh" |& sudo tee "$cafca_dir/log/CAFCA.log" >/dev/null 2>&1 & )

if [[ "${game}" == @(${exception_list}) ]]; then
  case $game in
    'blktiger')
      ;;
    'loht')
      sleep 2
      echo "LOHT" > /home/pi/exceptions.tmp
      for state in {1..0}; do evemu-event "$teensy_id" --type EV_KEY --code KEY_ESC --value $state --sync; sleep 0.2; done
      ;;
    *)
      ;;
  esac
fi











# ____________________________________________________________________________


#cafca_dir='/home/pi/CAFCA'
#game_info=$(grep -i -m1 'ACTIVE_GAME' "$cafca_dir/data/.settings" | cut -d\' -f2)
#cafca_action=$(grep -w -m1 'ACTION' "$cafca_dir/data/.settings" | cut -d\' -f2)

#printf '' | sudo tee "$cafca_dir/log/retroarch/retroarch.log" >/dev/null 2>&1

#cp -r "$cafca_dir/data/.states.default" "$cafca_dir/data/.states" 2>/dev/null; sudo chmod 775 "$cafca_dir/data/.states" 2>/dev/null
#sed -i 's|ACTIVE_GAME[=].*$|ACTIVE_GAME='"\x27${game_info}\x27"'|g' "$cafca_dir/data/.states"

#sudo python3 /opt/retropie/configs/all/CRT/bin/GeneralModule/systems_check.py

#( sudo bash "$cafca_dir/CAFCA_NEW.sh" "$game_info" | sudo tee "$cafca_dir/log/CAFCA/.log" >/dev/null 2>&1 & )

# -----------------------------------------------------------------------------

#SCRIPT=$(readlink -f "$0"); PID=$$
#DIR=$(cd "$(dirname $SCRIPT)" && pwd)
#HOMEDIR=$(getent passwd pi | cut -d: -f6

#HOMEDIR='/home/pi'

#cafca_dir="$HOMEDIR/CAFCA"
#cafca_log="$cafca_dir/log/CAFCA.log"
#cafca_settings="$cafca_dir/data/.settings"
#cafca_action=$(grep -w -m1 'action' "$cafca_settings" | cut -d= -f2 | tr '[:lower:]' '[:upper:]')

#game_info="$(grep -i -m1 ACTIVE_GAME $cafca_dir/data/.states | cut -d\' -f2)"

#printf '' | sudo tee "$cafca_dir/log/retroarch/retroarch.log" >/dev/null 2>&1

#cp -r "$cafca_dir/data/.states.default" "$cafca_dir/data/.states" 2>/dev/null; sudo chmod 775 "$cafca_dir/data/.states" 2>/dev/null

#sed -i 's|ACTIVE_GAME[=].*$|ACTIVE_GAME='"\x27${game_info}\x27"'|g' "$cafca_dir/data/.states"
##sed -i 's|ACTIVE_GAME[=].*$|ACTIVE_GAME='"${game_info}"'|g' "$cafca_dir/data/.states"
##sed -i 's|GAME_LOADED[=].*$|GAME_LOADED=1|g' "$cafca_dir/data/.states"

#sudo python3 /opt/retropie/configs/all/CRT/bin/GeneralModule/systems_check.py

#( sudo bash "$cafca_dir/CAFCA_NEW.sh" "$game_info" | sudo tee "$cafca_log" >/dev/null 2>&1 & )

# -----------------------------------------------------------------------------

#admin_dir='/home/pi/ADMIN'
#cafca_dir='/home/pi/CAFCA'

#joy_device=$(grep 'DEV joystick' "$admin_dir/.sys/.settings" | cut -d\' -f2)
#sudo th-cmd --socket /run/thd.socket --remove "$joy_device" --tag joy
#sudo th-cmd --socket /run/thd.socket --mode ra

#printf '' | sudo tee "$cafca_log"
#exec > >(sudo tee -a "$cafca_log" 2>&1)
#sudo sed -i '/UI/ s/VAR UI[=].*$/VAR UI=3/' "$admin_dir/.sys/.states"
#sudo cp -r "$HOMEDIR/CAFCA/data/.states.default" "$HOMEDIR/CAFCA/data/.states"
#sudo sed -i '/GAME_LOADED/ s/GAME_LOADED[=].*$/GAME_LOADED=1/' "$HOMEDIR/CAFCA/data/.states"
#echo -e "UI 3" > /tmp/serial.fifo

#function cafca_loader() {
#  #setsid sudo bash "$cafca_dir/CAFCA.sh" "$cafca_action" RUNCMD &> /dev/null &
#  (sleep 10 && sudo bash "$cafca_dir/DUMP.sh" | sudo tee "$cafca_log" 2>&1) & #&> /dev/null &
#  cafca_pid=$!; cafca_pgid=$(ps opgid= "$cafca_pid")
#  echo -e "GAME_LOADED 1" > /tmp/serial.fifo
#  sudo sed -i '/GAME_LOADED/ s/BOOL GAME_LOADED[=].*$/BOOL GAME_LOADED=1/' "$cafca_dir/data/.states"

#}
