#!/bin/bash

SCRIPT=$(readlink -f $0)
DIR=$(cd $(dirname $SCRIPT) && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)
DATA="$HOMEDIR/ADMIN/.sys/.settings"
THD_DIR="$HOMEDIR/ADMIN/.sys/thd"
DEV_LIST="$THD_DIR/devices"
MODE_LIST="$THD_DIR/mode"
PID=$(cat "$THD_DIR/pid")

index=0; grab=0; args=(); actions=()
names=('teensy' 'joystick' 'udev' 'gun')
name='';  path=''; task=''; output=''; thd_cmd=''; tag=''

# ----------------------------------------------------------------------------------------------------

[[ $# -lt 1 ]] && exit 1; [[ $(ps -p $PID --no-headers | awk '{$1=$1;print}' | wc -c) -lt 1 ]] && exit 1

clear

name_list=$(echo "${names[*]}" | tr ' ' '|')
#ps aux | awk -v pid="$pid" '{$1=$1; if ($2 == pid) print $0;}' | cut -d' ' -f11-

for x in "${@}"; do args+=($(echo "${x}" | sed 's/--\(.*\)/\1/' | tr '[:upper:]' '[:lower:]')); done
for (( i=0; i<${#args[@]}; i++ )); do
  case "${args[$i]}" in
    'add'|'remove'|'tag'|'mode') actions+=("$(echo ${args[$i]} ${args[$(( i + 1 ))]})"); (( i++ )) ;;
    'grab') grab=1 ;;
  esac
done

# ----------------------------------------------------------------------------------------------------

thd_cmd=''; output=''

for act in "${actions[@]}"; do
  target="${act#*[[:blank:]]*}"; action="${act%[[:blank:]]*}"

  if   [[ $action == mode ]]; then
    thd_cmd+="--$act "
    echo "$target" | sudo tee "$MODE_LIST" &>/dev/null

  elif [[ $action == @(add|remove|tag) ]]; then
    if [[ ${#name} -lt 1 ]]; then
      [[ $target =~ '/dev/input/' ]] && { name=$(grep -wi -m1 "$target" "$DATA" | cut -d= -f1 | cut -d' ' -f2); path="$target"; }
      [[ $target == @(${name_list}) ]] && name="$target"
      [[ $action == tag ]] && name="$target"
    fi

    if [[ ${#name} -gt 0 ]]; then
      if [[ $action == @(add|remove) ]]; then
        if [[ $name == @(${name_list}) ]]; then
          [[ ${#path} -lt 1 ]] && path=$(cat "$DATA" | grep "^DEV "| awk '{$1=""; print $0}' | sed 's/ //' | grep -Ewi "^$name" | cut -d\' -f2)
          output+="$name"; task="$action"
        else
          name=''; path=''
        fi
      else
        [[ $action == tag ]] && { path="$target"; tag="$target"; }
      fi
    fi

    if [[ ${#path} -gt 0 ]]; then
      thd_cmd+="--$action $path "

      [[ $grab -eq 1 ]] && { thd_cmd+="--grab "; output+=" (grabbed)"; grab=0; }
      [[ $task == add ]]    && [[ $(grep -wc "^$name" "$DEV_LIST") -lt 1 ]] && echo "$output" | sudo tee -a "$DEV_LIST" &>/dev/null
      [[ $task == remove ]] && [[ $(grep -wc "^$name" "$DEV_LIST") -gt 0 ]] && sudo sed -i "/$name/d" "$DEV_LIST" &> /dev/null
    fi
  fi
done

if [[ ${#thd_cmd} -gt 0 ]]; then
  [[ ${#tag} -eq 0 ]] && { tag="$name"; thd_cmd+="--tag $tag "; }
  thd_cmd="th-cmd --socket /run/thd.socket $thd_cmd"
  sudo bash -c "$thd_cmd; echo $?"
  #rc=$?; #[[ $rc -gt 1 ]] && thd_cmd+=" - ERROR: $?"
  echo "$thd_cmd"
fi
# ----------------------------------------------------------------------------------------------------

#if [[ ${#name} -gt 0 ]]; then
#  [[ $task == add ]]    && [[ $(grep -wc "^$name" "$DEV_LIST") -lt 0 ]] && echo "$name" #| sudo tee -a "$DEV_LIST" #&>/dev/null
#  [[ $task == remove ]] && [[ $(grep -wc "^$name" "$DEV_LIST") -gt 0 ]] && sed -i "/$name/d" "$DEV_LIST" #&> /dev/null
#  #cat "$DEV_LIST"
#fi





exit

# ----------------------------------------------------------------------------------------------------

ignore4() {
for action in "${actions[@]}"; do
  target="${action#*[[:blank:]]*}"; action="${action%[[:blank:]]*}"
  echo -e "action: $action\ntarget: $target"
  if [[ $action == @(add|remove|tag) ]]; then
    echo "FOUND NAME!" # <- REM
    if [[ ${#name} -lt 1 ]]; then
      [[ $target =~ '/dev/input/by-id/' ]] && { name=$(grep -wi -m1 "$target" "DATA" | cut -d= -f1 | cut -d' ' -f2); path="$target"; }
      [[ $target == @(${name_list}) ]] && name="$target"
      [[ $action == tag ]] && name="$target"
    else
      if [[ $name == @(${name_list}) ]]; then
         [[ ${#path} -lt 1 ]] && path=$(cat "$DATA" | grep "^DEV "| awk '{$1=""; print $0}' | sed 's/ //' | grep -Ewi "^$name" | cut -d\' -f2)
      else
         name=''; path=''
      fi
    fi
  fi
  echo -e "name: $name\npath: $path"
done

exit
}

# ----------------------------------------------------------------------------------------------------

ignore3() {
#[[ "$action" == @(add|remove) ]]
#for a in "${actions[@]}"; do [[ $(echo "$a" | awk '{print $2}') == @(teensy|joystick|udev) ]] && echo MATCH; done

for action in "${actions[@]}"; do
  if [[ ${#name} -lt 1 ]]; then
    target="${action#*[[:blank:]]*}"; action="${action%[[:blank:]]*}"
    if [[ $action == add ]] || [[ $action == remove ]]; then
      [[ $target == @(${name_list}) ]] && {     name="$target"; break; }
      [[ $target =~ '/dev/input/by-id/' ]] && { name=$(grep -wi -m1 "$target" "$HOMEDIR/ADMIN/.sys/.settings" | cut -d= -f1 | cut -d' ' -f2); path="$target"; break; }
    fi
  fi
done

if [[ ${#name} -lt 1 ]]; then
  if[[ ${actions[@]} =~ tag ]]; then
    for action in "${actions[@]}"; do
      target="${action#*[[:blank:]]*}"; action="${action%[[:blank:]]*}"
      [[ $action == tag ]] && [[ ${#target} -gt 0 ]] && name="$target"
    done
  fi
fi

#if [[ ${#path} -lt 1 ]]; then; fi
}
# ----------------------------------------------------------------------------------------------------

ignore2() {
if [[ ${actions[@]} =~ tag ]]; then
  for action in "${actions[@]}"; do
    target="${action#*[[:blank:]]*}"; action="${action%[[:blank:]]*}"
    [[ $action == tag ]] && [[ ${#target} -gt 0 ]] && name="$target"
  done
else
  for action in "${actions[@]}"; do
    if [[ ${#name} -lt 1 ]]; then
      target="${action#*[[:blank:]]*}"; action="${action%[[:blank:]]*}"
      if [[ $action == add ]] || [[ $action == remove ]]; then
        [[ $target == @(${name_list}) ]] && {     name="$target"; break; }
        [[ $target =~ '/dev/input/by-id/' ]] && { name=$(grep -wi -m1 "$target" "$HOMEDIR/ADMIN/.sys/.settings" | cut -d= -f1 | cut -d' ' -f2); break; }
      fi
    fi
  done
fi

echo "name: $name"
exit
}
#________________________________________________________________________________________________________

ignore() {
if [[ ${actions[@]} =~ tag ]]; then
  for action in "${actions[@]}"; do
    target="${action#*[[:blank:]]*}"; action="${action%[[:blank:]]*}"
    [[ $action == tag ]] && [[ ${#target} -gt 0 ]] && name="$target"
  done
else
  for action in "${actions[@]}"; do
    target="${action#*[[:blank:]]*}"; action="${action%[[:blank:]]*}"
    if [[ $action == add ]] || [[ $action == remove ]]; then

      [[ $target == @(${name_list}) ]] \
      && { name="$target"; break; }

      [[ $target =~ '/dev/input/by-id/' ]] \
      && { name=$(grep -wi -m1 "$target" "$HOMEDIR/ADMIN/.sys/.settings" | cut -d= -f1 | cut -d' ' -f2); break; }

      #case $target in
      #  'teensy'|'joystick'|'udev'|'gun')
      #    name="$target"
      #    ;;
      #  *)
      #    if [[ $target =~ '/dev/input/by-id/' ]]; then
      #      line=$(grep -wc -m1 "$target" "$HOMEDIR/ADMIN/.sys/.settings")
      #    fi
      #    ;;
      #esac
    fi
  done
fi
}


if [[ ${#actions[@]} -gt 0 ]]; then
  for action in "${actions[@]}"; do
    target="${action#*[[:blank:]]*}"; action="${action%[[:blank:]]*}"
    if [[ ${#target} -gt 0 ]] && ( [[ $action == add ]] || [[ $action == remove ]] ); then
      echo -e "action: $action, target: ${target}"

      #[[ $action == tag ]] && 

      case $target in
        'teensy'|'joystick'|'udev'|'gun')
          echo "target: $target"
          grep "\b$target\w*" "$HOMEDIR/ADMIN/.sys/.settings" | cut -d\' -f2
          ;;
      esac
      #sleep 1
    fi
  done
fi





exit

#____________________________________________________

#log_path='/home/pi/boot.log'

#exec > >(sudo tee file >/dev/null 2>&1)
#exec > >(sudo tee $log_path 2>&1)
#exec > $log_path 2>&1

#teensy_id=''
#joystick_id=''
#lightgun_id=''

while read line; do
  nom=$(echo "$line" | cut -d= -f1); path=$(echo "$line" | cut -d= -f2)
  declare "${nom}_id"="$path"
done< <( cat "$HOMEDIR/ADMIN/.sys/.settings" | awk '{$1=""; print $0}' | sed 's/ //' | grep -Ew '^teensy|^joystick|^gun|^udev' )

#teensy_id="$(grep -w -m1 teensy $HOMEDIR/ADMIN/.sys/.settings | cut -d\' -f2)"
#joystick_id="$(grep -w -m1 joystick $HOMEDIR/ADMIN/.sys/.settings | cut -d\' -f2)"
#lightgun_id="$(grep -w -m1 gun $HOMEDIR/ADMIN/.sys/.settings | cut -d\' -f2)"

teensy_serial="$(ls -lah /dev/serial/by-id | grep -i Teensy | awk -F/ '{print $NF}')"
gun_serial="$(ls -lah /dev/serial/by-id | grep -i GUN | awk -F/ '{print $NF}')"

states_log="$HOMEDIR/ADMIN/.log/_states.log"
thd_devs="$HOMEDIR/ADMIN/.log/_thd_devices.log"

title_list="$HOMEDIR/ADMIN/.sys/arkade.titles"
boot_mode=$(grep -w boot_mode "$HOMEDIR/ADMIN/.sys/.settings" | cut -d\' -f2); boot_mode="${boot_mode,,}"

exit

# ----------------------------------------------------------------------------------------------------


grepinput() {
  [ $# -lt 1 ] && { echo -e "valid options are:\n  'teensy' 'joystick' 'gun'"; return; }
  device="${@}"; delim='/dev/input/by-id/usb-'
  local list=$(cat ~/ADMIN/.sys/.settings | grep -v '\bserial\w*' | grep "^DEV" | sed 's/DEV\ //g; s/light//g')

  case "${device,,}" in 'teensy'|'joystick'|'gun')
    str=$(echo $list | awk 'BEGIN{RS=" "}{$1=$1}1' | grep "\b$device\w*" | cut -d\' -f2)
    [[ "${str}" =~ "${delim}" ]] && str="${str##$delim}"; echo "${str}"
    [[ $(echo "${str,,}" | sed 's/[-_]/\n/g' | grep -ic "^$device") -gt 0 ]] && echo "match!" || echo "no match found.."
    ;;
  esac
}

# ----------------------------------------------------------------------------------------------------

#while read line; do
#  nom=$(echo "$line" | cut -d= -f1)
#  path=$(echo "$line" | cut -d\' -f2)
#  declare "${nom}_path"="$path"
#done< <( cat "$HOMEDIR/ADMIN/.sys/.settings" | awk '{$1=""; print $0}' | sed 's/ //' | grep -Ew '^teensy|^joystick|^gun|^udev' )

#echo "$joystick_path"
#echo "$teensy_path"
#echo "$udev_path"
