#!/bin/bash

log_file='/home/pi/ADMIN/.log/serial.log'
fifo_file='/tmp/serial.fifo'
path='/dev/ttyACM'

[ ! -f "$log_file" ] && touch "$log_file"; sudo chmod 775 "$log_file"
echo -e "`date +%F`\n_______________________________________________________________\n" | sudo tee "$log_file" &>/dev/null

while IFS=$'\n' read line; do
  if [[ ${#line} -gt 1 ]]; then
    INBOX="$line"; nom='TEENSY'; dev=1; response=''

    if [[ ${INBOX:1:1} == ':' ]]; then
      [[ ${INBOX:0:1} =~ ^[0-9]+$ ]] && [[ ${INBOX:0:1} < 1 ]] && { nom='RPPICO'; dev=0; }
      INBOX="${INBOX:2}"
    fi

    if [ -c "$path$dev" ]; then
      stty -F "$path$dev" 9600 raw -echok -icanon -echo  min 0 time 30 && printf "$INBOX;" > "$path$dev"
      response=$(head -n1 "$path$dev" | sed -z 's/\n//g; s/\r//g')

      echo -e "[ `date +%T` ] RPI > $nom: '$INBOX'\n             RPI < $nom: '$response'\n             --------------------------------------------------" \
      | sudo tee -a "$log_file" &> /dev/null; sleep 0.5
    fi
  fi
done< <( cat <>"$fifo_file" )


#trap cleanup QUIT INT SIGTERM TERM SIGKILL KILL

