#!/bin/bash

scriptT=$(( $(date +%s%N) / 1000 ))
log_path='/boot/boot.log'
[ ! -f "$log_path" ] && touch "$log_path"; sudo chmod 775 "$log_path"; sleep 1

#exec > >(sudo tee $log_path >/dev/null) 2>&1
exec > $log_path 2>&1

include_file='/home/pi/ADMIN/.sys/include.sh'
[ -f $include_file ] && source $include_file; include


# SYSTEM VARIABLES
#----------------------------------------------------

while read line; do
  nom=$(echo "$line" | cut -d= -f1); path=$(echo "$line" | cut -d\' -f2)
  declare "${nom}_id"="$path"
done< <( cat "$HOMEDIR/ADMIN/.sys/.settings" | awk '{$1=""; print $0}' | sed 's/ //' | grep -Ew '^teensy|^joystick|^gun|^udev' )

teensy_serial="$(ls -lah /dev/serial/by-id | grep -i Teensy | awk -F/ '{print $NF}')"
gun_serial="$(ls -lah /dev/serial/by-id | grep -i GUN | awk -F/ '{print $NF}')"
states_log="$HOMEDIR/ADMIN/.sys/thd/states.log"
thd_devs="$HOMEDIR/ADMIN/.sys/thd/devices"

title_list="$HOMEDIR/ADMIN/.sys/arkade.titles"
boot_mode=$(grep -w boot_mode "$HOMEDIR/ADMIN/.sys/.settings" | cut -d\' -f2); boot_mode="${boot_mode,,}"

#____________________________________________________

Main() {

   datestring=$(date | cut -c -20)
   echo -e "\nA U T O S T A R T   L O G:"
   echo -e "( $datestring )\n\nlogfile: $log_path\n"

   # FILE OPERATIONS
   #-------------------------------------------------

     fifo_path='/tmp/serial.fifo'
     sudo mkfifo "$fifo_path" && sleep 1
     sudo chown pi:root "$fifo_path" && sudo chmod 775 "$fifo_path"

     sudo sed -i '/serial_teensy/ s/DEV serial_teensy[=].*$/'"DEV serial_teensy=\x27\x2Fdev\x2F$teensy_serial\x27"'/' "$HOMEDIR/ADMIN/.sys/.settings"
     sudo sed -i '/serial_gun/ s/DEV serial_gun[=].*$/'"DEV serial_gun=\x27\x2Fdev\x2F$gun_serial\x27"'/' "$HOMEDIR/ADMIN/.sys/.settings"

     sudo cp -r "$thd_devs.default" "$thd_devs.log"

     [ ! -f "$states_log" ] && sudo touch "$states_log" || printf '' | sudo tee "$states_log" &>/dev/null
     sudo chown pi:root "$states_log" && sudo chmod 775 "$states_log"

     sudo chown -R pi:root "$HOMEDIR/ADMIN/CMD/THD"; sudo chmod -R 775 "$HOMEDIR/ADMIN/CMD/THD"

     echo -e "`date +%F`\n" > "$HOMEDIR/ADMIN/.log/emulationstation.log"
     echo -e "E M U L A T I O N S T A T I O N   L O G\n" > "$HOMEDIR/ADMIN/.log/es.log"


   # DRIVER INITS
   #-------------------------------------------------

     sudo thd --socket /run/thd.socket --triggers /home/pi/ADMIN/.sys/thd/conf --user pi --daemon --uinput /dev/uinput --pidfile /home/pi/ADMIN/.sys/thd/pid

     th_udev=$(timeout 1 evtest 2>&1 | grep --line-buffered -w -m1 triggerhappy | cut -d: -f1); [[ ! $th_udev =~ "/dev/input" ]] && th_udev='/dev/input/event10'
     sudo sed -i 's|DEV udev[=].*$|DEV udev='"\x27$th_udev\x27"'|g' "$HOMEDIR/ADMIN/.sys/.settings"

     [[ $boot_mode == es ]] \
     && { udev_name='udev_es'; teensy_name='teensy_es'; } \
     || { udev_name='udev';    teensy_name='teensy'; }

     sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --add teensy


   # SCRIPTS
   #--------------------------------------------------

     sudo bash "$HOMEDIR/ADMIN/CMD/SERIAL/SERIAL.sh" & sleep 1

     sudo sed -i '/BOOTED/ s/BOOTED[=].*$/BOOTED=1/' "$HOMEDIR/ADMIN/.sys/.states"
     echo -e "BOOTED 1" > "$fifo_path"

     [[ $boot_mode == es ]] && sudo bash "$HOMEDIR/ADMIN/CMD/PLAY/INTRO.sh" 2 &

     sleep 5
     system_info

    ( sleepBg & )

     while true; do
        [[ $boot_mode == es ]] && dump_menu
     done
}

# _______________________________________________________________________________________________________________


system_info() {
   echo -e "BOOT MODE: ${boot_mode}"

   data_model=$(cat /proc/cpuinfo | grep Model | cut -d':' -f2 | sed 's/ //')
   data_serno=$(cat /proc/cpuinfo | grep Serial | cut -d ' ' -f 2 | cut -c 9- | awk '{print "0x" $0}')
   data_os=$(cat /etc/os-release | sed -n '1p' | cut -d\" -f2)
   data_ip=$(hostname -I | cut -d' ' -f1)

   echo -e "\nMODEL:   $data_model\nSERIAL:  $data_serno\nOS:      $data_os\n\nIP ADDR: $data_ip\n"

   sudo systemd-analyze | xargs | sed 's/(//g; s/)//g' | awk -F' ' '{print "BOOT TIMES:\n" $5 "\t\t" $4 "\n" $8 "\t" $7 "\n" $1 "\t\t" $10}'

   STATUS=$(vcgencmd get_throttled | sed -n 's|^throttled=\(.*\)|\1|p')
   if [[ ${STATUS} -ne 0 ]]; then
    echo -n "WARNING: "
     [ $((${STATUS} & 0x00001)) -ne 0 ] && echo "Power is currently Under Voltage" || { [ $((${STATUS} & 0x10000)) -ne 0 ] && echo "Power has previously been Under Voltage"; }
     [ $((${STATUS} & 0x00002)) -ne 0 ] && echo "ARM Frequency is currently Capped" || { [ $((${STATUS} & 0x20000)) -ne 0 ] && echo "ARM Frequency has previously been Capped"; }
     [ $((${STATUS} & 0x00004)) -ne 0 ] && echo "CPU is currently Throttled" || { [ $((${STATUS} & 0x40000)) -ne 0 ] && echo "CPU has previously been Throttled"; }
     [ $((${STATUS} & 0x00008)) -ne 0 ] && echo "Currently at Soft Temperature Limit" || { [ $((${STATUS} & 0x80000)) -ne 0 ] && echo "Previously at Soft Temperature Limit"; }
     echo ""
   fi

   echo -e "\nDISK USAGE:"
   sudo df -h | head -n 2

   echo -e "\nDEVICES:\n_____________________________________\n"
   echo -e " SERIAL:\n   TEENSY:   /dev/$teensy_serial\n   LIGHTGUN: /dev/$gun_serial\n INPUTS:"

   ls -lah /dev/input/by-id | grep event | rev | sort | rev | awk '{$1=$1; print "   /dev/input" substr($11,3,length($11)) ":  " substr($9,5,length($9))}'; echo ""
   ls -lah /dev/input/by-id | grep js    | rev | sort | rev | awk '{$1=$1; print "   /dev/input" substr($11,3,length($11)) ":     " substr($9,5,length($9))}'

   echo -e "\n   teensy_id:          $teensy_id\n   joystick_id:        $joystick_id\n   lightgun_id:        $gun_id\n   udev_id:            $th_udev\n"

   if [[ $boot_mode == es ]]; then
     es_loaded=0
     while [[ $es_loaded -lt 1 ]]; do es_loaded=$(grep -c "device index" "$HOMEDIR/ADMIN/.log/emulationstation.log"); done; sleep 2
     echo -e "\n EMULATIONSTATION:"
     grep "device index" "$HOMEDIR/ADMIN/.log/emulationstation.log" | awk -F'joystick' '{print $2}' | awk -F'\(|\)' '{parts=split($2,n,","); print " ",n[parts],":", $1}'
   fi
}


sleepBg() {
  local asleep=0
  local count=0
  local timeout=$(grep -w -m1 'timeout' "$HOMEDIR/ADMIN/.sys/.settings" | cut -d= -f2)

  #while [[ $(pgrep -fc 'GAMES') -gt 0 ]]; do
  while true; do
    read -t 1 input
    if [[ $count -ge $timeout ]]; then
        [[ $(pgrep -c 'retroarch') -lt 1 ]] && \
        [[ $asleep -eq 0 ]] && { echo -e "ASLEEP 1" > /tmp/serial.fifo; }
        asleep=1; count=0
    elif [[ ${#input} -gt 0 ]]; then
      [[ $asleep -eq 1 ]] && { echo -e "ASLEEP 0" > /tmp/serial.fifo; }
      asleep=0; count=0;
    fi
    (( count++ ))
  done< <(thd --dump /dev/input/event* | grep -v --line-buffered '^#' |& awk -W interactive '{$1=$1;print $NF}' | grep --line-buffered -vw '/dev/input/event1')
}



sleepBg_old() {
  local menu_name='GAMES.sh'
  local timeout=$(grep -w -m1 'timeout' "$HOMEDIR/ADMIN/.sys/.settings" | cut -d= -f2)
  local start=$(echo $(( 10#$(date +%s | tail -c 4) )))

  while :; do
    sudo timeout $timeout bash -c 'while read line; do break; done< <(thd --dump /dev/input/event*)'
    end=$(echo $(( 10#$(date +%s | tail -c 4) )))
    elapsed=$(echo $(( 10#$(( end - start )) )) )

    if [[ $elapsed -ge $timeout ]]; then
      if [[ $(pgrep -fc "$menu_name") -lt 1 ]] \
      && [[ $(pgrep -xc 'omxplayer|retroarch|vlc|ffplay') -lt 1 ]]; then
        echo -e "ASLEEP 1" > /tmp/serial.fifo
        while read line; do break; done< <(thd --dump /dev/input/event* | grep 'EV_KEY')
        echo -e "ASLEEP 0" > /tmp/serial.fifo
        start=$(echo $(( 10#$(date +%s | tail -c 4) )))
      fi
    fi
  done
}


#_______________________________________________________________________________________________________________

# FOR EMULATIONSTATION:

if [[ $boot_mode == es ]]; then
  declare -ga selected=(1 1)
  declare -ga pages=(0 0)
  declare -a KEYS=('ARKADE' 'LIGHTGUN' 'PINBALL' 'CAFCA' 'MAME' 'AMIGA' 'RETROPIE')
  declare -a LENGTHS=(65 51 8)
  declare -a INDEX=(1 1 1 1 1 1 1)

  startup_system=$(grep -wi StartupSystem "$HOMEDIR/.emulationstation/es_settings.cfg" | cut -d\" -f4)
  selection=1; page=0; printed=1
  startT=$(( $(date +%s%N) / 1000 ))

  function dump_menu() {
    pages[0]=$(grep -w -m1 'JOY_POS_X' "$HOMEDIR/ADMIN/.sys/.states" | cut -d= -f2)

    if [[ ${pages[0]} != ${pages[1]} ]]; then
      page=${pages[0]}
      [[ $page -lt 0 ]] && page=$(( 7 + $page ))
      [[ $page -lt ${#LENGTHS[@]} ]] && { sudo sed -i "/JOY_POS_Y/ s/JOY_POS_Y[=].*$/JOY_POS_Y=${INDEX[$page]}/" "$HOMEDIR/ADMIN/.sys/.states"; selected[1]='0'; }
    fi
    pages[1]="${pages[0]}"

    if [[ $page -lt ${#LENGTHS[@]} ]]; then
      selected[0]=$(grep -w -m1 'JOY_POS_Y' "$HOMEDIR/ADMIN/.sys/.states" | cut -d= -f2)

      if [[ ${selected[0]} -ne ${selected[1]} ]]; then
        if [[ ${selected[0]} -lt 1 ]]; then
          selected[0]="${LENGTHS[$page]}"; sudo sed -i "/JOY_POS_Y/ s/JOY_POS_Y[=].*$/JOY_POS_Y=${selected[0]}/" "$HOMEDIR/ADMIN/.sys/.states"
        elif [[ ${selected[0]} -gt ${LENGTHS[$page]} ]]; then
          selected[0]='1'; sudo sed -i "/JOY_POS_Y/ s/JOY_POS_Y[=].*$/JOY_POS_Y=${selected[0]}/" "$HOMEDIR/ADMIN/.sys/.states"
        fi
        INDEX[$page]="${selected[0]}"; selected[1]="${selected[0]}"
        echo -e "INDEX[$page] (${KEYS[$page]}) = ${INDEX[$page]}"
        startT=$(( $(date +%s%N) / 1000 )); printed=0
      else
        if [[ $printed -lt 1 ]]; then
          elapsed=$(( ( $(date +%s%N) / 1000 ) - startT ))
          if [[ $(( elapsed / 1000 )) -gt 2000 ]]; then
            file="$HOMEDIR/ADMIN/.sys/${KEYS[$page],,}.titles"
            title=$(awk -v ln="${selected[0]}" 'NR==ln' "$file")
            echo -e "VFD 1 $title" > /tmp/serial.fifo
            printed=1
          fi
        fi
      fi
    fi
    sleep 1
  }
fi

# ---------------------------------------------------------------------------------------------------------------

Main

exit
