#!/bin/bash

ARG="$@"
SCRIPT=$(readlink -f "$0"); PID=$$
DIR=$(cd "$(dirname $SCRIPT)" && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)
MENUDIR="$HOMEDIR/ADMIN/MENU"
index="$MENUDIR/index"

# __________________________________________________________________________________________

STR=''
lines=$(cat $index | wc -l); idxs=();
idxs=($(grep -Pno '^([^\t|^@]*)' $index | cut -d: -f1)); idxs+=("$lines"); depth=1

for (( i=0; i<$(( ${#idxs[@]} - 1 )); i++ )); do depth=0;
  for (( row=${idxs[$i]}; row<${idxs[$((i+1))]}; row++ )); do line='';
    while [[ ${#line} -lt 1 ]]; do line=$(sed "${row}q;d" $index | grep -P "^[\t]{$depth}[[:graph:]].*$")
      if [[ ${#line} -gt 0 ]]; then
        if [[ "${line}" =~ "@" ]]; then
          STR+=" ) "; (( depth--));
        else
          [[ $row == ${idxs[$i]} ]] && STR+="[$(sed "${row}q;d" $index | grep -P '^([^\t|^@]*)')]" || STR+=" $(echo $line | sed 's/\t//g')"
        fi
      else
        [[ $row == ${idxs[$i]} ]] && STR+="(" || STR+="=("; (( depth++ ))
      fi
    done
  done
done

STR=$(echo "${STR}" | sed -e "s/  \+/ /g" | sed -E 's/]=/]="/g; s/\)\s\[/)" [/g; s/\)*$/)"/g')
echo "STRING: ${STR}"

eval declare -A menu=("$STR")

echo -e "\nMENU:"

for key in "${!menu[@]}"; do
  #echo -e "$key=\x22${menu[$key]}\x22"
  line=$(echo -e "${menu[$key]}" | sed -E 's/\(//;s/\)$//;s/ //')
  echo -e "  $key:\n    $line\n"
done


#for key in "${!menu[@]}"; do echo -e "$key=\x22${menu[$key]}\x22"; done
#for item in "${menu[@]}"; do echo "$item"; done
