#!/bin/bash

SCRIPT=$(readlink -f "$0"); PID=$$
DIR=$(cd "$(dirname $SCRIPT)" && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)

index="$DIR/index"


# ____________________________________________________________________________________________________________


clear

while true; do
  echo -e "level: $level; offset: $offset; choice: '$choice'; start: $start"
  read -srn1 offset

  if [[ ${#offset} -gt 0 ]] && [[ "$offset" =~ ^[0-9]+$ ]]; then
    (( level++ )); choice="${items[$offset]}"; start=${choice%%:*}
  else
    [[ $level -gt 0 ]] && (( level-- ))
  fi

  level_index=$(grep -Pn "^(\t){$level}[[:graph:]].*$" $index)
  items=(" ");items+=($(echo "$level_index" | awk -F: -v n="$start" '{if ($1 > n ) { if ( $2 ~ "@" ) { exit } else { print }}}' | sed 's/\t//g'))
  for item in "${items[@]}"; do echo "$item"; done

  echo -e "\n------------------------------------------\n"

  #grep -Pn "^(\t){$level}[[:graph:]].*$" index
done

exit

#level_index=$(grep -Pn "^(\t){$level}[[:graph:]].*$" index)
#echo "$level_index" | awk -F: -v n="$start" '{if ($1 > n ) { if ( $2 ~ "@" ) { exit } else { print }}}'

while [[ ! "$choice" =~ .*"[".* ]]; do

  level_index=$(grep -Pn "^(\t){$level}[[:graph:]].*$" $index)
  items+=($(echo "$level_index" | awk -F: -v n="$start" '{if ($1 > n ) { if ( $2 ~ "@" ) { exit } else { print }}}' | sed 's/\t//g'))

  echo -e "level: $level; offset: $offset; choice: '$choice'; start: $start\n"
  echo "$level_index" | awk -F: -v n="$start" '{if ($1 > n ) { if ( $2 ~ "@" ) { exit } else { print }}}'

  read -srn1 offset; echo ""

  if [[ ${#offset} -gt 0 ]] && [[ "$offset" =~ ^[0-9]+$ ]]; then
    #last_choice="${choice}"; last_offset="$offset"
    (( level++ )); choice="${items[$offset]}"; start=${choice%%:*}
  #else
  #  if [[ $level -gt 0 ]]; then
  #    (( level-- ))
  #    offset=$last_offset; choice="${last_choice}"; start="${last_choice%%:*}"
  #    #offset=${last%%-*}; choice=${last##*-}; start=${choice%%:*}
  #  fi
  fi


done

exit


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


#level_index=$(grep -Pn "^(\t){$level}[[:graph:]].*$" index)
#echo "$level_index" | awk -F: -v n="$start" '{if ($1 > n ) { if ( $2 ~ "@" ) { exit } else { print }}}'

while [[ ! "$choice" =~ .*"[".* ]]; do

  level_index=$(grep -Pn "^(\t){$level}[[:graph:]].*$" index)
  items+=($(echo "$level_index" | awk -F: -v n="$start" '{if ($1 > n ) { if ( $2 ~ "@" ) { exit } else { print }}}' | sed 's/\t//g'))

  echo -e "level: $level; offset: $offset; choice: '$choice'; start: $start\n"
  echo "$level_index" | awk -F: -v n="$start" '{if ($1 > n ) { if ( $2 ~ "@" ) { exit } else { print }}}'

  read -srn1 offset; echo ""
  last_choice="${choice}";
  if [[ ${#offset} -gt 0 ]] && [[ "$offset" =~ ^[0-9]+$ ]]; then
      #last_choice="${choice}"
      last_offset="$offset"
    (( level++ )); choice="${items[$offset]}"; start=${choice%%:*}
  else
    if [[ $level -gt 0 ]]; then
      (( level-- ))
      offset=$last_offset; choice="${last_choice}"; start="${last_choice%%:*}"
      #offset=${last%%-*}; choice=${last##*-}; start=${choice%%:*}
    fi
  fi


done

exit


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -



level_index=$(grep -Pn "^(\t){$level}[[:graph:]].*$" index)
echo "$level_index" | awk -F: -v n="$start" '{if ($1 > n ) { if ( $2 ~ "@" ) { exit } else { print }}}'

items+=($(echo "$level_index" | awk -F: -v n="$start" '{if ($1 > n ) { if ( $2 ~ "@" ) { exit } else { print }}}' | sed 's/\t//g'))

while [[ ! "$choice" =~ .*"[".* ]]; do


  read -srn1 offset; echo ""

  if [[ ${#offset} -gt 0 ]] && [[ "$offset" =~ ^[0-9]+$ ]]; then
    (( level++ )); choice="${items[$offset]}"; start=${choice%%:*}; last="$offset-${choice}"
  else
    if [[ $level -gt 0 ]]; then
      (( level-- )); offset=${last%%-*}; choice=${last##*-}; start=${choice%%:*}
    fi
  fi


  level_index=$(grep -Pn "^(\t){$level}[[:graph:]].*$" index)
  items+=($(echo "$level_index" | awk -F: -v n="$start" '{if ($1 > n ) { if ( $2 ~ "@" ) { exit } else { print }}}' | sed 's/\t//g'))

  echo -e "level: $level; offset: $offset; choice: '$choice'; start: $start\n"

  echo "$level_index" | awk -F: -v n="$start" '{if ($1 > n ) { if ( $2 ~ "@" ) { exit } else { print }}}'
done

exit


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -



while true; do
  level_index=$(grep -Pn "^(\t){$level}[[:graph:]].*$" index)
  echo "$level_index" | awk -F: -v n="$start" '{if ($1 > n ) { if ( $2 ~ "@" ) { exit } else { print }}}'

  read -srn1 offset; echo ""
  if [[ ${#offset} -gt 0 ]] && [[ "$offset" =~ ^[0-9]+$ ]]; then
     echo "OFFSET: $offset"; (( level++ )); start=${choice%%:*}; last=$(( offset - 1 ))
  fi
done

exit

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

# IMPROVE CODE BELOW:

while [[ ! "$choice" =~ .*"[".* ]]; do
  level_index=$(grep -Pn "^(\t){$level}[[:graph:]].*$" index)
  items=(" "); items+=($(echo "$level_index" | awk -F: -v n="$start" '{if ($1 > n ) { if ( $2 ~ "@" ) { exit } else { print }}}' | sed 's/\t//g'))

  echo "$level_index" | awk -F: -v n="$start" '{if ($1 > n ) { if ( $2 ~ "@" ) { exit } else { print }}}'
  read -srn1 offset; echo ""

  if [[ ${#offset} -gt 0 ]] && [[ "$offset" =~ ^[0-9]+$ ]] && [[ $offset -lt ${#items[@]} ]]; then
    (( level++ ))
    choice="${items[$offset]}"; start=${choice%%:*}; last=$(( offset - 1 ))
  else
    (( level-- )); offset=$last
  fi
  echo "offset: $offset; choice: '$choice'; start: $start"
done


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

exit

# ____________________________________________________________________________________________________________

# DUMP

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

level_index=$(grep -Pn "^(\t){$level}[[:graph:]].*$" index)
echo "$level_index" | awk -F: -v n="$start" '{if ($1 > n ) { if ( $2 ~ "@" ) { exit } else { print }}}'

while [[ ! "$choice" =~ .*"[".* ]]; do
  level_index=$(grep -Pn "^(\t){$level}[[:graph:]].*$" index)
  items=(" "); items+=($(echo "$level_index" | awk -F: -v n="$start" '{if ($1 > n ) { if ( $2 ~ "@" ) { exit } else { print }}}' | sed 's/\t//g'))

  echo "$level_index" | awk -F: -v n="$start" '{if ($1 > n ) { if ( $2 ~ "@" ) { exit } else { print }}}'
  read -srn1 offset; echo ""

  if [[ ${#offset} -gt 0 ]] && [[ "$offset" =~ ^[0-9]+$ ]] && [[ $offset -lt ${#items[@]} ]]; then
    (( level++ ))
    choice="${items[$offset]}"; start=${choice%%:*}; last=$(( offset - 1 ))
  else
    (( level-- )); offset=$last
  fi
  echo "offset: $offset; choice: '$choice'; start: $start"
done


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

#if [[ ${#offset} -gt 0 ]]; then
#  if [[ "$offset" =~ ^[0-9]+$ ]] && [[ $offset -lt ${#items[@]} ]]; then
#    choice="${items[$offset]}"; start=${choice%%:*}; last=$(( offset - 1 ))
#    echo "offset: $offset; choice: '$choice'; start: $start"
#  fi
#  (( level++ ))
#else
#  (( level-- )); offset=$last
#fi

#echo "$level_index" | grep -m$offset '@' | tail -n 1
