#!/bin/bash

ARG="$@"
SCRIPT=$(readlink -f "$0"); PID=$$
DIR=$(cd "$(dirname $SCRIPT)" && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)

index="$DIR/index"

items=(); last_items=()
choice=''; last_choice=''
crumbs=(); crumbs+=(" "); choices=()
level=0; start=0; end=0; init=1

# ___________________________________________________________________________

clear
cat $index; echo ""; sleep 1

# ___________________________________________________________________________

makeList() {
  local nav=${1:-1}

  if [[ $nav -eq 0 ]]; then
    #unset crumbs[-1]; choice="${crumbs[-1]}"; (( level-- ));
    #items="${last_items[@]}"; choice="$last_choice";
    [[ $init -eq 1 ]] && { items="${last_items[@]}"; choice="$last_choice"; }
    (( level-- ))
 else
    start=$(grep -Pn "^(\t){$level}[[:graph:]].*$" $index | grep -m1 "${choice}" | cut -d: -f1)

    [[ $init -eq 1 ]] && { init=0; } || (( level++ ))

    end=$(awk -v n="$start" 'NR > n' $index | grep -Pn -m1 "^(\t){$level}@.*$" | cut -d: -f1)
    items=($(for (( n=start; n<$(( start + end )); n++ )); do awk -v n="$n" 'NR==n' index; done | grep -P "^(\t){$level}[[:graph:]].*$" | sed 's/\t//g'))

    #clear; sleep 0.5; echo -e "${crumbs[@]}\n"

    echo "level: $level"
  fi
  last_items="${items[@]}"; last_choice="$choice"
  for item in ${items[@]}; do echo $item; done;
}

# ---------------------------------------------------------------------------

Main() {
  local id=
  local cmd=

  read choice; echo ""
  if [[ ${#choice} -gt 0 ]]; then choice="${choice^^}"
    for item in "${items[@]}"; do [[ "${item}" == ${choice}* ]] && break; done

    if [[ "$item" =~ .*"[".* ]]; then
      id=$(echo "$item" | sed 's/[][]\(.*\)//g')
      cmd=$(echo "$item" | sed 's/^.*\[\(.*\)\].*$/\1/')
      echo -e "ITEM = ( $id : $cmd )"
      sleep 1
    else
      echo -e "ITEM = '$item'"
      crumbs+=("$choice"); #echo "CRUMBS: ${crumbs[@]}"
      sleep 1
      makeList 1
    fi

    #for item in "${items[@]}"; do name="${item%%[*}"; [[ "$name" == "$choice" ]] && echo "$item"; done
    #for i in "${items[@]}"; do [[ "${choice^^}" == "$(echo $i | cut -d[ -f1)" ]] && { choice="$i"; break; }; done
    #echo "choice: $choice"
    #if [[ $(echo "${choice}" | grep -Pc '\[.*?\]') -lt 1 ]]; then
    #  choice="$(echo $i | cut -d[ -f1)"
    #  (( level++ )); crumbs+=("$choice");
    #   makeList
    #else
    #  echo -e "CMD: $(echo ${choice} | awk -F'\[|\]' '{print $2}')\n"
    #fi

  else
    [[ $level -gt 0 ]] && makeList 0
  fi
}

# ---------------------------------------------------------------------------

makeList
while true; do Main; done
exit


# ___________________________________________________________________________








Main_bak1() {
  makeList
  read choice; echo ""
  makeList
}
