#!/bin/bash

ARG="$@"
SCRIPT=$(readlink -f "$0"); PID=$$
DIR=$(cd "$(dirname $SCRIPT)" && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)
MENUDIR="$HOMEDIR/ADMIN/MENU"
index="$DIR/index"

# __________________________________________________________________________________________

clear
cat $index; echo ""; sleep 2

# __________________________________________________________________________________________

level=0; choice=''
crumbs=(); crumbs+=(" "); items=(); start=0; end=0; init=1


# INIT
start=$(grep -Pn "^(\t){$level}[[:graph:]].*$" $index | grep -m1 "${choice}" | cut -d: -f1)
end=$(awk -v n="$start" 'NR > n' $index | grep -Pn -m1 "^(\t){$level}@.*$" | cut -d: -f1)
items=($(for (( n=start; n<=end; n++ )); do line=$(awk -v n="$n" 'NR==n' $index | grep -P "^(\t){$level}[[:graph:]].*$"); [[ "$line" =~ "@" ]] && break; (( ${#line} )) && echo "$line" | sed 's/\t//g'; done))
for item in ${items[@]}; do echo $item; done

level=1; choice='ENTRY2'

# ! INIT
start=$(grep -Pn "^(\t){$level}[[:graph:]].*$" $index | grep -m1 "${choice}" | cut -d: -f1)
end=$(awk -v n="$start" 'NR > n' $index | grep -Pn -m1 "^(\t){$((level+1))}@.*$" | cut -d: -f1)
#(( level++ ))
items=($(for (( n=start+1; n<$(( start + end )); n++ )); do awk -v n="$n" 'NR==n' index; done | grep -P "^(\t){$level}[[:graph:]].*$" | sed 's/\t//g'))
for item in ${items[@]}; do echo $item; done

exit

# __________________________________________________________________________________________

level=0; choice=''
crumbs=(); crumbs+=(" "); items=(); start=0; end=0; init=1

function makeList() {
  echo "CHOICE: $choice"
  start=$(grep -Pn "^(\t){$level}[[:graph:]].*$" $index | grep -m1 "${choice}" | cut -d: -f1)
  [[ $init -eq 1 ]] && init=0 || { (( level++ )); (( start++ )); }

  end=$(awk -v n="$start" 'NR > n' $index | grep -Pn -m1 "^(\t){$level}@.*$" | cut -d: -f1)
  #items=($(for (( n=start; n<=end; n++ )); do line=$(awk -v n="$n" 'NR==n' $index | grep -P "^(\t){$level}[[:graph:]].*$"); [[ "$line" =~ "@" ]] && break; (( ${#line} )) && echo "$line" | sed 's/\t//g'; done))
  items=($(for (( n=start; n<$(( start + end )); n++ )); do awk -v n="$n" 'NR==n' index; done | grep -P "^(\t){$level}[[:graph:]].*$" | sed 's/\t//g'))
  for item in ${items[@]}; do echo $item; done; echo ""
}

makeList
level=1; choice='ENTRY2'
makeList

#start=$(grep -Pn "^(\t){$level}[[:graph:]].*$" $index | grep -m1 "${choice}" | cut -d: -f1)
#end=$(awk -v n="$start" 'NR > n' $index | grep -Pn -m1 "^(\t){$((level+1))}@.*$" | cut -d: -f1)
#(( level++ ))
#items=($(for (( n=start+1; n<$(( start + end )); n++ )); do awk -v n="$n" 'NR==n' index; done | grep -P "^(\t){$level}[[:graph:]].*$" | sed 's/\t//g'))
#for item in ${items[@]}; do echo $item; done


#while true; do
#  read choice; echo ""
#  if [[ ${#choice} -gt 0 ]]; then
    #for i in "${items[@]}"; do [[ "${choice^^}" == "$(echo $i | cut -d[ -f1)" ]] && { choice="$i"; break; }; done
    #echo "choice: $choice"
    #if [[ $(echo "${choice}" | grep -Pc '\[.*?\]') -lt 1 ]]; then
    #  choice="$(echo $i | cut -d[ -f1)"
    #  (( level++ )); crumbs+=("$choice");
    #   makeList
    #  end=$(awk -v n="$start" 'NR > n' index | grep -Pn -m1 "^(\t){$level}@.*$" | cut -d: -f1)
    #  items=($(for (( n=start; n<=end; n++ )); do line=$(awk -v n="$n" 'NR==n' $index | grep -P "^(\t){$level}[[:graph:]].*$"); [[ "$line" =~ "@" ]] && break; (( ${#line} )) && echo "$line" | sed 's/\t//g'; done))
    #else
    #  echo -e "CMD: $(echo ${choice} | awk -F'\[|\]' '{print $2}')\n"
    #fi
  #else
  #  #(( level-- ))
#  fi

  #items=($(for (( n=start; n<$(( start + end )); n++ )); do awk -v n="$n" 'NR==n' $index; done | grep -P "^[\t]{$level}[[:graph:]].*$" | grep -v '@' | sed 's/\t//g'))
  #for item in ${items[@]}; do echo $item; done; echo ""
#done

exit

# __________________________________________________________________________________________

# __________________________________________________________________________________________

level=0; choice=''; crumbs=(); crumbs+=(" "); items=(); start=0; end=0

function makeList() {
  start=$(grep -Pn "^(\t){$level}[[:graph:]].*$" index | grep -m1 "${choice}" | cut -d: -f1)
  end=$(awk -v n="$start" 'NR > n' index | grep -Pn -m1 "^(\t){$level}@.*$" | cut -d: -f1)
  items=($(for (( n=start; n<=end; n++ )); do line=$(awk -v n="$n" 'NR==n' $index | grep -P "^(\t){$level}[[:graph:]].*$"); [[ "$line" =~ "@" ]] && break; (( ${#line} )) && echo "$line" | sed 's/\t//g'; done))
  for item in ${items[@]}; do echo $item; done
}

# INITIAL
start=$(grep -Pn "^(\t){$level}[[:graph:]].*$" index | grep -m1 "${choice}" | cut -d: -f1)
end=$(awk -v n="$start" 'NR > n' index | grep -Pn -m1 "^(\t){$level}@.*$" | cut -d: -f1)
items=($(for (( n=start; n<=end; n++ )); do line=$(awk -v n="$n" 'NR==n' $index | grep -P "^(\t){$level}[[:graph:]].*$"); [[ "$line" =~ "@" ]] && break; (( ${#line} )) && echo "$line" | sed 's/\t//g'; done))
for item in ${items[@]}; do echo $item; done

while true; do
  read choice; echo ""
  if [[ ${#choice} -gt 0 ]]; then
    for i in "${items[@]}"; do [[ "${choice^^}" == "$(echo $i | cut -d[ -f1)" ]] && { choice="$i"; break; }; done
    echo "choice: $choice"
    if [[ $(echo "${choice}" | grep -Pc '\[.*?\]') -lt 1 ]]; then
      choice="$(echo $i | cut -d[ -f1)"
      (( level++ )); crumbs+=("$choice");
       makeList
    #  end=$(awk -v n="$start" 'NR > n' index | grep -Pn -m1 "^(\t){$level}@.*$" | cut -d: -f1)
    #  items=($(for (( n=start; n<=end; n++ )); do line=$(awk -v n="$n" 'NR==n' $index | grep -P "^(\t){$level}[[:graph:]].*$"); [[ "$line" =~ "@" ]] && break; (( ${#line} )) && echo "$line" | sed 's/\t//g'; done))
    #else
    #  echo -e "CMD: $(echo ${choice} | awk -F'\[|\]' '{print $2}')\n"
    fi
  else
    sleep 1
    #(( level-- ))
  fi

  #items=($(for (( n=start; n<$(( start + end )); n++ )); do awk -v n="$n" 'NR==n' $index; done | grep -P "^[\t]{$level}[[:graph:]].*$" | grep -v '@' | sed 's/\t//g'))
  #for item in ${items[@]}; do echo $item; done; echo ""
done

exit

# __________________________________________________________________________________________

level=0; choice=''; crumbs=(); crumbs+=(" ")

start=$(grep -Pn "^(\t){$level}[[:graph:]].*$" index | grep -m1 "${choice}" | cut -d: -f1)
end=$(awk -v n="$start" 'NR > n' index | grep -Pn -m1 "^(\t){$level}@.*$" | cut -d: -f1)
items=($(for (( n=start; n<=end; n++ )); do line=$(awk -v n="$n" 'NR==n' $index | grep -P "^(\t){$level}[[:graph:]].*$"); [[ "$line" =~ @ ]] && break; (( ${#line} )) && echo "$line" | sed 's/\t//g'; done))

#end=$(tail -n +$start index | grep -Pn -m1 "^(\t){$level}@.*$" | cut -d: -f1)
#items=($(for (( n=start; n<=end; n++ )); do awk -v n="$n" 'NR==n' $index; done | grep -P "^[\t]{$level}[[:graph:]].*$" | grep -v '@' | sed 's/\t//g'))
#items=($(for (( n=start; n<=end; n++ )); do line=$(sed "${n}q;d" index | grep -P "^(\t){$level}[[:graph:]].*$"); [[ "$line" =~ @ ]] && break; (( ${#line} )) && echo "$line" | sed 's/\t//g'; done))
for item in ${items[@]}; do echo $item; done
exit

# __________________________________________________________________________________________


level=0; choice=''; crumbs=(); crumbs+=(" ")

start=$(grep -Pn "^(\t){$level}[[:graph:]].*$" index | grep -m1 "${choice}" | cut -d: -f1)
end=$(tail -n +$start index | grep -Pn -m1 "^(\t){$level}@.*$" | cut -d: -f1)
for (( n=start; n<=end; n++ )); do line=$(sed "${n}q;d" index | grep -P "^(\t){$level}[[:graph:]].*$"); [[ "$line" =~ @ ]] && break; (( ${#line} )) && echo "$line"; done

exit

# __________________________________________________________________________________________

level=0; choice=''; crumbs=(); crumbs+=(" ")

# INITAL LIST:
start=$(grep -Pn -m1 "^[\t]{$level}$choice.*$" $index | cut -d: -f1); echo $start
end=$(awk -v n="$start" 'NR > n' index | grep -Pn -m1 "^[\t]{$level}@.*$" | cut -d: -f1); echo $end
items=($(for (( n=start; n<$(( start + end )); n++ )); do awk -v n="$n" 'NR==n' $index; done | grep -P "^[\t]{$level}[[:graph:]].*$" | grep -v '@' | sed 's/\t//g'))
for item in ${items[@]}; do echo $item; done; echo ""

while true; do
  read choice; echo ""
  if [[ ${#choice} -gt 0 ]]; then
    for i in "${items[@]}"; do [[ "${choice^^}" == "$(echo $i | cut -d[ -f1)" ]] && { choice="$i"; break; }; done
    if [[ $(echo "${choice}" | grep -Pc '\[.*?\]') -lt 1 ]]; then
      (( level++ )); crumbs+=("$choice");
      #end=$(awk -v n="$start" 'NR > n' index | grep -Pn -m1 "^[\t]{$level}@.*$" | cut -d: -f1)
      for (( n=start; n<$(( start + end )); n++ )); do awk -v n="$n" 'NR==n' $index; done | grep -P "^[\t]{$level}[[:graph:]].*$"
    else
      echo -e "CMD: $(echo ${choice} | awk -F'\[|\]' '{print $2}')\n"
    fi
  else
    (( level-- ))
  fi



  # KEEP
  items=($(for (( n=start; n<$(( start + end )); n++ )); do awk -v n="$n" 'NR==n' $index; done | grep -P "^[\t]{$level}[[:graph:]].*$" | grep -v '@' | sed 's/\t//g'))
  for item in ${items[@]}; do echo $item; done; echo ""
done

exit

# __________________________________________________________________________________________

level=0; choice=''; crumbs=(); crumbs+=(" ")

# INITAL LIST:
start=$(grep -Pn -m1 "^[\t]{0}$choice.*$" $index | cut -d: -f1); echo $start; end=$(awk -v n="$start" 'NR > n' index | grep -Pn -m1 "^[\t]{0}@.*$" | cut -d: -f1); echo $end
items=($(for (( n=start; n<$(( start + end )); n++ )); do awk -v n="$n" 'NR==n' $index; done | grep -P "^[\t]{0}[[:graph:]].*$" | grep -v '@' | sed 's/\t//g'))
for item in ${items[@]}; do echo $item; done

while true; do
  read choice #; echo -e "${choice^^}\n"
  for i in "${items[@]}"; do [[ "${choice^^}" =~ "${i%%[*}" ]] && { echo "CHOICE: $i"; choice="$i"; }; break; done

  if [[ $(echo "${choice}" | grep -Pc '\[.*?\]') -lt 1 ]]; then
    (( level++ )); crumbs+=("$choice");
    end=$(awk -v n="$start" 'NR > n' index | grep -Pn -m1 "^[\t]{$level}@.*$" | cut -d: -f1)
  else
    echo -e "CMD: $(echo ${choice} | awk -F'\[|\]' '{print $2}')\n"
  fi

  #read choice; choice=${choice^^}; echo "choice: $choice"
  #if [[ "${items[@]}" =~ "$( echo $choice | cut -d[ -f1)" ]]; then
  #if [[ "${items[@]}" =~ "${choice}" ]]; then
  #  echo "${choice}" | grep -Pc '\[.*?\]'
  #  (( level++ )); crumbs+=("$choice");
  #  end=$(awk -v n="$start" 'NR > n' index | grep -Pn -m1 "^[\t]{$level}@.*$" | cut -d: -f1)
  #  #if [[ $(echo "${choice}" | grep -Pc '\[.*?\]') -lt 1 ]]; then
  #  #  (( level++ )); crumbs+=("$choice");
  #  #  end=$(awk -v n="$start" 'NR > n' index | grep -Pn -m1 "^[\t]{$level}@.*$" | cut -d: -f1)
  #  #else
  #  #  echo "$CMD: $(echo $line | awk -F'\[|\]' '{print $2}')"
  #  #fi
  #fi

  items=($(for (( n=start; n<$(( start + end )); n++ )); do awk -v n="$n" 'NR==n' $index; done | grep -P "^[\t]{$level}[[:graph:]].*$" | grep -v '@' | sed 's/\t//g'))
  for item in ${items[@]}; do echo $item; done
done

exit

# __________________________________________________________________________________________


level=0; choice=''; crumbs=(); crumbs+=(" ")

# INITAL LIST:
start=$(grep -Pn -m1 "^[\t]{0}$choice.*$" $index | cut -d: -f1); echo $start; end=$(awk -v n="$start" 'NR > n' index | grep -Pn -m1 "^[\t]{0}@.*$" | cut -d: -f1); echo $end
items=($(for (( n=start; n<$(( start + end )); n++ )); do awk -v n="$n" 'NR==n' $index; done | grep -P "^[\t]{0}[[:graph:]].*$" | grep -v '@' | sed 's/\t//g'))
for item in ${items[@]}; do echo $item; done

while true; do
  read choice; choice=${choice^^}; echo "choice: $choice"
  [[ "${items[@]}" =~ "$choice" ]] && { (( level++ )); crumbs+=("$choice"); end=$(awk -v n="$start" 'NR > n' index | grep -Pn -m1 "^[\t]{$level}@.*$" | cut -d: -f1); }
  items=($(for (( n=start; n<$(( start + end )); n++ )); do awk -v n="$n" 'NR==n' $index; done | grep -P "^[\t]{$level}[[:graph:]].*$" | grep -v '@' | sed 's/\t//g'))
  for item in ${items[@]}; do echo $item; done
done

exit

# __________________________________________________________________________________________


level=0; choice=''; items=();
crumbs=(); crumbs+=(" ")



while true; do

start=$(grep -Pn -m1 "^[\t]{$level}$choice.*$" $index | cut -d: -f1);
end=$(awk -v n="$start" 'NR >= n' $index | grep -Pn -m1 "^[\t]{$level}@.*$" | cut -d: -f1);
items=($(for (( n=start; n<$(( start + end )); n++ )); do awk -v n="$n" 'NR==n' $index; done | grep -P "^[\t]{$level}[[:graph:]].*$" | grep -v '@' | sed 's/\t//g'))
for item in ${items[@]}; do echo "$item"; done

read choice; choice=${choice^^}; echo "choice: $choice"

if [[ "${items[@]}" =~ "$choice" ]]; then
  echo -e "MATCH\n"; crumbs+=("$choice")
  #end=$(awk -v n="$start" 'NR >= n' $index | grep -Pn -m1 "^[\t]{$((level+1))}@.*$" | cut -d: -f1);
  (( level++ ))
fi
done

exit
# __________________________________________________________________________________________

echo ""
level=0; choice=''
[[ $level -eq 0 ]] && [[ ${#choice} -eq 0 ]] && depth=$level || depth=$(( level+1 ))

start=$(grep -Pn -m1 "^[\t]{$level}$choice.*$" $index | cut -d: -f1);
end=$(awk -v n="$start" 'NR >= n' $index | grep -Pn -m1 "^[\t]{$depth}@.*$" | cut -d: -f1);
echo "start: $start, end: $end"

for (( n=start; n<$(( start + end )); n++ )); do awk -v n="$n" 'NR==n' $index; done | grep -P "^[\t]{$depth}[[:graph:]].*$" | grep -v '@' | sed 's/\t//g'
#for (( n=start; n<$(( start + end )); n++ )); do sed "${n}q;d" $index; done | grep -P "^[\t]{$depth}[[:graph:]].*$" | grep -v '@' | sed 's/\t//g'

echo ""
level=0; choice='ENTRY3'
[[ $level -eq 0 ]] && [[ ${#choice} -eq 0 ]] && depth=$level || depth=$(( level+1 ))
start=$(grep -Pn -m1 "^[\t]{$level}$choice.*$" $index | cut -d: -f1);
end=$(awk -v n="$start" 'NR >= n' $index | grep -Pn -m1 "^[\t]{$depth}@.*$" | cut -d: -f1);
echo "start: $start, end: $end"

for (( n=start; n<$(( start + end )); n++ )); do awk -v n="$n" 'NR==n' $index; done | grep -P "^[\t]{$depth}[[:graph:]].*$" | grep -v '@' | sed 's/\t//g'
#for (( n=start; n<$(( start + end )); n++ )); do sed "${n}q;d" $index; done | grep -P "^[\t]{$depth}[[:graph:]].*$" | grep -v '@' | sed 's/\t//g'

exit

function makeList() {
  local depth=$1; local choice=${2:-''}
  [[ $depth -eq 0 ]] && [[ ${#choice} -eq 0 ]] && d=$depth || d=$(( depth+1 ))

  start=$(grep -Pn -m1 "^[\t]{$depth}${choice}.*$" $index | cut -d: -f1);
  end=$(awk -v n="$start" 'NR >= n' $index | grep -Pn -m1 "^[\t]{$d}@.*$" | cut -d: -f1);
  #end=$(tail -n "+$start" $index | grep -Pn -m1 "^[\t]{$d}@.*$" | cut -d: -f1);
  echo "start: $start, end: $end"
  for (( n=start; n<$(( start + end )); n++ )); do sed "${n}q;d" $index; done | grep -P "^[\t]{$d}[[:graph:]].*$" | grep -v '@' | sed 's/\t//g'
  echo ""
}

makeList 0 ''
#depth=0; entry='ENTRY3'
makeList 1 'ENTRY1'
exit

# __________________________________________________________________________________________

#depth=0; choice=''

function makeList() {
  local depth=$1; local choice=${2:-''}
  [[ $depth -eq 0 ]] && [[ ${#choice} -eq 0 ]] && d=$depth || d=$(( depth+1 ))

  start=$(grep -Pn -m1 "^[\t]{$depth}${choice}.*$" $index | cut -d: -f1);
  end=$(awk -v n="$start" 'NR >= n' $index | grep -Pn -m1 "^[\t]{$d}@.*$" | cut -d: -f1);
  #end=$(tail -n "+$start" $index | grep -Pn -m1 "^[\t]{$d}@.*$" | cut -d: -f1);
  echo "start: $start, end: $end"
  for (( n=start; n<$(( start + end )); n++ )); do sed "${n}q;d" $index; done | grep -P "^[\t]{$d}[[:graph:]].*$" | grep -v '@' | sed 's/\t//g'
  echo ""
}

makeList 0 ''
#depth=0; entry='ENTRY3'
makeList 1 'ENTRY1'
exit

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


[[ $depth -eq 0 ]] && [[ ${#choice} -eq 0 ]] && d=$(( depth+1 )) || d=$depth

start=$(grep -Pn -m1 "^[\t]{$depth}${choice}.*$" $index | cut -d: -f1); echo "start: $start"
end=$(tail -n +${start} $index | grep -Pn -m1 "^[\t]{$d}@.*$" | cut -d: -f1); echo "end: $end"
for (( n=start; n<$(( start + end )); n++ )); do sed "${n}q;d" $index; done | grep -P "^[\t]{$d}[[:graph:]].*$" | grep -v '@' | sed 's/\t//g'
echo ""

#while true; do
#  start=$(grep -Pn -m1 "^[\t]{$depth}${choice}.*$" $index | cut -d: -f1); echo "start: $start"
#  end=$(tail -n +$start "$index" | grep -Pn -m1 "^[\t]{$((depth+1))}@.*$" | cut -d: -f1); echo "end: $end"
#
#  for (( n=start; n<$(( start+end )); n++ )); do sed "${n}q;d" $index; done | grep -P "^[\t]{$depth}[[:graph:]].*$" | grep -v '@' | sed 's/\t//g'

  #if [[ $(grep -Pc "^[\t]{$depth}${choice}.*$" $index) -gt 0 ]]; then
  # (( depth++ ))
  #  for (( n=start; n<$(( start+end )); n++ )); do sed "${n}q;d" $index; done | grep -P "^[\t]{$depth}[[:graph:]].*$" | grep -v '@' | sed 's/\t//g'
  #  #echo "$start $end"; (( depth++ ))
  #fi

  #read -r choice; echo "$choice"
  #[[ $(grep -Pc "^[\t]{$depth}${choice}.*$" $index) -gt 0 ]] && { echo "CHOICE: ${choice}"; (( depth++ )); }
  #echo "$depth"

#done

exit

# __________________________________________________________________________________________

depth=0; choice=''

while true; do
  if [[ $depth -eq 0 ]] && [[ ${#choice} -eq 0 ]]; then
    start=$(grep -Pno '^([^\t]*)' $index | sed '1q;d' | cut -d: -f1); echo "start: $start"
    end=$(grep -Pno '^([^\t]*)' $index | sed '$!d' | cut -d: -f1); echo "end: $end"
  else
    start=$(grep -Pn -m1 "^[\t]{$depth}${choice}.*$" $index | cut -d: -f1); echo "start: $start"
    end=$(tail -n +$start "$index" | grep -Pn -m1 "^[\t]{$((depth+1))}@.*$" | cut -d: -f1); echo "end: $end"
  fi

  for (( n=start; n<$(( start+end )); n++ )); do sed "${n}q;d" $index; done | grep -P "^[\t]{$depth}[[:graph:]].*$" | grep -v '@' | sed 's/\t//g'

  #if [[ $(grep -Pc "^[\t]{$depth}${choice}.*$" $index) -gt 0 ]]; then
  # (( depth++ ))
  #  for (( n=start; n<$(( start+end )); n++ )); do sed "${n}q;d" $index; done | grep -P "^[\t]{$depth}[[:graph:]].*$" | grep -v '@' | sed 's/\t//g'
  #  #echo "$start $end"; (( depth++ ))
  #fi

  read -r choice; echo "$choice"
  [[ $(grep -Pc "^[\t]{$depth}${choice}.*$" $index) -gt 0 ]] && { echo "CHOICE: ${choice}"; (( depth++ )); }
  echo "$depth"
  #start=$(grep -Pn -m1 "^[\t]{$offset}${choice}.*$" $index | cut -d: -f1);
  #end=$(tail -n +${start%%:*} $index | grep -Pn -m1 "^[\t]{$offset}@.*$" | cut -d: -f1);
  #for (( n=start; n<$((start+end)); n++ )); do sed "${n}q;d" $index; done | grep -P "^[\t]{$offset}[[:graph:]].*$" | grep -v '@' | sed 's/\t//g'

  #start=$(grep -Pn -m1 "^[\t]{$depth}${choice}.*$" $index | cut -d: -f1);
  #end=$(tail -n +${start%%:*} $index | grep -Pn -m1 "^[\t]{$depth}@.*$" | cut -d: -f1);
  #for (( n=start; n<$((start+end)); n++ )); do sed "${n}q;d" $index; done | grep -P "^[\t]{$depth}[[:graph:]].*$" | grep -v '@' | sed 's/\t//g'

  #read -r choice
  #(( depth++ ))
  #while [[ $(grep -Pc "^[\t]{$depth}${choice}.*$" index) -lt 1 ]]; do read -r choice; done
  #while [[ $(grep -Pc "^[\t]{$((depth+1))}${choice}.*$" index) -lt 1 ]]; do read -r choice; done; (( depth++ ))
done

exit

# __________________________________________________________________________________________

depth=-1; choice=''

while true; do
  offset=$(( depth + 1 ))
  start=$(grep -Pn -m1 "^[\t]{$offset}${choice}.*$" $index | cut -d: -f1);
  end=$(tail -n +${start%%:*} $index | grep -Pn -m1 "^[\t]{$offset}@.*$" | cut -d: -f1);
  for (( n=start; n<$((start+end)); n++ )); do sed "${n}q;d" $index; done | grep -P "^[\t]{$offset}[[:graph:]].*$" | grep -v '@' | sed 's/\t//g'

  #start=$(grep -Pn -m1 "^[\t]{$depth}${choice}.*$" $index | cut -d: -f1);
  #end=$(tail -n +${start%%:*} $index | grep -Pn -m1 "^[\t]{$depth}@.*$" | cut -d: -f1);
  #for (( n=start; n<$((start+end)); n++ )); do sed "${n}q;d" $index; done | grep -P "^[\t]{$depth}[[:graph:]].*$" | grep -v '@' | sed 's/\t//g'

  read -r choice
  #(( depth++ ))
  #while [[ $(grep -Pc "^[\t]{$depth}${choice}.*$" index) -lt 1 ]]; do read -r choice; done
  #while [[ $(grep -Pc "^[\t]{$((depth+1))}${choice}.*$" index) -lt 1 ]]; do read -r choice; done; (( depth++ ))
done

exit

# __________________________________________________________________________________________

STR=''
lines=$(cat $index | wc -l); idxs=();
idxs=($(grep -Pno '^([^\t|^@]*)' $index | cut -d: -f1)); idxs+=("$lines"); depth=1

for (( i=0; i<$(( ${#idxs[@]} - 1 )); i++ )); do depth=0;
  for (( row=${idxs[$i]}; row<${idxs[$((i+1))]}; row++ )); do line='';
    while [[ ${#line} -lt 1 ]]; do line=$(sed "${row}q;d" $index | grep -P "^[\t]{$depth}[[:graph:]].*$")
      if [[ ${#line} -gt 0 ]]; then
        if [[ "${line}" =~ "@" ]]; then
          STR+=" ) "; (( depth--));
        else
          [[ $row == ${idxs[$i]} ]] && STR+="[$(sed "${row}q;d" $index | grep -P '^([^\t|^@]*)')]" || STR+=" $(echo $line | sed 's/\t//g')"
        fi
      else
        [[ $row == ${idxs[$i]} ]] && STR+="(" || STR+="=("; (( depth++ ))
      fi
    done
  done
done

STR=$(echo "${STR}" | sed -e "s/  \+/ /g" | sed -E 's/]=/]="/g; s/\)\s\[/)" [/g; s/\)*$/)"/g')
echo "STRING: ${STR}"

eval declare -A menu=("$STR")

echo -e "\nMENU:"

for key in "${!menu[@]}"; do
  #echo -e "$key=\x22${menu[$key]}\x22"
  line=$(echo -e "${menu[$key]}" | sed -E 's/\(//;s/\)$//;s/ //')
  echo -e "  $key:"
  echo -e "    $line"
  [[ $(echo "$line" | grep -Pc '\(|\)') -gt 0 ]] && echo "    $(echo $line | cut -d= -f2- | sed -E 's/\(//;s/\)$//;s/ //') <- string split test "; echo ""
done

str="FILES=( TEXT MUSIC=( MP3 ) ) LOGS OTHER=( COMMANDS=( BACKUP ) DUMP ) )";

#for key in "${!menu[@]}"; do echo -e "$key=\x22${menu[$key]}\x22"; done
#for item in "${menu[@]}"; do echo "$item"; done
