#!/bin/bash

SCRIPT=$(readlink -f "$0"); PID=$$
DIR=$(cd "$(dirname $SCRIPT)" && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)

index="$DIR/index"

level=0; offset=1; start=0
choice='0: ';
level_index=''

declare -a last_items=()
declare -a entries=()

# ------------------------------------------------------------------------------------------------------------

clear

while true; do
  level_index=$(grep -Pn "^(\t){$level}[[:graph:]].*$" index)
  items=$(echo "$level_index" | awk -F: -v n="$start" '{if ($1 > n ) { if ( $2 ~ "@" ) { exit } else { print }}}')
  entries=()

  for n in $(seq 1 $(echo "$items" | wc -l)); do
    item=$(echo "$items" | awk -v n="$n" 'NR==n' | sed 's/\t//g;s/\(.*\)://g' | sed '/\]$/! s/$/ >/g;/\]$/ s/[][]\(.*\)//g')
    entries+=("$n" "$item")
  done

  offset=$( whiptail --title "MENU" --menu "$(echo $choice | cut -d: -f2-)" 0 0 4 "${entries[@]}" 3>&2 2>&1 1>&3 ); exit_code=$?

  [[ $exit_code -gt 0 ]] && [[ $level -lt 1 ]] && exit

  if [[ $offset -le $(echo "$items" | wc -l) ]]; then
    if [[ ${#offset} -gt 0 ]]; then
      if [[ ! $(echo "$items" | awk -v n="$offset" 'NR==n' | sed 's/\t//g') =~ .*"[".* ]]; then
        (( level++ ))
        last_items[$level]="$choice"
        choice=$(echo "$items" | awk -v n="$offset" 'NR==n' | sed 's/\t//g')
      else
        line=$(echo "$items" | awk -v n="$offset" 'NR==n' | sed 's/\t//g')
        id=$(echo "${line##*:}" | sed 's/[][]\(.*\)//g')
        cmd=$(echo "${line##*:}" | sed 's/^.*\[\(.*\)\].*$/\1/')
        echo -e "\nCOMMAND: '$id':$cmd\n"; exit
      fi
    else
      choice="${last_items[$level]}"
      (( level-- ))
    fi
    start=${choice%%:*}
  fi
done

exit

