#!/bin/bash

SCRIPT=$(readlink -f "$0"); PID=$$
DIR=$(cd "$(dirname $SCRIPT)" && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)
ASSETS="$HOMEDIR/ADMIN/MENU/.assets"

index="$ASSETS/index"

level=0; offset=1; start=0; choice='0: '; level_index=''; nav_string=''

MENU_W=$(( $(cat /sys/class/graphics/fb0/virtual_size | cut -d, -f1) / 4 ))
MENU_H=$(( $(cat /sys/class/graphics/fb0/virtual_size | cut -d, -f2) / 8 ))

declare -a entries=()
declare -a last_items=()

source "$ASSETS/helpers/commands.sh"

# ------------------------------------------------------------------------------------------------------------

Menu() {
  level_index=$(grep -v '^$\|^\s*#' $index | grep -Pn "^(\t){$level}[[:graph:]].*$")
  items=$(echo "$level_index" | awk -F: -v n="$start" '{if ($1 > n ) { if ( $2 ~ "@" ) { exit } else { print }}}')
  entries=()

  for n in $(seq 1 $(echo "$items" | wc -l)); do
    item=$(echo "$items" | awk -v n="$n" 'NR==n' | sed 's/\t//g;s/\(.*\)://g' | sed '/\]$/! s/$/ >/g;/\]$/ s/[][]\(.*\)//g')
    entries+=("$n" "$item")
  done

  offset=$( whiptail --title "MENU" --menu "$(navString)" $MENU_H $MENU_W 8 "${entries[@]}" 3>&2 2>&1 1>&3 ); exit_code=$?

  [[ $exit_code -gt 0 ]] && [[ $level -lt 1 ]] && exit

  if [[ $offset -le $(echo "$items" | wc -l) ]]; then
    if [[ ${#offset} -gt 0 ]]; then
      if [[ ! $(echo "$items" | awk -v n="$offset" 'NR==n' | sed 's/\t//g') =~ .*"[".* ]]; then
        (( level++ ))
        last_items[$level]="$choice"; choice=$(echo "$items" | awk -v n="$offset" 'NR==n' | sed 's/\t//g')
      else
        line=$(echo "$items" | awk -v n="$offset" 'NR==n' | sed 's/\t//g'); id=$(echo "${line##*:}" | sed 's/[][]\(.*\)//g')
        cmd=$(echo "${line##*:}" | sed 's/^.*\[\(.*\)\].*$/\1/;s/\x27//g')
        runCmd "$cmd"
      fi
    else
      choice="${last_items[$level]}"
      unset last_items[$level]
      (( level-- ))
    fi
    start=${choice%%:*}
  fi
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

runCmd() {
  local CMD="$@"
  [ ${#CMD} -lt 1 ] && return
  [ ! -z $CMD ] || [[ "${commands[@]}" =~ "$CMD" ]] && $cmd
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

navString() {
 nav_string='MENU '

 if [[ $level -gt 0 ]]; then
   nav_string+="> "
   for i in "${last_items[@]:2}"; do nav_string+="$( echo "${i##*:}" | sed 's/ //g') > "; done
   nav_string+="${choice##*:}"
 fi
 echo "$nav_string"
}


# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

clear
while true; do Menu; done

exit
















# ------------------------------------------------------------------------------------------------------------

clear

while true; do
  level_index=$(grep -Pn "^(\t){$level}[[:graph:]].*$" $index)
  items=$(echo "$level_index" | awk -F: -v n="$start" '{if ($1 > n ) { if ( $2 ~ "@" ) { exit } else { print }}}')
  entries=()

  for n in $(seq 1 $(echo "$items" | wc -l)); do
    item=$(echo "$items" | awk -v n="$n" 'NR==n' | sed 's/\t//g;s/\(.*\)://g' | sed '/\]$/! s/$/ >/g;/\]$/ s/[][]\(.*\)//g')
    entries+=("$n" "$item")
  done

  offset=$( whiptail --title "MENU" --menu "$(echo $choice | cut -d: -f2-)" 0 0 4 "${entries[@]}" 3>&2 2>&1 1>&3 ); exit_code=$?

  [[ $exit_code -gt 0 ]] && [[ $level -lt 1 ]] && exit

  if [[ $offset -le $(echo "$items" | wc -l) ]]; then
    if [[ ${#offset} -gt 0 ]]; then
      if [[ ! $(echo "$items" | awk -v n="$offset" 'NR==n' | sed 's/\t//g') =~ .*"[".* ]]; then
        (( level++ ))
        last_items[$level]="$choice"
        choice=$(echo "$items" | awk -v n="$offset" 'NR==n' | sed 's/\t//g')
      else
        line=$(echo "$items" | awk -v n="$offset" 'NR==n' | sed 's/\t//g')
        id=$(echo "${line##*:}" | sed 's/[][]\(.*\)//g')
        cmd=$(echo "${line##*:}" | sed 's/^.*\[\(.*\)\].*$/\1/')
        echo -e "\nCOMMAND: '$id':$cmd\n"; exit
      fi
    else
      choice="${last_items[$level]}"
      (( level-- ))
    fi
    start=${choice%%:*}
  fi
done

exit

