#!/bin/bash

ARG="$@"; PS1_STORED=$PS1

UNMARK="$(echo -e "\e[0m")"
  MARK="$(echo -e "\e[7m")"
    NC="$(echo -e "\033[0m")"
     C="$(echo -e "\033[32m")"

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# PATHS

SCRIPT=$(readlink -f "$0"); PID=$$
DIR=$(cd "$(dirname $SCRIPT)" && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)

serial_path='/tmp/serial.fifo'
roms_path=$(grep -w -m1 'dir_roms' "$HOMEDIR/ADMIN/.sys/.settings" | cut -d\' -f2)
assets_path="$DIR/.assets"
media_path="$assets_path/media"
list_path="$assets_path/list"
cafca_cfg_path=''

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# VARIABLES / CONSTS

timer=0; idle_state=0; init=1; t_elapsed=0
timers=()

#declare #MYVAR='42'
#echo "MYVAR: $MYVAR"

#source "$assets_path/saver/saver.sh"
#source "$assets_path/helpers/page_editor.sh"

#________________________________________________________________________________________________________________________________________________
#
# FUNCTIONS

Main() {
  #Init
  loadSettings
  #declare -ag timers=( "$t_title" "$t_marquee" "$t_fbsaver" "$t_vidsaver" "$t_sleep" ); echo -e "timers: ${timers[@]}\n"
  declare -ag timers=( 2 5 10 20 60 ); echo -e "timers: ${timers[@]}\n"

  trap '[[ $? -eq 42 ]] && exitFunc 42 || exitFunc 0' EXIT; trap 'exit 1' INT HUP SIGINT SIGHUP TERM

  sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --mode menu; sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --grab joystick

  elapsed 0

  while true; do
    input=$(readInput)

    if [[ ${#input} -gt 0 ]]; then
      echo "$SECONDS"
      elapsed 0; idle_state=0
      #fbSaver 0 &>/dev/null
      #sudo setterm --blank poke --term linux
    else
      if [[ $(elapsed) -ge ${timers[$idle_state]} ]]; then
        echo -e "STATE: $idle_state, LIMIT: ${timers[$idle_state]}\nT: $(elapsed)\n"
	#case $idle_state in 0) sleep 0.1 ;; 1) sleep 0.1  ;; 2) sleep 0.1 ;; 3) sleep 0.1 ;; 4) sleep 0.1 ;; *) ;; esac
        [[ $idle_state -lt ${#timers[@]} ]] && (( idle_state++ ));
      fi
    fi
  done
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

elapsed() {
  [ $# -gt 0 ] && timer=$SECONDS || echo "$(( $SECONDS - $timer ))"
  #[ $# -gt 0 ] && timer=$(echo $(( 10#$(date +%s) ))) || echo "$(( $(echo $(( 10#$(date +%s) ))) - $timer ))"
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


fbSaver() {
  local action=${1:-0}
  local redraw=0

  if [[ $action -gt 0 ]]; then
    [ ! -f "$assets_path/fb0.dump" ] && { sudo cat /dev/fb0 > "$assets_path/fb0.dump" & wait $!; } || { sudo cat "$assets_path/fb0.dump" > /dev/fb0 & wait $!; }
    Saver >/dev/null 2>&1 & SAVER_PID=$!
  else
    [[ $SAVER_PID -gt 0 ]] && { sudo kill -9 $SAVER_PID 2>/dev/null; wait $SAVER_PID; SAVER_PID=0; redraw=1; } || { \
    [[ $show_marquee -gt 0 ]] && [ -f "$assets_path/fb0.dump" ] && redraw=1; }
    [[ $redraw -gt 0 ]] && { sudo cat "$assets_path/fb0.dump" > /dev/fb0; sudo rm "$assets_path/fb0.dump"; init=0; makeList; }
  fi
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

asleep() {
  echo -e "ASLEEP 1" > /tmp/serial.fifo
  while read line; do break; done< <(thd --dump /dev/input/event* | grep -v --line-buffered '^#' |& awk -W interactive '{$1=$1;print $NF}' | grep --line-buffered -vw '/dev/input/event1')
  echo -e "ASLEEP 0" > /tmp/serial.fifo
  sudo setterm --blank poke --term linux
}

#____________________________________________________________________________

readInput() {
    Event=''
    read -rs -N 1 -t 0.1 Event1 >/dev/null
    [[ $? -gt 127 ]] && return

    case "$Event1" in
      $'\163')	        Event="S"	;;
      $'\n')            Event="ENTER"   ;;
      ' ')              Event="SPACE"   ;;
      [[:blank:]])      Event="TAB"     ;;
      *)
        read -t 0.01 -rsn5 Event2
        case "$Event2" in
          "[A")         Event="UP"      ;;
          "[B")         Event="DOWN"    ;;
          "[D")         Event="LEFT"    ;;
          "[C")         Event="RIGHT"   ;;
          "[5~")        Event="PGUP"    ;;
          "[6~")        Event="PGDOWN"  ;;
          "OS"|"[[D")   Event="F4"      ;;
          *)
            case "$Event1$Event2" in
              $'\E')    Event="ESC"     ;;
            esac
            ;;
        esac
    esac
    echo -e "${Event}"
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

sendSerial() {
  [ $# -ge 1 ] && echo -e "$@" > /tmp/serial.fifo || return
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

loadSettings() {
  while read line; do
    key=$(echo "$line" | cut -d= -f1)
    val=$(echo "$line" | cut -d= -f2- | sed "s/'//g")
    declare -g "${key}"="$val"; #echo "$key = $val"
  done< <(cat "$assets_path/.settings" | sed -n '/# GAMES/,/# EOF_GAMES/p' | sed '/^page.*$/d;/path$/d;s/#.*$//;/^\s*$/d')
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

Init() {
  declare -ag timers=( "$t_title" "$t_marquee" "$t_fbsaver" "$t_vidsaver" "$t_sleep" )

  trap '[[ $? -eq 42 ]] && exitFunc 42 || exitFunc 0' EXIT; trap 'exit 1' INT HUP SIGINT SIGHUP TERM

  sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --mode menu; sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --grab joystick

  #timer=$(echo $(( 10#$(date +%s) ))) # should be redundant if calling 'elapsed 0'
  elapsed 0
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

exitFunc() {
  local signal=$1

  JOBS=($(jobs -p))
  [[ ${#JOBS[@]} -gt 0 ]] && sudo kill -9 "${JOBS[@]}" &> /dev/null

  if [[ $signal -ne 42 ]]; then
    #echo "VFD 4  G O O D B Y E" > /tmp/serial.fifo
    sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --remove joystick
  fi

  exit $signal
}

#____________________________________________________________________________

# MAIN LOOP

#[[ $screensaver -eq 1 ]] && source "$assets_path/saver/saver.sh"
#[[ $edit_mode -eq 1 ]] && source "$assets_path/helpers/page_editor.sh"

Main
exit

#____________________________________________________________________________


# NEW TIMER METHOD:
while true; do
  input=''
  while [[ ${#input} -lt 1 ]]; do
    echo "$(( $SECONDS - $T ))"
    read -srn1 -t 1 input
    [[ $(( $SECONDS - $T )) -ge 5 ]] && { echo "LIMIT"; break; }
  done
  read -sr -t 0.2 void
  T=$SECONDS
done
exit

