#!/bin/bash

path="/home/pi/ADMIN/SERIAL"
cafca_path="/home/pi/CAFCA4"
loaded_path="$cafca_path/assets/serial/VAR/GAME_LOADED"
stopped_path="$cafca_path/assets/serial/VAR/GAME_STOPPED"

cat /sys/firmware/devicetree/base/model | sudo tee $path/DATA/MODEL &>/dev/null
cat /proc/version | cut -c -26 | sudo tee $path/DATA/VERSION &>/dev/null
date | awk '{print $2 " " $3 " " $6}' | sudo tee $path/DATA/DATE &>/dev/null
date | awk '{print $4}' | sudo tee $path/DATA/TIME &>/dev/null
hostname -I | awk '{print $1}' | sudo tee $path/DATA/IP &>/dev/null
uptime | awk '{print $3}' | tr , " " | tr : h | awk '{print substr($0, 1, length($0))"m"}' | sudo tee $path/DATA/UPTIME &>/dev/null
vcgencmd measure_temp |  awk '{print substr($0, 6, length($0))}' | sudo tee $path/DATA/GPU_TEMP &>/dev/null

cputmpraw=$(cat /sys/class/thermal/thermal_zone0/temp)
cputmp=$((cputmpraw/1000))
echo $cputmp | sudo tee $path/DATA/CPU_TEMP &>/dev/null

vcgencmd get_mem arm |  awk '{print substr($0, 5, length($0))}' | sudo tee $path/DATA/MEM_ARM &>/dev/null
vcgencmd get_config int | sed 's/prefix_//g; s/ /\n/g' | sudo tee $path/DATA/CONFIG &>/dev/null

cat /proc/meminfo | awk 'NR==2 {print $2 "/"}' | sudo tee $path/DATA/TMP &>/dev/null
cat /proc/meminfo | awk 'NR==1 {print $2}' | sudo tee -a $path/DATA/TMP &>/dev/null
sleep 1
sed 'N;s/\n/ /' $path/DATA/TMP | sed 's/ //g' | awk '{print $0 " kb"}' | sudo tee $path/DATA/FREEMEM &>/dev/null

sudo df -h | awk 'NR==2 {print $5}' | sudo tee $path/DATA/DISKUSED &>/dev/null
tvservice -s |  awk '{print substr($0, 15, length($0))}' | sed 's/\[//g' | sed 's/\]//g' | sed 's/,//g' | sudo tee $path/DATA/TVMODE &>/dev/null
fbset -s | awk 'NR==2 {print $2}' | sed 's/\"//g' | sudo tee $path/DATA/FBRES &>/dev/null
sleep 0.1

arduino_online=$(ls /dev | grep -c ttyACM0)

model=$(cat $path/DATA/MODEL | tr -d '\0')
version=$(cat $path/DATA/VERSION)
date=$(cat $path/DATA/DATE)
clock=$(cat $path/DATA/TIME)
ip=$(cat $path/DATA/IP)
uptime=$(cat $path/DATA/UPTIME | sed 's/ //g')
gpu_temp=$(cat $path/DATA/GPU_TEMP)
cpu_temp=$(cat $path/DATA/CPU_TEMP | awk '{print $0 ".0\x27C"}')
mem_arm=$(cat $path/DATA/MEM_ARM)
freemem=$(cat $path/DATA/FREEMEM)
diskused=$(cat $path/DATA/DISKUSED)
tvmode=$(cat $path/DATA/TVMODE)
fbres=$(cat $path/DATA/FBRES)

    if (( $arduino_online )); then
      echo "FOUND ARDUINO"
    fi
    serKeys=('MODEL' 'VERSION' 'DATE' 'TIME' 'IP' 'UPTIME' 'GPU_TEMP' 'CPU_TEMP' 'MEM_ARM' 'FREEMEM' 'DISKUSED' 'TVMODE' 'FBRES')
    serDatas=("$model" "$version" "$date" "$clock" "$ip" "$uptime" "$gpu_temp" "$cpu_temp" "$mem_arm" "$freemem" "$diskused" "$tvmode" "$fbres")

    for ((idx=0; idx<${#serKeys[@]}; ++idx)); do
       thisVal=${serDatas[idx]}
       thisKey=${serKeys[idx]}
       sleep 0.1

       if (( $arduino_online )); then
         loaded=$(cat $loaded_path | awk '{print $2}')
         stopped=$(cat $stopped_path | awk '{print $2}')

         if [[ "$stopped" -eq "1" || "$loaded" -eq "0" ]]; then
            if [[ "$thisVal" ]]; then
              sudo python3 $path/SERIAL.py "SYS $thisKey $thisVal"
            else
              sudo python3 $path/SERIAL.py "SYS $thisKey null"
            fi
	 fi

         sleep 5

       #if (( $idx > 3 )); then
       #  echo "GAME_LOADED 1" | sudo tee $loaded_path #&>/dev/null
       #  echo "GAME_STOPPED 0" | sudo tee $stopped_path #&>/dev/null
       #fi

       else
         echo "$thisKey $thisVal"
       fi
   done
       if (( $arduino_online )); then
          sudo python3 $path/SERIAL.py "SYS PLAYER READY"
       fi
   exit
