#!/bin/bash

SCRIPT=$(readlink -f "$0")
DIR=$(cd "$(dirname $SCRIPT)" && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)

# -----------------------------------------

run_games_menu() {
  sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --remove joystick; sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --mode menu
  sudo bash "$HOMEDIR/ADMIN/MENU/GAMES.sh"
  sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --grab joystick; sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --mode admin
}

set_menu_settings() {
  local path="$assets_path/.settings"
  declare -a options=()
  declare -au types=($(grep -Po "[[:blank:]]#.*$" "$assets_path/.settings" | sed -E 's/[\(\s#\s\)]*\s//g; s/opt_//g' | sort -u))

  for type in ${types[@]}; do options+=("$type" "" "$([[ $type == BOOL ]] && echo ON || echo OFF)"); done;
  type=$(whiptail --radiolist "Select type:" 0 0 0 "${options[@]}" 2>&1 1>&3 3>&2)

  options=()
  while read line; do
    local string=$(echo "$line" | cut -d# -f1 | sed 's/ $//g')
    local type=$(echo "$line" | awk -F'#\ ' '{$1="";print}' | sed 's/ //g')
    local key="${string%%=*}"; local val="${string##*=}"
    [[ "${type^^}" =~ OPT_BOOL ]] && { [[ $val -gt 0 ]] && options+=("$key" "" ON) || options+=("$key" "" OFF); }
  done< <(cat "$path" | sed 's/^start_page=.*$//g' | sed 's/^pages=/start_page=/g' | sed '/^#/d;/^\s*$/d')

  [[ ${#options[@]} -lt 1 ]] && return 1

  settings=$( whiptail --title "SETTINGS" --checklist "SET BOOLS" 0 0 4 "${options[@]}" 2>&1 1>&3 3>&2 )

  if [ $? -eq 0 ]; then
    sudo cp -f "$assets_path/.settings" "$assets_path/.settings.bak"

    for (( i=0; i<${#options[@]}; i+=3 )); do
      [[ "${settings//\"/}" =~  "${options[$i]}" ]] && state=1 || state=0; sudo sed -i "/${options[$i]}/ s/${options[$i]}[=][[:digit:]]/${options[$i]}=$state/" "$path"
    done
  fi
}

set_games_menu() { clear; echo " G A M E S   M E N U  "; sleep 2; }
set_games_list() { clear; echo " G A M E S   L I S T  "; sleep 2; }
set_games_remap() { clear; echo " G A M E S   R E M A P  "; sleep 2; }
set_cafca_settings() { clear; echo " C A F C A   S E T T I N G S  "; sleep 2; }
set_cafca_table() { clear; echo " C A F C A   T A B L E  "; sleep 2; }
set_cafca_timers() { clear; echo " C A F C A   T I M E R S  "; sleep 2; }
set_cafca_clearram() { clear; echo " C A F C A   C L E A R R A M  "; sleep 2; }
set_system_settings() { clear; echo " S Y S T E M   S E T T I N G S  "; sleep 2; }
cmd_all_commands() { clear; echo " A L L   C O M M A N D S  "; sleep 2; }
cmd_backup() { clear; echo " B A C K U P  "; sleep 2; }
cmd_sleep() { clear; echo " S L E E P  "; sleep 2; }
cmd_reboot() { clear; echo " R E B O O T  "; sleep 2; }
cmd_shutdown() { clear; echo " S H U T D O W N  "; sleep 2; }

declare -ag commands=($(typeset -F | cut -d' ' -f3-))

# ---------------------------------------------------------------------------------------------------------------

helper() {
 declare -g assets_path="$HOMEDIR/ADMIN/MENU/.assets"
 export NEWT_COLORS="$(cat $assets_path/config/whiptail_theme.cfg)"
}

# ---------------------------------------------------------------------------------------------------------------

if [[ "${BASH_SOURCE[0]}" == "${0}" ]]; then
  helper
  clear
  echo "commands(${#commands[@]}):"; echo "$(for cmd in ${commands[@]}; do echo $cmd; done)"; echo ""
  (( ! $# )) && { read -p "type function name: " name; } || { name="$1"; }

  if [ ! -z $name ] && [[ "${commands[@]}" =~ "$name" ]]; then
    echo "calling $name()"; sleep 1; $name 2>&1
  fi
fi

# ---------------------------------------------------------------------------------------------------------------




set_menu_settings_bak() {
  local path="$assets_path/.settings"
  declare -a options=()

  while read line; do
    local string=$(echo "$line" | cut -d# -f1 | sed 's/ $//g')
    local type=$(echo "$line" | awk -F'#\ ' '{$1="";print}' | sed 's/ //g')
    local key="${string%%=*}"; local val="${string##*=}"
    [[ "${type^^}" =~ OPT_BOOL ]] && { [[ $val -gt 0 ]] && options+=("$key" "" ON) || options+=("$key" "" OFF); }
  done< <(cat "$path" | sed 's/^start_page=.*$//g' | sed 's/^pages=/start_page=/g' | sed '/^#/d;/^\s*$/d')

  [[ ${#options[@]} -lt 1 ]] && return 1

  settings=$( whiptail --title "SETTINGS" --checklist "SET BOOLS" 0 0 4 "${options[@]}" 2>&1 1>&3 3>&2 )

  if [ $? -eq 0 ]; then
    sudo cp -f "$assets_path/.settings" "$assets_path/.settings.bak"

    for (( i=0; i<${#options[@]}; i+=3 )); do
      [[ "${settings//\"/}" =~  "${options[$i]}" ]] && state=1 || state=0; sudo sed -i "/${options[$i]}/ s/${options[$i]}[=][[:digit:]]/${options[$i]}=$state/" "$path"
    done
  fi
}

#func1() { echo "FUNC1"; }
#func2() { echo "FUNC2"; }
#func3() { echo "FUNC3"; }
#list() { for i in "${ARR[@]}"; do echo "$i"; done; }

#declare -ag commands=($(typeset -F | cut -d' ' -f3-))
#
#if [[ "${BASH_SOURCE[0]}" == "${0}" ]]; then
#  clear
#  echo "commands(${#commands[@]}):"; echo "$(for cmd in ${commands[@]}; do echo $cmd; done)"; echo ""
#  (( ! $# )) && { read -p "type function name: " name; } || { name="$1"; }
#
#  if ( [ ! -z $name ] && [[ $(type -t $name) == function ]] ) || [[ "${commands[@]}" =~ "$name" ]]; then
#    #echo -n "calling $name()"; sleep 1; for i in {1..3}; do echo -n "."; sleep 0.5; done; echo -e "\n"; sleep 1
#    echo "calling $name()"; sleep 1
#    $name 2>&1
#  fi
#fi
