#!/bin/bash

SCRIPT=$(readlink -f "$0"); PID=$$
DIR=$(cd "$(dirname $SCRIPT)" && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)
assets_path="$DIR/.assets"

adminMenu() {
  export NEWT_COLORS="$(cat $assets_path/config/whiptail_theme.cfg)"
  whiptail --title "$(date +%T)" --msgbox "ADMIN MENU" 0 0 0 2>&1 1>/dev/tty
  whiptail --title "$(date +%T)" --yesno "\nQuit Menu?" 10 17 2>&1 1>/dev/tty
  [[ $? -gt 0 ]] && adminMenu || exit
}


options=()

games_getSettings() {
  declare -a options=()
  while read line; do
    local string=$(echo "$line" | cut -d# -f1 | sed 's/ $//g')
    local type=$(echo "$line" | awk -F'#\ ' '{$1="";print}' | sed 's/ //g')
    local key="${string%%=*}"; local val="${string##*=}"
    [[ "${type^^}" =~ $1 ]] && { [[ $val -gt 0 ]] && options+=("$key" "" ON) || options+=("$key" "" OFF); }
  done< <(cat "$assets_path/.settings" | sed 's/^start_page=.*$//g' | sed 's/^pages=/start_page=/g' | sed '/^#/d;/^\s*$/d')

  [[ ${#options[@]} -gt 0 ]] && { SetOptions "$assets_path/.settings"; return $?; } || return 1
}

admin_getSettings() {
  options=()
  while read line; do
    local string=$(echo "$line" | cut -d' ' -f2-)
    local type=$(echo "$line" | cut -d' ' -f1)
    local key="${string%%=*}"; local val="${string##*=}"
    [[ "${type^^}" =~ $1 ]] && { [[ $val -gt 0 ]] && options+=("$key" "" ON) || options+=("$key" "" OFF); }
  done< <(cat "$HOMEDIR/ADMIN/.sys/.settings" | sed '/^#/d;/^\s*$/d')

  [[ ${#options[@]} -gt 0 ]] && { SetOptions "$HOMEDIR/ADMIN/.sys/.settings"; return $?; } || return 1
}

SetOptions() {
  local path="${1}"
  export NEWT_COLORS="$(cat $assets_path/config/whiptail_theme.cfg)"
  settings=$( whiptail --title "SETTINGS" --checklist "SET BOOLS" 0 0 4 "${options[@]}" 3>&2 2>&1 1>&3 )

  if [ $? -eq 0 ]; then
    settings=$(echo "$settings" | sed 's/\x22//g')
    for (( i=0; i<${#options[@]}; i+=3 )); do
      #sed -i "/^${options[$i]}/ s/^${options[$i]}[=][[:digit:]]/${options[$i]}=$(( ($settings == ${options[$i]})?1:0 ))/" "$assets_path/settings"
      [[ "$settings" =~ "${options[$i]}" ]] && state=1 || state=0; sudo sed -i "/${options[$i]}/ s/${options[$i]}[=][[:digit:]]/${options[$i]}=$state/" "$path" &>/dev/null
    done
    return 0
  else
   return 1
  fi
}



GetOptions() {
  export NEWT_COLORS="$(cat $assets_path/config/whiptail_theme.cfg)"

  local path="$assets_path/.settings"
  declare -a options=()

  while read line; do
    local string=$(echo "$line" | cut -d# -f1 | sed 's/ $//g')
    local type=$(echo "$line" | awk -F'#\ ' '{$1="";print}' | sed 's/ //g')
    local key="${string%%=*}"; local val="${string##*=}"
    [[ "${type^^}" =~ BOOL ]] && { [[ $val -gt 0 ]] && options+=("$key" "" ON) || options+=("$key" "" OFF); }
  done< <(cat "$path" | sed 's/^start_page=.*$//g' | sed 's/^pages=/start_page=/g' | sed '/^#/d;/^\s*$/d')

  [[ ${#options[@]} -lt 1 ]] && return 1

  settings=$( whiptail --title "SETTINGS" --checklist "SET BOOLS" 0 0 4 "${options[@]}" 3>&2 2>&1 1>&3 )

  if [ $? -eq 0 ]; then
    settings=$(echo "$settings" | sed 's/\x22//g')
    for (( i=0; i<${#options[@]}; i+=3 )); do
      [[ "$settings" =~ "${options[$i]}" ]] && state=1 || state=0; sudo sed -i "/${options[$i]}/ s/${options[$i]}[=][[:digit:]]/${options[$i]}=$state/" "$path" &>/dev/null
    done
  fi
}

exitFunc() {
  sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --mode term
  exit
}

trap 'exitFunc' EXIT INT SIGINT

rc=0

sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --mode admin; sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --grab joystick
clear

while [[ $rc -lt 1 ]]; do
  GetOptions
  #games_getSettings BOOL; rc=$?
  #admin_getSettings OPT; rc=$?
done

exit

#if [[ "${BASH_SOURCE[0]}" == "${0}" ]]; then
#  clear
#  getSettings
#  [[ ${#options[@]} -gt 0 ]] && Menu
#else
#  adminMenu
#fi
