#!/bin/bash

SCRIPT=$(readlink -f "$0"); PID=$$
DIR=$(cd "$(dirname $SCRIPT)" && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)
assets_path="$HOMEDIR/ADMIN/MENU/.assets"

sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --grab joystick; sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --mode admin
export NEWT_COLORS="$(cat $assets_path/config/whiptail_theme.cfg)"
[[ $TERM == linux ]] && echo -en "\e]P7C0C0C0" # start

trap '[[ $TERM == linux ]] && echo -en "\e]P700FC00"' EXIT INT SIGINT HUP

type='BOOL'

set_menu_settings() {
  local path="$assets_path/.settings"
  declare -a options=()
  declare -au types=($(grep -Po "[[:blank:]]#.*$" "$assets_path/.settings" | sed -E 's/[\(\s#\s\)]*\s//g; s/opt_//g' | sort -u))
  declare -A items=()

  for t in ${types[@]}; do options+=("$t" "" "$([[ $t == $type ]] && echo ON || echo OFF)"); done;
  type=$(whiptail --radiolist "Select type:" 0 0 0 "${options[@]}" 2>&1 1>&3 3>&2)

  [ $? -gt 0 ] && exit

  while read line; do
    match=$(echo $line | grep -Po "[[:blank:]]#.*$" | sed -E 's/[\(\s#\s\)]*\s//g; s/opt_//g')
    [[ "${match^^}" == "$type" ]] && { item=$(echo "$line" | sed 's/[[:blank:]]#.*$//g'); items["${item%%=*}"]="${item##*=}"; } #; echo "${item%%=*}=${items[${item%%=*}]}"; }
  done< <(sed -n '/# GLOBAL\|# GAMES/,/# EOF_GLOBAL\|# EOF_GAMES/ { s/^#.*$//; /^\s*$/d; p }' "$assets_path/.settings")
  options=(); mode=''

  for key in "${!items[@]}"; do
    case "${type}" in
      'BOOL') echo "BOOL ${items[$key]}"; [[ ${items[$key]} -eq 1 ]] && options+=("$key" "" ON) || options+=("$key" "" OFF); mode='checklist' ;;
      'INT')  options+=("$key" "${items[$key]}"); mode='menu' ;;
      *) ;;
    esac
  done

  [[ ${#mode} -lt 1 ]] || [[ ${#options[@]} -lt 1 ]] && return

  settings=$(whiptail --title "SETTINGS" --$mode "SET BOOLS" 0 0 4 "${options[@]}"  2>&1 1>&3 3>&2)

  if [ $? -eq 0 ]; then
    sudo cp -f "$assets_path/.settings" "$assets_path/.settings.bak"

    case "${type}" in
      'BOOL')
        for key in "${!items[@]}"; do
          [[ "${settings//\"/}" =~ "$key" ]] && state=1 || state=0; sudo sed -i "/$key/ s/$key[=][[:digit:]]/$key=$state/" "$path" #; echo "bool $key = $state"
    	done
    	;;
      'INT')
        init_val="${items[${settings}]}";
	new_val=$(dialog --rangebox "range" 20 40 0 1024 $init_val --input-fd 6 6<$(tty) 2>&1 1>&3 3>&2 )
        #echo "new_val: '${new_val//[[:blank:]]/}'"; read -srn1 void
        sudo sed -i "/$settings/ s/$settings[=][[:digit:]]\+/$settings=${new_val// /}/" "$path"
	;;
      *)
	;;
    esac
  else
    exit
  fi
}


while true; do
  set_menu_settings 3>&1 1>&2 2>logfile
done

exit

declare -au types=($(grep -Po "[[:blank:]]#.*$" ~/ADMIN/MENU/.assets/.settings | sed -E 's/[\(\s#\s\)]*\s//g; s/opt_//g' | sort -u))
items=(); for type in ${types[@]}; do items+=("$type" "" "$([[ $type == BOOL ]] && echo ON || echo OFF)"); done;
selectType() { choice=$(whiptail --radiolist "hello" 0 0 0 "${items[@]}" 2>&1 1>&3 3>&2); }


#get_opts=$(sed -n '/# GLOBAL\|# GAMES/,/# EOF_GLOBAL\|# EOF_GAMES/ { s/^#.*$//; /^\s*$/d; p }' "$assets_path/.settings")

while read line; do
  type=$(echo $line | grep -Po "[[:blank:]]#.*$" | sed -E 's/[\(\s#\s\)]*\s//g; s/opt_//g')
  [[ "${type^^}" == "$string" ]] && echo $line
done< <(sed -n '/# GLOBAL\|# GAMES/,/# EOF_GLOBAL\|# EOF_GAMES/ { s/^#.*$//; /^\s*$/d; p }' "$assets_path/.settings")


set_menu_settings() {
  local path="$assets_path/.settings"
  declare -a options=()
  declare -au types=($(grep -Po "[[:blank:]]#.*$" "$assets_path/.settings" | sed -E 's/[\(\s#\s\)]*\s//g; s/opt_//g' | sort -u))

  for type in ${types[@]}; do options+=("$type" "" "$([[ $type == BOOL ]] && echo ON || echo OFF)"); done;
  type=$(whiptail --radiolist "Select type:" 0 0 0 "${options[@]}" 2>&1 1>&3 3>&2)

  options=()
  while read line; do
    local string=$(echo "$line" | cut -d# -f1 | sed 's/ $//g')
    local type=$(echo "$line" | awk -F'#\ ' '{$1="";print}' | sed 's/ //g')
    local key="${string%%=*}"; local val="${string##*=}"
    [[ "${type^^}" =~ OPT_BOOL ]] && { [[ $val -gt 0 ]] && options+=("$key" "" ON) || options+=("$key" "" OFF); }
  done< <(cat "$path" | sed 's/^start_page=.*$//g' | sed 's/^pages=/start_page=/g' | sed '/^#/d;/^\s*$/d')

  [[ ${#options[@]} -lt 1 ]] && return 1

  settings=$( whiptail --title "SETTINGS" --checklist "SET BOOLS" 0 0 4 "${options[@]}" 2>&1 1>&3 3>&2 )

  if [ $? -eq 0 ]; then
    sudo cp -f "$assets_path/.settings" "$assets_path/.settings.bak"

    for (( i=0; i<${#options[@]}; i+=3 )); do
      [[ "${settings//\"/}" =~  "${options[$i]}" ]] && state=1 || state=0; sudo sed -i "/${options[$i]}/ s/${options[$i]}[=][[:digit:]]/${options[$i]}=$state/" "$path"
    done
  fi
}

