#!/usr/bin/env python3 -*- coding: utf-8

import serial
import os
import sys
from time import sleep
from datetime import datetime

#__________________________________________________
#
# SETUP:


serial_port = "/dev/ttyACM0"
fifo_path = "/tmp/pyserial.fifo"
fifo = ''
log_dir = os.path.splitext('/home/pi/ADMIN/.log')[0]
log_file = os.path.splitext(log_dir + '/serialpy.log')[0]
writeable = True
hide = " >/dev/null 2>&1"

#--------------------------------------------------


# FUNCTIONS:

def loop():
    #write_log()
    mystr = f'{datetime.today():%Y-%m-%d}'
    print(mystr)
    sleep(5)
    #write_log('SETUP',mystr)


def write_log(src = ' ', msg = ' '):
    #now = datetime.now().__str__()
    #now = datetime.now()
    #output = str(now,src,msg)
    timestr = f'{datetime.today():%Y-%m-%d}'
    output = "[" + timestr + "] " + src + ": " + msg
    #print(output)
    if writeable:
        os.system('echo ' + output + ' | sudo tee -a ' + log_file + hide)

#__________________________________________________


loop()
while True:
    loop()

