#!/bin/bash

SCRIPT=$(readlink -f "$0")
DIR=$(cd "$(dirname $SCRIPT)" && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)

# ---------------------------------------------------------------------------------------------------------------

run_games_menu() {
  sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --remove joystick; sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --mode menu
  sudo bash "$HOMEDIR/ADMIN/MENU/GAMES.sh"
  sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --grab joystick; sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --mode admin
}

# ---------------------------------------------------------------------------------------------------------------

set_settings() {
  [ $# -lt 1 ] && { echo "no args provided.."; return; }

  local match=''; local item=''; local mode=''
  local name="${1:-placeholder}"
  [[ "${name^^}" == @(GAMES|MAIN) ]] && local path="$assets_path/.settings" || { \
  [[ "${name^^}" == SYSTEM ]] && local path="$HOMEDIR/ADMIN/.sys/.settings" || return; }

  local lines=$([[ "${name^^}" == @(GAMES|MAIN) ]] && sed -n "/# GLOBAL\|# ${name^^}/,/# EOF_GLOBAL\|# EOF_${name^^}/ { s/^#.*$//; /^\s*$/d; p }" $path || { [[ "${name^^}" == SYSTEM ]] && while read line; do type=${line%[[:blank:]]*}; val=${line#*[[:blank:]]}; [[ $type == VAR ]] && { [[ ${line##*=} =~ ^[0-9]+$ ]] && type='INT_VAR' || type='STR_VAR'; }; echo "$type $val"; done< <(cat "$path" | sed 's/#.*$//;/^\s*$/d' | sed '/^\(DEV\|PAT\).*$/ s/^/STR_/g; s/OPT/BOOL_OPT/g') | grep -Po '^[[:alpha:]]+_.*$'; })
  declare -au types=($([[ "${name^^}" == @(GAMES|MAIN) ]] && echo "$lines" | grep -Po "[[:blank:]]#.*$" | sed -E 's/[\(\s#\s\)]*\s//g; s/opt_//g' | sort -u || { [[ "${name^^}" == SYSTEM ]] && echo "$lines" | grep -Po "^[[:alpha:]]+" | sort -u; }))
  declare -a options=(); declare -A items=()

  for t in ${types[@]}; do options+=("$t" "" "$([[ $t == $data_type ]] && echo ON || echo OFF)"); done;
  declare -g data_type=$(whiptail --title "SYSTEM SETTINGS" --radiolist "$(echo -e "\nSelect type:")" 0 0 4 "${options[@]}" 2>&1 1>&3 3>&2); [ $? -gt 0 ] && return

  while read line; do
    if [[ "${name^^}" == @(GAMES|MAIN) ]]; then
      match=$(echo "$line" | grep -Po "[[:blank:]]#.*$" | sed -E 's/[\(\s#\s\)]*\s//g; s/opt_//g')
      [[ "${match^^}" == "$data_type" ]] && { item=$(echo "$line" | sed 's/[[:blank:]]#.*$//g'); items["${item%%=*}"]="${item##*=}"; }
    elif [[ "${name^^}" == SYSTEM ]]; then
      [[ "${line%%_*}" == "$data_type" ]] && { item="${line##* }"; items["${item%%=*}"]="${item##*=}"; }
    fi
  done< <(echo "$lines"); options=(); mode=''

  for key in $(echo "${!items[@]}" | tr " " "\n" | sort); do
    if [[ "$data_type" == BOOL ]]; then
      [[ ${items[$key]} -eq 1 ]] && options+=("$key" "" ON) || options+=("$key" "" OFF); mode='checklist'
    elif [[ "$data_type" == INT ]]; then
      options+=("$key" "${items[$key]}"); mode='menu'
    fi
  done

  [[ ${#mode} -lt 1 ]] || [[ ${#options[@]} -lt 1 ]] && return

  settings=$(whiptail --title "SETTINGS" --$mode "$(echo -e "\nSET $data_type")" 0 0 4 "${options[@]}"  2>&1 1>&3 3>&2)

  if [ $? -eq 0 ]; then
    sudo cp -f "$path" "$path.bak"

    case "${data_type}" in
      'BOOL')
        for key in "${!items[@]}"; do
          [[ "${settings//\"/}" =~ "$key" ]] && state=1 || state=0;
          [[ "${name^^}" == @(GAMES|MAIN) ]] && sudo sed -i "/^$key=/ s/=\([^#]*\)#/=${state} #/" "$path" || { \
          [[ "${name^^}" == SYSTEM ]] && sudo sed -i "/.*$key=/ s/=\(.*\)/=${state}/" "$path"; }
        done
        ;;
      'INT')
        init_val=$(printf "${items[${settings}]}" | sed 's/[^0-9]//g')
        new_val=$(sudo -u pi bash -c "dialog --colors --rangebox 'RANGE' 0 0 0 1024 $init_val" 2>&1 1>&3 3>&2); new_val=$(printf "$new_val" | sed 's/[^0-9]//g')

        if [[ "$new_val" =~ ^[0-9]+$ ]]; then
          [[ "${name^^}" == @(GAMES|MAIN) ]] && sudo sed -i "/^$settings=/ s/=\([^#]*\)#/=${new_val} #/" "$path" || { \
          [[ "${name^^}" == SYSTEM ]] && sudo sed -i "/.*$settings=/ s/=\(.*\)/=${new_val}/" "$path"; }
        fi
        ;;
     esac
   fi
}

# ---------------------------------------------------------------------------------------------------------------

cmd_shutdown() {
  [ $# -lt 1 ] || [[ ! "${1}" == @(sleep|reboot|poweroff) ]] && return

  whiptail --title "WARNING" --yesno "$( echo -e "${1}?\n")" 0 20 4 2>&1 1>&3 3>&2
  [ $? -gt 0 ] && return

  case "${1,,}" in
    'poweroff') sudo poweroff ;;
    'reboot') sudo reboot ;;
    'sleep') echo "ASLEEP 1" > /tmp/serial.fifo; while read input; do break; done< <(thd --dump /dev/input/event* | grep -vw --line-buffered '.*/dev/input/event1\|^#*'); echo "ASLEEP 0" > /tmp/serial.fifo ;;
    *) ;;
  esac
}

# ---------------------------------------------------------------------------------------------------------------

commands_set_globals() {
  declare -g data_type='BOOL'
  declare -g MENU_W=$(( $(cat /sys/class/graphics/fb0/virtual_size | cut -d, -f1) / 10 ))
  declare -g MENU_H=$(( $(cat /sys/class/graphics/fb0/virtual_size | cut -d, -f2) / 12 ))
}

# ---------------------------------------------------------------------------------------------------------------

cmd_all_commands() {
  declare -a options=()
  for cmd in ${commands[@]}; do options+=("$cmd" "" OFF); done;
  local command=$(whiptail --title "SYSTEM SETTINGS" --radiolist "$(echo -e "\nSelect command:")" 0 0 4 "${options[@]}" 2>&1 1>&3 3>&2); [ $? -gt 0 ] && return
  echo "COMMAND: $command"; sleep 3
}

# ---------------------------------------------------------------------------------------------------------------

cmd_backup() { sudo bash "$HOMEDIR/ADMIN/CMD/BACKUP/BACKUP.sh"; }

# ---------------------------------------------------------------------------------------------------------------

set_games_menu() { clear; echo " G A M E S   M E N U  "; sleep 2; }
set_games_list() { clear; echo " G A M E S   L I S T  "; sleep 2; }
set_games_remap() { clear; echo " G A M E S   R E M A P  "; sleep 2; }
set_cafca_settings() { clear; echo " C A F C A   S E T T I N G S  "; sleep 2; }
set_cafca_table() { clear; echo " C A F C A   T A B L E  "; sleep 2; }
set_cafca_timers() { clear; echo " C A F C A   T I M E R S  "; sleep 2; }
set_cafca_clearram() { clear; echo " C A F C A   C L E A R R A M  "; sleep 2; }

declare -ag commands=($(typeset -F | cut -d' ' -f3-))


# BELOW ARE FUNCTIONS EXCLUDED FROM THE LIST:
# ---------------------------------------------------------------------------------------------------------------

helper() {
 declare -g assets_path="$HOMEDIR/ADMIN/MENU/.assets"
 export NEWT_COLORS="$(cat $assets_path/config/whiptail_theme.cfg)"
}

# ---------------------------------------------------------------------------------------------------------------

set_globals() {
  declare -g data_type='BOOL'
}

# ---------------------------------------------------------------------------------------------------------------

# MAIN:

set_globals

if [[ "${BASH_SOURCE[0]}" == "${0}" ]]; then
  helper

  clear
  echo "commands(${#commands[@]}):"; echo "$(for cmd in ${commands[@]}; do echo $cmd; done)"; echo ""

  (( ! $# )) && { read -p "type function name: " name; } || { name="$1"; }

  if [ ! -z $name ] && [[ "${commands[@]}" =~ "$name" ]]; then
    [ $# -gt 1 ] && params="${2}"
    echo "calling $name()"; $name "$params" 3>&1 1>&2 2>logfile
  fi
fi


# ---------------------------------------------------------------------------------------------------------------------


#while true; do
#  set_menu_settings 3>&1 1>&2 2>logfile
#done


# ---------------------------------------------------------------------------------------------------------------------




set_menu_settings_bak() {
  local path="$assets_path/.settings"
  declare -a options=()

  while read line; do
    local string=$(echo "$line" | cut -d# -f1 | sed 's/ $//g')
    local type=$(echo "$line" | awk -F'#\ ' '{$1="";print}' | sed 's/ //g')
    local key="${string%%=*}"; local val="${string##*=}"
    [[ "${type^^}" =~ OPT_BOOL ]] && { [[ $val -gt 0 ]] && options+=("$key" "" ON) || options+=("$key" "" OFF); }
  done< <(cat "$path" | sed 's/^start_page=.*$//g' | sed 's/^pages=/start_page=/g' | sed '/^#/d;/^\s*$/d')

  [[ ${#options[@]} -lt 1 ]] && return 1

  settings=$( whiptail --title "SETTINGS" --checklist "SET BOOLS" 0 0 4 "${options[@]}" 2>&1 1>&3 3>&2 )

  if [ $? -eq 0 ]; then
    sudo cp -f "$assets_path/.settings" "$assets_path/.settings.bak"

    for (( i=0; i<${#options[@]}; i+=3 )); do
      [[ "${settings//\"/}" =~  "${options[$i]}" ]] && state=1 || state=0; sudo sed -i "/${options[$i]}/ s/${options[$i]}[=][[:digit:]]/${options[$i]}=$state/" "$path"
    done
  fi
}

#func1() { echo "FUNC1"; }
#func2() { echo "FUNC2"; }
#func3() { echo "FUNC3"; }
#list() { for i in "${ARR[@]}"; do echo "$i"; done; }

#declare -ag commands=($(typeset -F | cut -d' ' -f3-))
#
#if [[ "${BASH_SOURCE[0]}" == "${0}" ]]; then
#  clear
#  echo "commands(${#commands[@]}):"; echo "$(for cmd in ${commands[@]}; do echo $cmd; done)"; echo ""
#  (( ! $# )) && { read -p "type function name: " name; } || { name="$1"; }
#
#  if ( [ ! -z $name ] && [[ $(type -t $name) == function ]] ) || [[ "${commands[@]}" =~ "$name" ]]; then
#    #echo -n "calling $name()"; sleep 1; for i in {1..3}; do echo -n "."; sleep 0.5; done; echo -e "\n"; sleep 1
#    echo "calling $name()"; sleep 1
#    $name 2>&1
#  fi
#fi


