#!/bin/bash

verbose="${1:-0}"

include() {
  HOMEDIR=$(getent passwd pi | cut -d: -f6)
  SCRIPT=$(readlink -f "$0")
  DIR=$(cd "$(dirname $SCRIPT)" && pwd)

  INCLUDED=1

  [ $verbose -gt 0 ] && echo -e "HOMEDIR:$HOMEDIR\nDIR:\t$DIR\nSCRIPT:\t$SCRIPT\n"

  trap 'cleanKill $?' EXIT INT SIGINT

  [ $verbose -gt 0 ] && echo -e "\nIncluding: \x27$DIR/include.sh\x27\n" && sleep 1.5

  checkUser
}

checkUser() {
  if [ "$(id -u)" -ne 0 ]; then
     [ $verbose -gt 0 ] && echo "please run script as root."
     sleep 1
     exit 1
  elif [ "$(id -u)" -eq 0 ]; then
     [ $verbose -gt 0 ] && echo "running script as root"
     #sleep 1
  fi
}

cleanKill() {
  trap_cmds=($(trap -l | awk '{print $0"\t"}' | awk 'BEGIN{RS="\t"}{$1=$1}1' | grep -o '[^ ]*$')); trap_cmds[130]='EXIT'
  [ $verbose -gt 0 ] && echo -e "\ncleanKill: $1 \x27${trap_cmds[$1]}\x27\n"
  exit 0
}

