#!/bin/bash

verbose=1

include() {
  HOMEDIR=$(getent passwd pi | cut -d: -f6)
  SCRIPT=$(readlink -f "$0")
  DIR=$(cd "$(dirname $SCRIPT)" && pwd)

  [ $verbose -gt 0 ] && echo -e "HOMEDIR:$HOMEDIR\nDIR:\t$DIR\nSCRIPT:\t$SCRIPT\n"
  #logfile="$DIR/
  trap_cmds=($(trap -l | awk 'BEGIN{RS=")"}{$1=$1}1' | awk -F' ' '{print $1}' | tail -n +2))
  trap_cmds[130]='EXIT'

  trap 'cleanKill $?' EXIT INT SIGINT
  INCLUDED=1
  echo -e "\nIncluding: \x27$DIR/include.sh\x27\n" && sleep 1.5
  checkUser
}

checkUser() {
  if [ "$(id -u)" -ne 0 ]; then
     echo "please run script as root."
     sleep 1
     exit 1
  elif [ "$(id -u)" -eq 0 ]; then
     echo "running script as root"
     #sleep 1
  fi
}

cleanKill() {
  echo -e "\ncleanKill: $1 \x27${trap_cmds[$1]}\x27"
  #echo -e "\ncleanKill\n\tcode: $1\n\tsig : ${trap_cmds[$1]}"
  exit 0
}

