#!/bin/bash

ARG="$@"
SCRIPT=$(readlink -f "$0"); PID=$$
DIR=$(cd "$(dirname $SCRIPT)" && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)

serial_path='/tmp/serial.fifo'
roms_path=$(grep -w -m1 'dir_roms' "$HOMEDIR/ADMIN/.sys/.settings" | cut -d\' -f2)
teensy_id=$(grep -w -m1 'DEV teensy' "$HOMEDIR/ADMIN/.sys/.settings" | cut -d\' -f2)
exception_list=$(grep -w -m1 '^EXCEPTION_LIST' "$HOMEDIR/CAFCA/data/.settings" | cut -d\' -f2)

#assets_path="$DIR/../.assets"
assets_path="$DIR/.assets"
media_path="$assets_path/media"
list_path="$assets_path/list"
cafca_cfg_path=''

HEIGHT=$(cat /sys/class/graphics/fb0/virtual_size | cut -d, -f2)
WIDTH=$(cat /sys/class/graphics/fb0/stride)

PS1_STORED=$PS1

UNMARK="$(echo -e "\e[0m")"
  MARK="$(echo -e "\e[7m")"
    NC="$(echo -e "\033[0m")"
     C="$(echo -e "\033[32m")"

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

# VARIABLES
list=(); indexes=(); timers=()
total_files=0; offset=0; active=0; prev=0; timer=0; idle_state=0; init=1; pass_valid=0

declare -Ag pageTitles=()
pages=($(awk -F'\[|\]' '{print $2}' "$list_path" | sed 's/[ ]/\n/g;' | sed ' /^$/d' | sort -u)); pages+=("ALL")
page="${pages[$pageIndex]}"
pageIndex=0

width=$(echo "$(tput cols)"); [[ $(( width % 2 )) > 0 ]] && width=$(( width - 1 ))
height=$(echo "$(tput lines)")
maxPage=$(( height - 1 ))

SAVER_PID=
FFPLAY_PID=

#________________________________________________________________________________________________________________________________________________


Main() {
  Init
  setPage

  while true; do
    input=$(readInput)

    if [[ ${#input} -gt 0 ]]; then
      [[ $play_music -gt 0 ]] && [[ $(pgrep -c ffplay) -gt 0 ]] && sudo killall ffplay 2>/dev/null
      fbSaver 0 &>/dev/null
      sudo setterm --blank poke --term linux
      navigate "$input"
    else
      if [[ $(elapsed) -ge ${timers[$idle_state]} ]]; then
	case $idle_state in
	  0) [[ $init -eq 0 ]] && { showTitle; } ;;
	  1) [[ $init -eq 0 ]] && { showMarquee; } ;;
	  2) [[ $screensaver -gt 0 ]] && { fbSaver 1 &>/dev/null; } ;;
	  3) [[ $screensaver -gt 0 ]] && { fbSaver 0 &>/dev/null; videoSaver; } ;;
          4) [[ $screensaver -gt 0 ]] && { asleep; drawScreen; idle_state=0; elapsed 0; } ;;
	  *) ;;
	esac
        [[ $idle_state -lt ${#timers[@]} ]] && (( idle_state++ ));
      fi
    fi
  done
}

#____________________________________________________________________________

navigate() {
  local key="${1^^}"
  [[ $remap -gt 0 ]] && [[ ! -z "${remaps[$key]}" ]] && key="${remaps[$key]}"

  case "${key}" in
    'UP')    prev=$active; (( active-- )); drawScreen; init=0 ;;
    'DOWN')  prev=$active; (( active++ )); drawScreen; init=0 ;;
    'LEFT')  (( pageIndex-- )); init=1; changePage ;;
    'RIGHT') (( pageIndex++ )); init=1; changePage ;;
    'ENTER') [[ $edit_mode -lt 1 ]] && [[ ! $page == ALL ]] && { prev=$active; slideshow; init=1; } ;;
    'S')     [[ $edit_mode -lt 1 ]] && launchGame || editPages ;;
    'SPACE') [[ $edit_mode -lt 1 ]] && exitMenu ;;
    'ESC')   [[ $edit_mode -lt 1 ]] && { exit; } || { loadSettings; edit_mode=0; makeList; markLine; } ;;
  esac
  idle_state=0; elapsed 0;
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

markLine() {
  tput sc; tput cup $prev 0;   printer "${list[$prev]}" 0; tput rc
  tput sc; tput cup $active 0; printer "${list[$active]}" 1; tput rc
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

drawScreen() {
  if [[ $active -lt 0 ]]; then
    if [[ $offset -gt 0 ]]; then
      offset=$(( offset - maxPage )); makeList; active=$(( maxPage -1 ));
    else
      for (( i=0; i<total_files; i++ )); do [[ $(( i % maxPage )) -eq 0 ]] && offset=$i; done
      prev=0; makeList; active=$(( (total_files - offset) - 1 ));
    fi
  elif [[ $active -ge ${#list[@]} ]]; then
    [[ $(( active + offset )) -lt $total_files ]] \
    && { offset=$(( offset + maxPage )); makeList; active=0; } \
    || { offset=0; makeList; active=0; }
  fi
  markLine
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

makeList() {
  list=()

  for (( i=$offset; i<$(( offset + maxPage )); i++ )); do
    [[ $i -ge $total_files ]] && break
    if [[ $edit_mode -lt 1 ]]; then
      title=$(sed "${indexes[$i]}q;d" "$list_path" | cut -d\' -f4 | awk -F'  |\(' '{if (NF < 3){ print $1 } else { print $1,"("$3}}')
    else
      line=$(sed "${indexes[$i]}q;d" "$list_path"); name=$(echo "$line" | awk -F\' '{print " ",$2," "}')
      pg_str=$(echo "$line" | awk -F\' '{gsub(/\[\ /, "", $(NF-1));print "[ ALL",$(NF-1)," "}')
      title=$(echo -n "$name "; printf '%*s' "$(( ( $(tput cols)-( ${#name}+${#pg_str} )) - 4))"; echo "${pg_str}")
    fi
    list+=("$title")
  done
  clear

  for (( i=0; i<${#list[@]}; i++ )) ; do
    printer "${list[$i]}" 0
    [[ $init -eq 1 ]] && sleep 0.03
  done;
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

changePage() {
  [[ $pageIndex -lt 0 ]] && pageIndex=$(( ${#pages[@]} - 1 )) || { \
  [[ $pageIndex -ge ${#pages[@]} ]] && pageIndex=0; }

  page="${pages[$pageIndex]}"; sendSerial "VFD 3 ${pageTitles[$page]}"
  setPage
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

setPage() {
  [[ $page == ALL ]] && pg=' ' || pg="$page"
  indexes=($(cat "$list_path" | awk -F'\[|\]' -v p="$pg" '$2 ~ p {split($0,i," "); print i[1]}'))
  total_files=${#indexes[@]}; offset=0

  clear; active=0; makeList; markLine
}

#____________________________________________________________________________

launchGame() {
  local entry=$(( offset + active )); idx=${indexes[$entry]}
  local path=$(sed "${idx}q;d" "$list_path" | cut -d\' -f12)

  if [ -f "$path" ]; then
    local system=$(echo "$path" | cut -d/ -f6)
    local game=$(echo "$path" | grep -o '[^/]*$' | cut -d. -f1)

    [[ "${game}" == @(${exception_list}) ]] && ( checkExceptions LOAD "${game}" & )

    sudo sed -i "s|ACTIVE_GAME[=].*$|ACTIVE_GAME=\x27${system}\/${game}\x27|g" "$HOMEDIR/CAFCA/data/.settings"
    sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --mode game; sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --remove joystick
    sudo -u pi bash -c "python3 /opt/retropie/configs/all/CRT/bin/GeneralModule/emulator_launcher.py ${path} ${system} dummy"
    sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --mode menu; sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --grab joystick; sudo setterm --cursor off

    [[ "${system}" == mame-libretro ]] && checkCfg "${game}"

    init=1; makeList; markLine
  fi
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

checkCfg() {
  [ $# -lt 1 ] && return
  local game="${1}"
  local cfg_path="$HOMEDIR/CAFCA/cfg/.backup/mame-libretro"
  local cfg_bak=$(find "$cfg_path/mame2003/cfg" -maxdepth 1 -type f -iname "${game}.cfg.bak*" -printf '%TY-%Tm-%Td %TT %p\n' 2>/dev/null | sort | tail -n 1 | grep -o '[^ ]*$')
  local cfg_new="$roms_path/mame-libretro/mame2003/cfg/${game}.cfg"

  [ -f "$cfg_bak" ] && { diff "$cfg_new" "$cfg_bak" >/dev/null 2>&1; status=$?; } || { status=1; }
  [[ $status -gt 0 ]] && { sudo cp "$cfg_new" "$cfg_path/mame2003/cfg/${game}.cfg.bak$(date +%y%m%d%H%M%S)"; echo -e "VFD 7   CFG CHANGED" > /tmp/serial.fifo; }
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

checkExceptions() {
  [ $# -lt 1 ] && return
  local mode="${1^^}"
  local game="${2}"

  case $game in
    'toki')
      if [[ $mode == LOAD ]]; then
        while [[ $(grep -w -m1 '^GAME_READY' "$HOMEDIR/CAFCA/data/.states" | cut -d= -f2) -lt 1 ]]; do :; done; sleep 1
        for state in {1..0}; do evemu-event "$teensy_id" --type EV_KEY --code KEY_S --value $state --sync; sleep 0.2; done
      fi
      ;;
  esac
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

slideshow() {
  local id_list=($(cat "$list_path" | awk -F'\[|\]' -v p="$page" '$2 ~ p {split($0,i," "); print i[1]}'))
  local entry=$(( ( offset + active ) + 1 )); local val=0

  slideshow_saver &

  fim -N -T 1 -d /dev/fb0 \
   -C $entry \
   --quiet \
   --execute-script "$assets_path/config/fim_slideshow.cfg" \
   --read-from-stdin< <( \
	for i in "${id_list[@]}"; do \
     	  name=$(sed "${i}q;d" "$list_path" | cut -d\' -f2); \
     	  system=$(sed "${i}q;d" "$list_path" | cut -d\' -f12 | cut -d/ -f6); \
          type=$(sed "${i}q;d" "$list_path" | cut -d\' -f14); \
          img="$media_path/slideshow/$system/$name/$name.$type"; \
          [ -e "$img" ] && echo "$img" || echo "$media_path/slideshow/blank.png"; \
   	done ) > "$assets_path/slideshow.log"

  local line_count=$(cat "$assets_path/slideshow.log" | wc -l )

  for ((n=$line_count; n>0; n-- )); do
    val=$(sed "${n}q;d" "$assets_path/slideshow.log")
    [[ "$val" =~ ^[0-9]+$ ]] && { val=$(( val - 1 )); break; }
  done

  offset=$(( (val / maxPage) * maxPage )); active=$(( val - offset ))
  game=$(sed "${indexes[$val]}q;d" "$list_path" | cut -d\' -f2)

  [[ $(sed '$!d' "$assets_path/slideshow.log") =~ "$game" ]] && { clear; launchGame; } || { init=0; makeList; markLine; }
}

#____________________________________________________________________________

slideshow_saver() {
  local asleep=0
  local count=0
  #local timeout=$t_slidesaver
  local timeout=$(grep -w -m1 '^t_slidesaver' "$assets_path/.settings" | cut -d= -f2 | sed 's/#.*$//')

  while [[ $(pgrep -c fim) -lt 1 ]]; do :; done
  while [[ $(pgrep -c fim) -gt 0 ]]; do
    read -t 1 input
    [[ $asleep -eq 0 ]] && [[ $count -ge $timeout ]] && { echo -e "ASLEEP 1" > /tmp/serial.fifo; asleep=1; } || { \
    [[ $asleep -eq 1 ]] && [[ ${#input} -gt 0 ]] && { echo -e "ASLEEP 0" > /tmp/serial.fifo; asleep=0; count=0; }; }
    (( count++ ))
  done< <(thd --dump /dev/input/event* | grep -v --line-buffered '^#' |& awk -W interactive '{$1=$1;print $NF}' | grep --line-buffered -vw '/dev/input/event1')
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

showSplash() {
  local timeout=${1:-5}
  local img_path=$(grep -w -m1 '^splash_path' "$assets_path/.settings" | cut -d\' -f2)
  [ -e "$img_path" ] && { sudo fbi -a -T 1 -d /dev/fb0 -t $timeout --once --noverbose "$img_path"; sleep $timeout; }
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

showTitle() {
  local entry=$(( offset + active ));
  local idx=${indexes[$entry]}
  local title=$(awk -F'\x27' -v l="$idx" 'NR==l {split($4,t," - "); print t[1],"("$6")","["$8"]"}' "$list_path")
  sendSerial "VFD 1 $title"
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

showMarquee() {
  local entry=$(( offset + active ))
  local idx=${indexes[$entry]}
  local name=$(awk -F'\x27' -v l="$idx" 'NR==l {print $2}' "$list_path")
  local file=$(find "$media_path/marquees" -type f -iname "$name*.ppm" -print -quit)

  if [ -f "$file" ] && [[ $show_marquee -gt 0 ]]; then
    H="${file##*/}"; H="${H/.*/}"; H="${H##*_}"; PAD=$(( (HEIGHT - H) / 2 ))
    sudo cat /dev/fb0 > "$assets_path/fb0.dump" & wait $!
    ( dd if="$file" bs=1 skip=$(( WIDTH * PAD )) count=$(( WIDTH * H )) iflag=skip_bytes,count_bytes | dd seek=$(( WIDTH * PAD )) oflag=seek_bytes of=/dev/fb0 ) >/dev/null 2>&1
  fi
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

fbSaver() {
  local action=${1:-0}
  local redraw=0

  if [[ $action -gt 0 ]]; then
    [ ! -f "$assets_path/fb0.dump" ] && { sudo cat /dev/fb0 > "$assets_path/fb0.dump" & wait $!; } || { sudo cat "$assets_path/fb0.dump" > /dev/fb0 & wait $!; }
    Saver >/dev/null 2>&1 & SAVER_PID=$!
  else
    [[ $SAVER_PID -gt 0 ]] && { sudo kill -9 $SAVER_PID 2>/dev/null; wait $SAVER_PID; SAVER_PID=0; redraw=1; } || { \
    [[ $show_marquee -gt 0 ]] && [ -f "$assets_path/fb0.dump" ] && redraw=1; }
    [[ $redraw -gt 0 ]] && { sudo cat "$assets_path/fb0.dump" > /dev/fb0; sudo rm "$assets_path/fb0.dump"; init=0; makeList; }
  fi
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

videoSaver() {
  local video_path=$(grep -w -m1 '^vidsaver_path' "$assets_path/.settings" | cut -d\' -f2)
  local exit_code=0

  if [ -e "$video_path" ] && [[ $play_video -gt 0 ]]; then
    [[ $play_music -gt 0 ]] && playMusic
    exit_code=$(omxplayer --aspect-mode fill --key-config "$assets_path/config/omx_config.cfg" "$video_path" 2>&1 | grep -c '^Stopped at:*')
    [[ $exit_code -lt 1 ]] && { sudo setterm --blank force --term linux; } || { idle_state=0; elapsed 0; init=0; }
 fi
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

playMusic() {
  [ $# -gt 0 ] && music_path="${@}" || music_path=$(grep -w -m1 '^music_path' "$assets_path/.settings" | cut -d\' -f2)
  [ -e "$music_path" ] && [[ $(pgrep -c 'ffplay') -lt 1 ]] && ffplay -volume $snd_vol -nodisp -autoexit -infbuf -loglevel quiet "$music_path" >/dev/null 2>&1 &
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

asleep() {
  echo -e "ASLEEP 1" > /tmp/serial.fifo
  while read line; do break; done< <(thd --dump /dev/input/event* | grep -v --line-buffered '^#' |& awk -W interactive '{$1=$1;print $NF}' | grep --line-buffered -vw '/dev/input/event1')
  echo -e "ASLEEP 0" > /tmp/serial.fifo
  sudo setterm --blank poke --term linux
}

#____________________________________________________________________________

readInput() {
    Event=''
    read -rs -N 1 -t 0.1 Event1 >/dev/null
    [[ $? -gt 127 ]] && return

    case "$Event1" in
      $'\163')	        Event="S"	;;
      $'\n')            Event="ENTER"   ;;
      ' ')              Event="SPACE"   ;;
      [[:blank:]])      Event="TAB"     ;;
      *)
        read -t 0.01 -rsn5 Event2
        case "$Event2" in
          "[A")         Event="UP"      ;;
          "[B")         Event="DOWN"    ;;
          "[D")         Event="LEFT"    ;;
          "[C")         Event="RIGHT"   ;;
          "[5~")        Event="PGUP"    ;;
          "[6~")        Event="PGDOWN"  ;;
          "OS"|"[[D")   Event="F4"      ;;
          *)
            case "$Event1$Event2" in
              $'\E')    Event="ESC"     ;;
            esac
            ;;
        esac
    esac
    echo -e "${Event}"
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

printer() {
  [[ $# -lt 1 ]] && return
  txt="${1}"; mark="${2:-0}"; pad=''; str=''

  [[ $colors -gt 0 ]] && str="${C}";
  str+="${txt}"; strlen=${#str}

  if [[ $center -gt 0 ]]; then
    [[ $(( strlen % 2 )) > 0 ]] && strlen=$(( strlen - 1 ))
    strlen=$(( strlen / 2 )); length=$(( width / 2 )); length=$(( length - strlen ))
    printf -v pad '%*s' "$length"
  fi

  [[ $mark -gt 0 ]] && str="${MARK}${str}${UNMARK}"; str="${pad}${str}";
  [[ $colors -gt 0 ]] && str+="${NC}"
  echo -e "${str}"
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

sendSerial() {
  [ $# -ge 1 ] && echo -e "$@" > /tmp/serial.fifo || return
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

elapsed() {
  [ $# -gt 0 ] \
  && timer=$(echo $(( 10#$(date +%s) ))) \
  || echo "$(( $(echo $(( 10#$(date +%s) ))) - $timer ))"
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

eraseScreen() {
  local COLOR=`printf '\\\\x00\\\\x00\\\\x00\\\\x00%0.s' $(seq 1 $WIDTH)`
  for i in $(seq 0 $HEIGHT | shuf); do printf $COLOR | dd bs=1 seek=$(( WIDTH * i )) of=/dev/fb0 >/dev/null 2>&1; done
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

loadSettings() {
  while read line; do
    key=$(echo "$line" | cut -d= -f1)
    val=$(echo "$line" | cut -d= -f2- | sed "s/'//g")
    declare -g "${key}"="$val"
  done< <(cat "$assets_path/.settings" | sed '/^page.*$/d;/path$/d;s/#.*$//;/^\s*$/d')
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

editPages() {
  local entry=${indexes[$(( offset + active ))]}
  local items=$(sed "${entry}q;d" "$list_path" | awk -F'\[|\]' '{print $2}')

  pageEditor "$entry" "${items}"

  init=1; makeList; markLine
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

Password() {
  local key=$(grep -w -m1 'admin_menu_pass' "$HOMEDIR/ADMIN/.sys/.settings" | cut -d\' -f2 | base64 -d)
  local input=''

  clear; printf "\n ${C}PASS: ${NC}"; tput sc; for (( len=0; len<${#key}; len++ )); do printf "${C}_${NC}"; done; tput rc

  while [[ ${#input} -lt ${#key} ]]; do c=$(readInput);
    [[ ${#c} -gt 0 ]] && case "$c" in 'ESC'|'S') break ;; *) input+=$(printf "${c:0:1}" | sed 's/E/A/; s/S/B/'); tput rc; printf "${C}*${NC}"; tput sc ;; esac
    #if [[ ${#c} -gt 0 ]]; then case "$c" in 'ESC'|'S') break ;; *) input+=$(printf "${c:0:1}" | sed 's/E/A/; s/S/B/'); tput rc; printf "*"; tput sc ;; esac; fi
  done; echo ""
  [[ "${input}" == "${key}" ]] && exit 42
  #[[ "${input}" == "${key}" ]] && pass_valid=42 || pass_valid=0
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

exitMenu() {
  export NEWT_COLORS="$(cat $assets_path/config/whiptail_theme.cfg)"
  whiptail --title "Alert" --yesno "\nQuit Menu?" 10 17 2>&1 1>/dev/tty
  [[ $? -lt 1 ]] && Password 2>&1 1>/dev/tty
  makeList; markLine; init=1;
  #[[ $? -lt 1 ]] && { pass_valid=0; Password 2>&1 1>/dev/tty; exit $pass_valid; } || { makeList; markLine; init=1; }
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

Init() {
  declare -ag timers=( "$t_title" "$t_marquee" "$t_fbsaver" "$t_vidsaver" "$t_sleep" )

  [ -f "$assets_path/fb0.dump" ] && sudo rm "$assets_path/fb0.dump"

  local titles_str=$(grep -w -m1 '^page_titles' "$assets_path/.settings" | cut -d\' -f2)
  while read line; do pageTitles["$(echo $line | cut -d= -f1)"]="$(echo $line | cut -d\" -f2)"; done< <(echo "$titles_str" | sed 's/[,]/\n/g' | sed 's/ //')
  for (( p=0; p<${#pages[@]}; p++ )); do [[ "${pages[$p]}" == FAV ]] && { pageIndex=$p; page="${pages[$pageIndex]}"; }; done

  trap '[[ $? -eq 42 ]] && exitFunc 42 || exitFunc 0' EXIT
  trap 'exit 1' INT HUP SIGINT SIGHUP TERM

  sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --mode menu; sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --grab joystick

  clear

  [[ $remap -eq 1 ]] && { declare -Ag remaps=(); for entry in `echo ${remapping}`; do remaps["${entry%%=*}"]="${entry##*=}"; done; }
  [[ $hide_term -eq 1 ]] && { PS1=; stty -F /dev/tty1 -echo; sudo setterm --cursor off; }
  [[ $test_input -eq 1 ]] && { while [[ $test_input -gt 0 ]]; do input=$(readInput); [[ ${#input} -gt 0 ]] && echo " INPUT: $input"; test_input=$(grep -w -m1 '^test_input' "$assets_path/.settings" | cut -d= -f2 | sed 's/#.*$//'); done; }
  [[ $edit_mode -eq 1 ]] && { center=0; show_marquee=0; play_video=0; show_splash=0; echo "VFD 3    EDIT MODE " > /tmp/serial.fifo; }

  if [[ "${ARG}" == BOOT ]]; then
    sudo bash "$HOMEDIR/ADMIN/CMD/PLAY/INTRO.sh" >/dev/null 2>&1 &
    [[ $show_splash -eq 1 ]] && showSplash >/dev/null 2>&1
  fi

  #echo "VFD 4 $(printf "\x$(printf %x 159)%0.s" $(seq 1 16))" > /tmp/serial.fifo

  elapsed 0
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

exitFunc() {
  local signal=$1

  sudo rm "$assets_path/fb0.dump" &>/dev/null

  JOBS=($(jobs -p))
  [[ ${#JOBS[@]} -gt 0 ]] && sudo kill -9 "${JOBS[@]}" &> /dev/null

  if [[ $signal -ne 42 ]]; then
    echo "VFD 4  G O O D B Y E" > /tmp/serial.fifo
    sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --remove joystick
    sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --mode term
    [[ $post_clear -gt 0 ]] && { eraseScreen; clear; }
    [[ $hide_term -eq 1 ]] && { stty -F /dev/tty1 sane; sudo setterm --cursor on; }
  fi

  export PS1="$PS1_STORED"
  exit $signal
}

#____________________________________________________________________________

# MAIN LOOP

loadSettings
[[ $screensaver -eq 1 ]] && source "$assets_path/saver/saver.sh"
[[ $edit_mode -eq 1 ]] && source "$assets_path/helpers/page_editor.sh"

Main
exit


#____________________________________________________________________________
