#!/bin/bash

ARG="$@"; PID=$$; PS1_STORED=$PS1

UNMARK="$(echo -e "\e[0m")"
  MARK="$(echo -e "\e[7m")"
    NC="$(echo -e "\033[0m")"
     C="$(echo -e "\033[32m")"

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# PATHS

SCRIPT=$(readlink -f "$0")
DIR=$(cd "$(dirname $SCRIPT)" && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)

serial_path=$(sed -n '/fifo_com/ { s/\(.*\)=//g; s/\x27//g; p }' "$HOMEDIR/ADMIN/.sys/.settings")
roms_path=$(grep -w -m1 'dir_roms' "$HOMEDIR/ADMIN/.sys/.settings" | cut -d\' -f2)
assets_path="$DIR/.assets"
media_path="$assets_path/media"
list_path="$assets_path/list"

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

width=$(echo "$(tput cols)"); [[ $(( width % 2 )) > 0 ]] && width=$(( width - 1 ))
height=$(echo "$(tput lines)")
maxPage=$(( height - 2 ));

declare -A pageTitles=();
#declare -a pages=(); declare -a list=(); declare -a indexes=();

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# REM ?

debug=1

HEIGHT=$(cat /sys/class/graphics/fb0/virtual_size | cut -d, -f2)
WIDTH=$(cat /sys/class/graphics/fb0/stride)

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

Init() {
  loadSettings

  for arr in pages list indexes offsets; do declare -ag "${arr}"; done
  for var in navigated idle_count pageIndex page offset section active total_files; do declare -g "${var}"=0; done

  local titles_str=$(sed -n '/# GLOBAL\|# GAMES/,/# EOF_GLOBAL\|# EOF_GAMES/ { s/#.*$//; /^\s*$/d; /^page_titles/ { s/^[^=]*=//; s/\x27//g; s/\s*$//; p; q } }' "$assets_path/.settings")
  while read line; do key="${line%%=*}"; str="${line##*=}"; pageTitles["${key}"]="${str//\"/}"; done< <(echo "$titles_str" | sed 's/[,]/\n/g' | sed 's/ //')

  declare -ag pages=($(sed -n '/\[ \([^]]*\) \]/ { s/.*\[ \([^]]*\) \].*/\1/; s/ /\n/g;/^$/d; p }' $list_path | sort -u)); sortPages "${pages[@]}"

  [[ $remap -eq 1 ]] && { declare -Ag remaps=(); for rmp in `echo ${remapping}`; do remaps["${rmp%%=*}"]="${rmp##*=}"; done; }
  [[ $hide_term -eq 1 ]] && { PS1=; stty -F /dev/tty1 -echo; sudo setterm --cursor off; }

  [ ! -f "$assets_path/fb0.dump" ] && { touch "$assets_path/fb0.dump"; for fb in $assets_path/fb0.dump; do touch $fb; chmod 775 $fb; chown pi:root $fb; done; }

  trap 'exitFunc' EXIT; trap 'exit 1' INT HUP SIGINT SIGHUP TERM
  sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --mode menu; sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --grab joystick

  sendSerial "VFD 1 $( (( test_mode )) && echo 'EDIT MODE' || echo 'GAMES MENU' )"
  debug "\npage: $page ($pageIndex)\nmaxPage: $maxPage\n"
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

Main() {
  Init
  setPage

  while true; do
    input=$(readInput)

    if [[ ${#input} -gt 0 ]]; then
      navigate "${input}"
    else (( idle_count++ ));
      [[ $idle_count -gt $(( t_title * 10 )) ]] && [[ $navigated -eq 1 ]] && { showTitle; navigated=0; }
    fi
  done
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

navigate() {
  local key="${@}"
  [[ $remap -eq 1 ]] && [[ ! -z "${remaps[$input]}" ]] && key="${remaps[$input]}"

  #debug "$input -> $key\n"

  if [[ $test_input -lt 1 ]]; then
    case "${key}" in
      'UP') (( active++ )); navigated=1 ;;
      'DOWN') (( active-- )); navigated=1 ;;
      'LEFT') (( pageIndex-- )); changePage ;;
      'RIGHT') (( pageIndex++ )); changePage ;;
      'PGUP') (( section-- )); makeList; navigated=1 ;;
      'PGDOWN') (( section++ )); makeList; navigated=1 ;;
      'ENTER') ;;
      'START') ;;
      'SPACE') ;;
      'ESC') ;;
    esac
  else debug "$input -> $key";
  fi

  idle_count=0; title_shown=0
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

makeList() {
  section=$(( section % ${#offsets[@]} ));
  offset=${offsets[$section]}; active=0; list=()

  for (( x=$offset; x<$((offset+maxPage)); x++ )); do
    [[ $x -ge $total_files ]] && break;
    title=$(sed "${indexes[$x]}q;d" "$list_path" | cut -d\' -f4 | awk -F'  |\(' '{if (NF < 3){ print $1 } else { print $1,"("$3}}')
    list+=("$title")
  done
  clear
  for (( i=0; i<${#list[@]}; i++ )) ; do echo "${list[$i]}"; done
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

changePage() {
  pageIndex=$(( pageIndex % ${#pages[@]} )); page="${pages[$pageIndex]}"
  sendSerial "VFD 3 ${pageTitles[$page]}"
  setPage; navigated=0;
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

setPage() {
  [[ $page == ALL ]] && pg=' ' || pg="$page"
  indexes=($(cat "$list_path" | awk -F'\[|\]' -v p="$pg" '$2 ~ p {split($0,i," "); print i[1]}')); total_files=${#indexes[@]};
  offsets=($(for (( x=0; x<${#indexes[@]}; x+=$maxPage )); do echo $x; done))
  section=0

  #[[ $total_files -lt $maxPage ]] && offsets=(0) || { offsets=($(for (( x=0; x<${#indexes[@]}; x+=$maxPage )); do echo $x; done)); }
  #offsets=($(for (( x=0; x<${#indexes[@]}; x+=$maxPage )); do echo $x; done)); offset=${offsets[$pageIndex]}
  debug "offsets: ${offsets[@]}"
  debug "page: $page, section: $section / $((${#offsets[@]}-1)) ( total: $total_files )\n"
  makeList
   #clear; active=0; makeList; markLine
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

sortPages() { pages=();
  for i in $(seq 1 $#); do [[ "${!i}" == $start_page ]] && { shift $((i-1)); break; } || pages+=("${!i}"); done; pages=( "${@}" "ALL" "${pages[@]}" )
  for p in $(seq 0 $(( ${#pages[@]}-1))); do [[ "${pages[$p]}" == "${start_page}" ]] && { pageIndex=$p; page="${pages[$pageIndex]}"; }; debug "pages[$p]: ${pages[$p]}"; done
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

readInput() {
  Event=''
  read -rs -N 1 -t 0.1 Event1 >/dev/null #-u 6 Event1 6<$(tty) >/dev/null

  [[ $? -gt 127 ]] && return

  case "$Event1" in
    $'\163')	      Event="START"	;;
    $'\n')            Event="ENTER"   ;;
    ' ')              Event="SPACE"   ;;
    [[:blank:]])      Event="TAB"     ;;
    *)
      read -rsn5 -t 0.01 Event2 >/dev/null #-u 6 Event2 6<$(tty) >/dev/null

      case "$Event2" in
        "[A")         Event="UP"      ;;
        "[B")         Event="DOWN"    ;;
        "[D")         Event="LEFT"    ;;
        "[C")         Event="RIGHT"   ;;
        "[5~")        Event="PGUP"    ;;
        "[6~")        Event="PGDOWN"  ;;
        "OS"|"[[D")   Event="F4"      ;;
        *)
          case "$Event1$Event2" in
            $'\E')    Event="ESC"     ;;
          esac
          ;;
      esac
  esac

  printf "${Event}"
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

loadSettings() {
  debug "\nSETTINGS:"
  while read line; do
    key=$(echo "$line" | cut -d= -f1)
    val=$(echo "$line" | cut -d= -f2- | sed "s/'//g")
    declare -g "${key}"="$val"
    debug " - $key = $val"
  done< <(sed -n '/# GLOBAL\|# GAMES/,/# EOF_GLOBAL\|# EOF_GAMES/ { /^page.*$/d; /path$/d; s/#.*$//;/^\s*$/d; s/\s*$//; p }' "$assets_path/.settings")
  debug ""
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

showTitle() {
  debug "TITLE"
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

sendSerial() {
  [ $# -ge 1 ] && echo -e "$@" > $serial_path || return
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

debug() { [[ $debug -eq 1 ]] && echo -e "$@"; }

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

exitFunc() {
  local signal=$1
  local JOBS=($(jobs -p)); [[ ${#JOBS[@]} -gt 0 ]] && sudo kill -9 "${JOBS[@]}" &> /dev/null

  sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --remove joystick #; sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --mode term

  [[ $post_clear -eq 1 ]] && sleep 0.1 # ; clear
  [[ $hide_term -eq 1 ]] && { stty -F /dev/tty1 sane; sudo setterm --cursor on; }

  export PS1="$PS1_STORED"; exit $signal
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

Main
exit

# ________________________________________________________________________________________________________________________________________________________________________________________________________
#
#  _____ _____ _   _  ____  _____  ______
# |_   _/ ____| \ | |/ __ \|  __ \|  ____|
#   | || |  __|  \| | |  | | |__) | |_
#   | || | |_ | . ` | |  | |  _  /|  __|
#  _| || |__| | |\  | |__| | | \ \| |____
# |_____\_____|_| \_|\____/|_|  \_\______|
#
# ________________________________________________________________________________________________________________________________________________________________________________________________________


makeList() {
  list=()

  for (( i=$offset; i<$(( offset + maxPage )); i++ )); do
    [[ $i -ge $total_files ]] && break
    if [[ $edit_mode -lt 1 ]]; then
      title=$(sed "${indexes[$i]}q;d" "$list_path" | cut -d\' -f4 | awk -F'  |\(' '{if (NF < 3){ print $1 } else { print $1,"("$3}}')
    else
      line=$(sed "${indexes[$i]}q;d" "$list_path"); name=$(echo "$line" | awk -F\' '{print " ",$2," "}')
      pg_str=$(echo "$line" | awk -F\' '{gsub(/\[\ /, "", $(NF-1));print "[ ALL",$(NF-1)," "}')
      title=$(echo -n "$name "; printf '%*s' "$(( ( $(tput cols)-( ${#name}+${#pg_str} )) - 4))"; echo "${pg_str}")
    fi
    list+=("$title")
  done
  clear

  for (( i=0; i<${#list[@]}; i++ )) ; do
    printer "${list[$i]}" 0
    [[ $init -eq 1 ]] && sleep 0.03
  done;
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

drawScreen() {
  if [[ $active -lt 0 ]]; then
    if [[ $offset -gt 0 ]]; then
      offset=$(( offset - maxPage )); makeList; active=$(( maxPage -1 ));
    else
      for (( i=0; i<total_files; i++ )); do [[ $(( i % maxPage )) -eq 0 ]] && offset=$i; done
      prev=0; makeList; active=$(( (total_files - offset) - 1 ));
    fi
  elif [[ $active -ge ${#list[@]} ]]; then
    [[ $(( active + offset )) -lt $total_files ]] \
    && { offset=$(( offset + maxPage )); makeList; active=0; } \
    || { offset=0; makeList; active=0; }
  fi
  markLine
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

markLine() {
  tput sc; tput cup $prev 0;   printer "${list[$prev]}" 0; tput rc
  tput sc; tput cup $active 0; printer "${list[$active]}" 1; tput rc
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


#!/bin/bash

SCRIPT=$(readlink -f "$0"); PID=$$
DIR=$(cd "$(dirname $SCRIPT)" && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# PATHS

serial_path='/tmp/serial.fifo'
roms_path=$(grep -w -m1 'dir_roms' "$HOMEDIR/ADMIN/.sys/.settings" | cut -d\' -f2)
assets_path="$DIR/.assets"
media_path="$assets_path/media"
list_path="$assets_path/list"
cafca_cfg_path=''

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# VARIABLES / CONSTS

ARG="$@"; PS1_STORED=$PS1

UNMARK="$(echo -e "\e[0m")"
  MARK="$(echo -e "\e[7m")"
    NC="$(echo -e "\033[0m")"
     C="$(echo -e "\033[32m")"

teensy_id=$(grep -w -m1 'DEV teensy' "$HOMEDIR/ADMIN/.sys/.settings" | cut -d\' -f2)
exception_list=$(grep -w -m1 '^EXCEPTION_LIST' "$HOMEDIR/CAFCA/data/.settings" | cut -d\' -f2)

HEIGHT=$(cat /sys/class/graphics/fb0/virtual_size | cut -d, -f2)
WIDTH=$(cat /sys/class/graphics/fb0/stride)

total_files=0; offset=0; active=0; prev=0; idle_state=0; init=1; pass_valid=0; fb_state=0

list=(); indexes=()
pages=($(awk -F'\[|\]' '{print $2}' "$list_path" | sed 's/[ ]/\n/g;' | sed ' /^$/d' | sort -u)); pages+=("ALL")
page="${pages[$pageIndex]}"
pageIndex=0

width=$(echo "$(tput cols)"); [[ $(( width % 2 )) > 0 ]] && width=$(( width - 1 ))
height=$(echo "$(tput lines)")
maxPage=$(( height - 1 ))

SAVER_PID=; FFPLAY_PID=

declare timer=$(date --date 'now' +%s)
declare time_elapsed=$(echo "$((10#$(date --date 'now' +%s)-timer))")

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

source "$assets_path/saver/saver.sh"
source "$assets_path/helpers/page_editor.sh"

#________________________________________________________________________________________________________________________________________________
#
# FUNCTIONS

Init() {
  loadSettings

  #declare -ag timers=( 2 5 10 20 60 )
  declare -ag timers=( "$t_title" "$t_marquee" "$t_fbsaver" "$t_vidsaver" "$t_sleep" )
  declare -Ag pageTitles=()
  local titles_str=$(sed -n '/# GLOBAL\|# GAMES/,/# EOF_GLOBAL\|# EOF_GAMES/ { s/#.*$//; /^\s*$/d; /^page_titles/ { s/^[^=]*=//; s/\x27//g; s/\s*$//; p; q } }' "$assets_path/.settings")
  while read line; do key="${line%%=*}"; str="${line##*=}"; pageTitles["${key}"]="${str//\"/}"; done< <(echo "$titles_str" | sed 's/[,]/\n/g' | sed 's/ //')
  for (( p=0; p<${#pages[@]}; p++ )); do [[ "${pages[$p]}" == FAV ]] && { pageIndex=$p; page="${pages[$pageIndex]}"; }; done

  [ -f "$assets_path/fb0.dump" ] && sudo rm "$assets_path/fb0.dump"

  trap '[[ $? -eq 42 ]] && exitFunc 42 || exitFunc 0' EXIT; trap 'exit 1' INT HUP SIGINT SIGHUP TERM

  sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --mode menu; sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --grab joystick

  [[ "${ARG^^}" == BOOT ]] && { ( sudo bash "$HOMEDIR/ADMIN/CMD/PLAY/INTRO.sh" >/dev/null 2>&1 & ); [[ $show_splash -eq 1 ]] && showSplash >/dev/null 2>&1; }

  [[ $remap -eq 1 ]] && { declare -Ag remaps=(); for entry in `echo ${remapping}`; do remaps["${entry%%=*}"]="${entry##*=}"; done; }
  [[ $hide_term -eq 1 ]] && { PS1=; stty -F /dev/tty1 -echo; sudo setterm --cursor off; }
  [[ $test_input -eq 1 ]] && { while [[ $test_input -gt 0 ]]; do input=$(readInput); [[ ${#input} -gt 0 ]] && echo " INPUT: $input"; test_input=$(sed -n '/# GLOBAL\|# GAMES/,/# EOF_GLOBAL\|# EOF_GAMES/ { s/#.*$//; /^\s*$/d; /^test_input/ { s/.*=//; p; q } }' "$assets_path/.settings"); done; }
  [[ $edit_mode -eq 1 ]] && { center=0; show_marquee=0; play_video=0; show_splash=0; echo "VFD 3    EDIT MODE " > /tmp/serial.fifo; } || echo "VFD 0    GAMES MENU" > /tmp/serial.fifo;

  elapsed 0; sleep 2
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

Main() {
  Init
  setPage

  while true; do
    input=$(readInput)

    if [[ ${#input} -gt 0 ]]; then
      fbSaver 0 &>/dev/null
      blankScreen 0
      navigate "$input"
      #[[ $play_music -gt 0 ]] && [[ $(pgrep -c ffplay) -gt 0 ]] && sudo killall ffplay 2>/dev/null
      #[[ $SAVER_PID -lt 1 ]] && navigate "$input" || fbSaver 0 &>/dev/null
    else
      if [[ $time_elapsed -ge ${timers[$idle_state]} ]]; then
	case $idle_state in
	  0) [[ $init -eq 0 ]] && { showTitle; } ;;
	  1) [[ $init -eq 0 ]] && { showMarquee; } ;;
	  2) [[ $screensaver -gt 0 ]] && { fbSaver 1 &>/dev/null; } ;;
	  3) [[ $screensaver -gt 0 ]] && { fbSaver 0 &>/dev/null; videoSaver; } ;;
          4) [[ $screensaver -gt 0 ]] && { asleep; drawScreen; } ;;
	  *) ;;
	esac
        (( idle_state++ ))
        [[ $idle_state -ge ${#timers[@]} ]] && { idle_state=0; elapsed 0; }
      else
        elapsed
      fi
    fi
  done
}

#____________________________________________________________________________

navigate() {
  local key="${1^^}"
  [[ $remap -gt 0 ]] && [[ ! -z "${remaps[$key]}" ]] && key="${remaps[$key]}"

  case "${key}" in
    'UP')     prev=$active; (( active-- )); drawScreen; init=0 ;;
    'DOWN')   prev=$active; (( active++ )); drawScreen; init=0 ;;
    'LEFT')   (( pageIndex-- )); init=1; changePage ;;
    'RIGHT')  (( pageIndex++ )); init=1; changePage ;;
    'PGUP')   (( active -= maxPage )); drawScreen; init=0 ;;
    'PGDOWN') (( active += maxPage )); drawScreen; init=0 ;;
    'ENTER')  [[ $edit_mode -lt 1 ]] && [[ ! $page == ALL ]] && { prev=$active; slideshow; init=1; } ;;
    'S')      [[ $edit_mode -lt 1 ]] && launchGame || editPages ;;
    'SPACE')  [[ $edit_mode -lt 1 ]] && exitMenu 1 ;;
    'ESC')    [[ $edit_mode -lt 1 ]] && { exitMenu 0; } || { loadSettings; edit_mode=0; makeList; markLine; } ;;
  esac
  idle_state=0; elapsed 0;
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

markLine() {
  tput sc; tput cup $prev 0;   printer "${list[$prev]}" 0; tput rc
  tput sc; tput cup $active 0; printer "${list[$active]}" 1; tput rc
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

drawScreen() {
  if [[ $active -lt 0 ]]; then
    if [[ $offset -gt 0 ]]; then
      offset=$(( offset - maxPage )); makeList; active=$(( maxPage -1 ));
    else
      for (( i=0; i<total_files; i++ )); do [[ $(( i % maxPage )) -eq 0 ]] && offset=$i; done
      prev=0; makeList; active=$(( (total_files - offset) - 1 ));
    fi
  elif [[ $active -ge ${#list[@]} ]]; then
    [[ $(( active + offset )) -lt $total_files ]] \
    && { offset=$(( offset + maxPage )); makeList; active=0; } \
    || { offset=0; makeList; active=0; }
  fi
  markLine
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

makeList() {
  list=()

  for (( i=$offset; i<$(( offset + maxPage )); i++ )); do
    [[ $i -ge $total_files ]] && break
    if [[ $edit_mode -lt 1 ]]; then
      title=$(sed "${indexes[$i]}q;d" "$list_path" | cut -d\' -f4 | awk -F'  |\(' '{if (NF < 3){ print $1 } else { print $1,"("$3}}')
    else
      line=$(sed "${indexes[$i]}q;d" "$list_path"); name=$(echo "$line" | awk -F\' '{print " ",$2," "}')
      pg_str=$(echo "$line" | awk -F\' '{gsub(/\[\ /, "", $(NF-1));print "[ ALL",$(NF-1)," "}')
      title=$(echo -n "$name "; printf '%*s' "$(( ( $(tput cols)-( ${#name}+${#pg_str} )) - 4))"; echo "${pg_str}")
    fi
    list+=("$title")
  done
  clear

  for (( i=0; i<${#list[@]}; i++ )) ; do
    printer "${list[$i]}" 0
    [[ $init -eq 1 ]] && sleep 0.03
  done;
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

changePage() {
  [[ $pageIndex -lt 0 ]] && pageIndex=$(( ${#pages[@]} - 1 )) || { \
  [[ $pageIndex -ge ${#pages[@]} ]] && pageIndex=0; }

  page="${pages[$pageIndex]}"; sendSerial "VFD 3 ${pageTitles[$page]}"
  setPage
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

setPage() {
  [[ $page == ALL ]] && pg=' ' || pg="$page"
  indexes=($(cat "$list_path" | awk -F'\[|\]' -v p="$pg" '$2 ~ p {split($0,i," "); print i[1]}'))
  total_files=${#indexes[@]}; offset=0

  clear; active=0; makeList; markLine
}

#____________________________________________________________________________

launchGame() {
  local entry=$(( offset + active )); idx=${indexes[$entry]}
  local path=$(sed "${idx}q;d" "$list_path" | cut -d\' -f12)

  if [ -f "$path" ]; then
    local system=$(echo "$path" | cut -d/ -f6)
    local game=$(echo "$path" | grep -o '[^/]*$' | cut -d. -f1)

    [[ "${game}" == @(${exception_list}) ]] && ( checkExceptions LOAD "${game}" & )

    sudo sed -i "s|ACTIVE_GAME[=].*$|ACTIVE_GAME=\x27${system}\/${game}\x27|g" "$HOMEDIR/CAFCA/data/.settings"
    sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --mode game; sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --remove joystick
    sudo -u pi bash -c "python3 /opt/retropie/configs/all/CRT/bin/GeneralModule/emulator_launcher.py ${path} ${system} dummy"
    sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --mode menu; sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --grab joystick; sudo setterm --cursor off

    [[ "${system}" == mame-libretro ]] && checkCfg "${game}"

    init=1; makeList; markLine
  fi
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

checkCfg() {
  [ $# -lt 1 ] && return
  local game="${1}"
  local cfg_path="$HOMEDIR/CAFCA/cfg/.backup/mame-libretro"
  local cfg_bak=$(find "$cfg_path/mame2003/cfg" -maxdepth 1 -type f -iname "${game}.cfg.bak*" -printf '%TY-%Tm-%Td %TT %p\n' 2>/dev/null | sort | tail -n 1 | grep -o '[^ ]*$')
  local cfg_new="$roms_path/mame-libretro/mame2003/cfg/${game}.cfg"

  [ -f "$cfg_bak" ] && { diff "$cfg_new" "$cfg_bak" >/dev/null 2>&1; status=$?; } || { status=1; }
  [[ $status -gt 0 ]] && { sudo cp "$cfg_new" "$cfg_path/mame2003/cfg/${game}.cfg.bak$(date +%y%m%d%H%M%S)"; echo -e "VFD 7   CFG CHANGED" > /tmp/serial.fifo; }
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

checkExceptions() {
  [ $# -lt 1 ] && return
  local mode="${1^^}"
  local game="${2}"

  case $game in
    'toki')
      if [[ $mode == LOAD ]]; then
        while [[ $(grep -w -m1 '^GAME_READY' "$HOMEDIR/CAFCA/data/.states" | cut -d= -f2) -lt 1 ]]; do :; done; sleep 1
        for state in {1..0}; do evemu-event "$teensy_id" --type EV_KEY --code KEY_S --value $state --sync; sleep 0.2; done
      fi
      ;;
  esac
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

slideshow() {
  local id_list=($(cat "$list_path" | awk -F'\[|\]' -v p="$page" '$2 ~ p {split($0,i," "); print i[1]}'))
  local entry=$(( ( offset + active ) + 1 )); local val=0

  #slideshow_saver &

  fim -N -T 1 -d /dev/fb0 \
   -C $entry \
   --quiet \
   --execute-script "$assets_path/config/fim_slideshow.cfg" \
   --read-from-stdin< <( \
	for i in "${id_list[@]}"; do \
     	  name=$(sed "${i}q;d" "$list_path" | cut -d\' -f2); \
     	  system=$(sed "${i}q;d" "$list_path" | cut -d\' -f12 | cut -d/ -f6); \
          type=$(sed "${i}q;d" "$list_path" | cut -d\' -f14); \
          img="$media_path/slideshow/$system/$name/$name.$type"; \
          [ -e "$img" ] && echo "$img" || echo "$media_path/slideshow/blank.png"; \
   	done ) > "$assets_path/slideshow.log"

  local line_count=$(cat "$assets_path/slideshow.log" | wc -l )

  for ((n=$line_count; n>0; n-- )); do
    val=$(sed "${n}q;d" "$assets_path/slideshow.log")
    [[ "$val" =~ ^[0-9]+$ ]] && { val=$(( val - 1 )); break; }
  done

  offset=$(( (val / maxPage) * maxPage )); active=$(( val - offset ))
  game=$(sed "${indexes[$val]}q;d" "$list_path" | cut -d\' -f2)

  [[ $(sed '$!d' "$assets_path/slideshow.log") =~ "$game" ]] && { clear; launchGame; } || { init=0; makeList; markLine; }
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

slideshow_saver() {
  local timeout=$(sed -n '/# GLOBAL\|# GAMES/,/# EOF_GLOBAL\|# EOF_GAMES/ { s/#.*$//; /^\s*$/d; /^t_slidesaver/ { s/.*=//; s/\s*$//; p; q } }' "$assets_path/.settings")

  while [[ $(pgrep -c fim) -gt 0 ]]; do
    read -s -N 1 -t $timeout void >/dev/null; elapsed
    [[ $time_elapsed -ge $timeout ]] && { echo "ASLEEP 1" > /tmp/serial.fifo; sleep 1; read -rs -N 1 void; echo "ASLEEP 0" > /tmp/serial.fifo; }; elapsed 0
  done< <(thd --dump /dev/input/event* | grep -vw --line-buffered '.*/dev/input/event1\|^#*')
}

#____________________________________________________________________________

showSplash() {
  local timeout=${1:-5}
  local img_path=$(sed -n '/# GLOBAL\|# GAMES/,/# EOF_GLOBAL\|# EOF_GAMES/ { s/#.*$//; /^\s*$/d; /^splash_path/ { s/.*=//; s/\x27//g; s/\s*$//; p; q } }' "$assets_path/.settings")

  [ -f $img_path ] && { sleep $(( timeout / 2 )); sudo fbi -a -T 1 -d /dev/fb0 -t $timeout --once --noverbose $img_path; }
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

showTitle() {
  local entry=$(( offset + active ));
  local idx=${indexes[$entry]}
  local title=$(awk -F'\x27' -v l="$idx" 'NR==l {split($4,t," - "); print t[1],"("$6")","["$8"]"}' "$list_path")

  sendSerial "VFD 1 $title"
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

showMarquee() {
  local entry=$(( offset + active ))
  local idx=${indexes[$entry]}
  local name=$(awk -F'\x27' -v l="$idx" 'NR==l {print $2}' "$list_path")
  local file=$(find "$media_path/marquees" -type f -iname "$name*.ppm" -print -quit)

  if [ -f "$file" ] && [[ $show_marquee -gt 0 ]]; then
    H="${file##*/}"; H="${H/.*/}"; H="${H##*_}"; PAD=$(( (HEIGHT - H) / 2 ))
    sudo cat /dev/fb0 > "$assets_path/fb0.dump" & wait $!
    ( dd if="$file" bs=1 skip=$(( WIDTH * PAD )) count=$(( WIDTH * H )) iflag=skip_bytes,count_bytes | dd seek=$(( WIDTH * PAD )) oflag=seek_bytes of=/dev/fb0 ) >/dev/null 2>&1
  fi
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

fbSaver() {
  local action=${1:-0}
  local redraw=0

  if [[ $action -gt 0 ]]; then
    [ ! -f "$assets_path/fb0.dump" ] && { sudo cat /dev/fb0 > "$assets_path/fb0.dump" & wait $!; } || { sudo cat "$assets_path/fb0.dump" > /dev/fb0 & wait $!; }
    Saver >/dev/null 2>&1 & SAVER_PID=$!
  else
    [[ $SAVER_PID -gt 0 ]] && { sudo kill -9 $SAVER_PID 2>/dev/null; wait $SAVER_PID; SAVER_PID=0; redraw=1; } || { \
    [[ $show_marquee -gt 0 ]] && [ -f "$assets_path/fb0.dump" ] && redraw=1; }
    [[ $redraw -gt 0 ]] && { sudo cat "$assets_path/fb0.dump" > /dev/fb0; sudo rm "$assets_path/fb0.dump"; init=0; makeList; }
  fi
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

videoSaver() {
  local video_path=$(sed -n '/# GLOBAL\|# GAMES/,/# EOF_GLOBAL\|# EOF_GAMES/ { s/#.*$//; /^\s*$/d; /^vidsaver_path/ { s/.*=//; s/\x27//g; s/\s*$//; p; q } }' "$assets_path/.settings")
  local exit_code=0

  if [ -f "$video_path" ] && [[ $play_video -gt 0 ]]; then
    [[ $play_music -gt 0 ]] && playMusic

    exit_code=$(omxplayer --aspect-mode fill --key-config "$assets_path/config/omx_config.cfg" "$video_path" 2>&1 | grep -c '^Stopped at:*')
    [[ $(pgrep -c ffplay) -gt 0 ]] && sudo killall ffplay 2>/dev/null
    [[ $exit_code -lt 1 ]] && { blankScreen 1; } || { init=1; elapsed 0; idle_state=4; }
 fi
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

playMusic() {
  local music_path=$(sed -n '/# GLOBAL\|# GAMES/,/# EOF_GLOBAL\|# EOF_GAMES/ { s/#.*$//; /^\s*$/d; /^music_path/ { s/.*=//; s/\x27//g; s/\s*$//; p; q } }' "$assets_path/.settings")
  [ $# -gt 0 ] && music_path="${@}"

  if [ -f "$music_path" ]; then
    [[ $(pgrep -c 'ffplay') -gt 0 ]] && { sudo killall ffplay 2>/dev/null; } #while [[ $(pgrep -c 'ffplay') -gt 0 ]]; do :; done; }
    ffplay -volume $snd_vol -nodisp -autoexit -infbuf -loglevel quiet "$music_path" >/dev/null 2>&1 &
  fi
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

asleep() {
  [[ $(pgrep -c ffplay) -gt 0 ]] && sudo killall ffplay 2>/dev/null
  echo "ASLEEP 1" > /tmp/serial.fifo; sleep 1; echo "VFD 3  GOING TO SLEEP" > /tmp/serial.fifo
  read -rs -N 1 -u 6 Event1 6<$(tty)  # wait for console input
  read -rs -t 0.1 -u 6 void 6<$(tty)  # pick up gremlins before returning
  echo "ASLEEP 0" > /tmp/serial.fifo; sleep 1; echo "VFD 2 READY PLAYER ONE" > /tmp/serial.fifo
  blankScreen 0;
  init=1
}

#____________________________________________________________________________

readInput() {
    Event=''
    read -rs -N 1 -t 0.1 Event1 >/dev/null #-u 6 Event1 6<$(tty) >/dev/null

    [[ $? -gt 127 ]] && return

    case "$Event1" in
      $'\163')	        Event="S"	;;
      $'\n')            Event="ENTER"   ;;
      ' ')              Event="SPACE"   ;;
      [[:blank:]])      Event="TAB"     ;;
      *)
        read -rsn5 -t 0.01 Event2 >/dev/null #-u 6 Event2 6<$(tty) >/dev/null

        case "$Event2" in
          "[A")         Event="UP"      ;;
          "[B")         Event="DOWN"    ;;
          "[D")         Event="LEFT"    ;;
          "[C")         Event="RIGHT"   ;;
          "[5~")        Event="PGUP"    ;;
          "[6~")        Event="PGDOWN"  ;;
          "OS"|"[[D")   Event="F4"      ;;
          *)
            case "$Event1$Event2" in
              $'\E')    Event="ESC"     ;;
            esac
            ;;
        esac
    esac
    echo -e "${Event}"
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

printer() {
  [[ $# -lt 1 ]] && return
  txt="${1}"; mark="${2:-0}"; pad=''; str=''

  [[ $colors -gt 0 ]] && str="${C}";
  str+="${txt}"; strlen=${#str}

  if [[ $center -gt 0 ]]; then
    [[ $(( strlen % 2 )) > 0 ]] && strlen=$(( strlen - 1 ))
    strlen=$(( strlen / 2 )); length=$(( width / 2 )); length=$(( length - strlen ))
    printf -v pad '%*s' "$length"
  fi

  [[ $mark -gt 0 ]] && str="${MARK}${str}${UNMARK}"; str="${pad}${str}";
  [[ $colors -gt 0 ]] && str+="${NC}"
  echo -e "${str}"
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

blankScreen() { sudo setterm --blank $( (( $# )) && (( $1 )) && echo force || echo poke ) --term linux; }

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

sendSerial() {
  [ $# -ge 1 ] && echo -e "$@" > /tmp/serial.fifo || return
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

elapsed() {
  local now=$(date --date 'now' +%s)
  [ $# -gt 0 ] && [[ $1 -eq 0 ]] && declare -g timer=$(date --date 'now' +%s)
  declare -g time_elapsed=$(echo "$((now-$timer))")
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

eraseScreen() {
  local COLOR=`printf '\\\\x00\\\\x00\\\\x00\\\\x00%0.s' $(seq 1 $WIDTH)`
  for i in $(seq 0 $HEIGHT | shuf); do printf $COLOR | dd bs=1 seek=$(( WIDTH * i )) of=/dev/fb0 >/dev/null 2>&1; done
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

loadSettings() {
  while read line; do
    key=$(echo "$line" | cut -d= -f1)
    val=$(echo "$line" | cut -d= -f2- | sed "s/'//g")
    declare -g "${key}"="$val"; #echo "$key = $val"
  done< <(sed -n '/# GLOBAL\|# GAMES/,/# EOF_GLOBAL\|# EOF_GAMES/ { /^page.*$/d;/path$/d;s/#.*$//;/^\s*$/d; s/\s*$//; p }' "$assets_path/.settings")
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

editPages() {
  local entry=${indexes[$(( offset + active ))]}
  local items=$(sed "${entry}q;d" "$list_path" | awk -F'\[|\]' '{print $2}')

  pageEditor "$entry" "${items}"; init=1; makeList; markLine
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

Password() {
  local key=$(grep -w -m1 'admin_menu_pass' "$HOMEDIR/ADMIN/.sys/.settings" | cut -d\' -f2 | base64 -d)
  local input=''

  clear; printf "\n ${C}PASS: ${NC}"; tput sc; for (( len=0; len<${#key}; len++ )); do printf "${C}_${NC}"; done; tput rc

  while [[ ${#input} -lt ${#key} ]]; do c=$(readInput);
    [[ ${#c} -gt 0 ]] && case "$c" in 'ESC'|'S') break ;; *) input+=$(printf "${c:0:1}" | sed 's/E/A/; s/S/B/'); tput rc; printf "${C}*${NC}"; tput sc ;; esac
  done; echo ""
  [[ "${input}" == "${key}" ]] && exit 42
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

exitMenu() {
  local rc=0

  if [ $1 -gt 0 ]; then
    export NEWT_COLORS="$(cat $assets_path/config/whiptail_theme.cfg)"
    whiptail --title "Alert" --yesno "\nQuit Menu?" 10 17 2>&1 1>/dev/tty; rc=$?
    [[ $hide_term -eq 1 ]] && { sudo setterm --cursor off; }
  fi

  if [[ $rc -lt 1 ]]; then
    [[ $admin_user -eq 1 ]] && exit 0 || Password 2>&1 1>/dev/tty
  fi

  makeList; markLine; init=1;
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

exitFunc() {
  local signal=$1

  sudo rm "$assets_path/fb0.dump" &>/dev/null

  JOBS=($(jobs -p))
  [[ ${#JOBS[@]} -gt 0 ]] && sudo kill -9 "${JOBS[@]}" &> /dev/null

  if [[ $signal -ne 42 ]]; then
    echo "VFD 4  G O O D B Y E" > /tmp/serial.fifo
    sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --remove joystick
    #sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --mode term
    [[ $post_clear -gt 0 ]] && clear #{ eraseScreen; clear; }
    [[ $hide_term -eq 1 ]] && { stty -F /dev/tty1 sane; sudo setterm --cursor on; }
  fi

  export PS1="$PS1_STORED"
  exit $signal
}


#____________________________________________________________________________

# MAIN LOOP
Main
exit


#____________________________________________________________________________
