#!/bin/bash

# echo -e "x: $x"


SCRIPT=$(readlink -f "$0")
DIR=$(cd "$(dirname $SCRIPT)" && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)

assets_path="$DIR/.assets"
media_path="$assets_path/media"
list_path="$assets_path/list"
font="$assets_path/fonts/Calvin_S.flf"

width=$(echo "$(tput cols)"); [[ $(( width % 2 )) > 0 ]] && (( width-- )) #width=$(( width - 1 ))
height=$(echo "$(tput lines)");
maxPage=$(( height - 2 ));

declare -A pageTitles=();
declare -a pages=(); declare -a list=(); declare -a indexes=(); declare -a headers=(); declare -a offsets=()

titles_str=$(sed -n '/# GLOBAL\|# GAMES/,/# EOF_GLOBAL\|# EOF_GAMES/ { s/#.*$//; /^\s*$/d; /^page_titles/ { s/^[^=]*=//; s/\x27//g; s/\s*$//; p; q } }' "$assets_path/.settings")

header_height=0; pageIndex=0; vpos=0; total_files=0; offset=0
start_page='FAV'
page=''

# ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

header() {
  #local text=${@:-$(printf "$(figlet -w $width -c ${pageTitles[$page],,} -f $font)")}
  local text=$(printf "${headers[$pageIndex]}")

  clear; tput cup 0 0; echo "${text}"; vpos=$header_height; #(( vpos++ ))
  tput cup $vpos 0; for i in $(seq 0 $(( width-1 ))); do printf "."; done; printf "\n"; (( vpos+=2 ));
  tput cup $vpos 0; tput sc
  maxPage=$(( maxPage - $vpos ))
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

footer() {
  local msg="$((${offset/-/}+1)) / ${#offsets[@]} "
  tput sc; tput cup $(tput lines) 0; printf "${pageTitles[$page]}"; tput rc
  tput sc; tput cup $(tput lines) $(( $(tput cols)-$((${#msg}+1)) )); printf "${msg}"; tput rc

  #tput sc; tput cup $(tput lines) 0; printf "${C}${pageTitles[$page]}${NC}"; tput rc
  #tput sc; tput cup $(tput lines) $(( $(tput cols)-$((${#msg}+1)) )); printf "${msg}"; tput rc
}
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

createHeaders() {
  for p in $(seq 0 $(( ${#pages[@]}-1))); do
    local str=$(printf "${pageTitles[${pages[$p]}]}" | sed 's/8/B/g; s/0/O/g')
    local text=$(printf "$(figlet -w $width -c ${str,,} -f $font)")
    headers+=("$(printf "${text}")");
    [ $header_height -eq 0 ] && { header_height="$( echo "${headers[-1]}" | wc -l)"; } #maxPage=$(( maxPage - ( $header_height + 2 ) )); }
    #[ $header_height -eq 0 ] && { header_height=$(( "$( echo "${headers[-1]}" | wc -l )" + 2 )); } #maxPage=$(( maxPage - ( $header_height + 2 ) )); }
    #[ $header_height -eq 0 ] && { header_height="$( echo "${headers[-1]}" | wc -l)"; maxPage=$(( maxPage - ( $header_height + 2 ) )); }
 done
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

sortPages() { pages=();
  for i in $(seq 1 $#); do [[ "${!i}" == $start_page ]] && { shift $((i-1)); break; } || pages+=("${!i}"); done; pages=( "${@}" "ALL" "${pages[@]}" )
  for p in $(seq 0 $(( ${#pages[@]}-1))); do [[ "${pages[$p]}" == "${start_page}" ]] && { pageIndex=$p; page="${pages[$pageIndex]}"; echo "start_page: $page"; }; done
}
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

setPage() {
  #header
  [[ $page == ALL ]] && pg=' ' || pg="$page"
  indexes=($(cat "$list_path" | awk -F'\[|\]' -v p="$pg" '$2 ~ p {split($0,i," "); print i[1]}')); total_files=${#indexes[@]};
  offsets=($(for (( x=0; x<${#indexes[@]}; x+=$maxPage )); do echo $x; done)); offset=0
  clear; header; makeList
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

makeList() {
  offset=$(( offset % ${#offsets[@]} ));
  active=0; list=()

  for (( x=${offsets[$offset]}; x<$(( ${offsets[$offset]}+maxPage )); x++ )); do
    [[ $x -ge $total_files ]] && break;
    title=$(sed "${indexes[$x]}q;d" "$list_path" | cut -d\' -f4 | awk -F'  |\(' '{if (NF < 3){ print $1 } else { print $1,"("$3}}')
    list+=("$title")
  done

  clear; header

  for (( i=0; i<${#list[@]}; i++ )) ; do echo "${list[$i]}"; done
  #debug "offset: $((${offset/-/}+1)) / ${#offsets[@]}"
  footer
}


# ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

while read line; do key="${line%%=*}"; str="${line##*=}"; pageTitles["${key}"]="${str//\"/}"; done< <(echo "$titles_str" | sed 's/[,]/\n/g' | awk '{$1=$1;print}')
declare -ag pages=($(sed -n '/\[ \([^]]*\) \]/ { s/.*\[ \([^]]*\) \].*/\1/; s/ /\n/g;/^$/d; p }' $list_path | sort -u))

sortPages "${pages[@]}"; echo -e "pages:"; for pg in "${pages[@]}"; do echo "${pg} - title: ${pageTitles[$pg]}"; done;
createHeaders

#sleep 1; clear; echo "maxPage(1): $maxPage"

#header; sleep 1; echo "vpos: $vpos"; echo "maxPage(2): $maxPage"

setPage; sleep 1 #for ofs in ${offsets[@]}; do echo "$ofs"; done; echo "page: $page"










