#!/bin/bash

SCRIPT=$(readlink -f "$0"); PID=$$
DIR=$(cd "$(dirname $SCRIPT)" && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)

cafca_dir="$HOMEDIR/CAFCA"
state_file="$cafca_dir/.states"

[[ $# -lt 1 ]] && exit

key="${1}"
threshold=10

T_LAST=$(cat "$cafca_dir/data/credits.log" | grep ':' | grep -wi -m1 'T' | cut -d\: -f2)
T=$(echo $(( 10#$(date +%s) )))
ELAPSED=$(( T - T_LAST ))

GAME_READY=$(grep -w -m1 "GAME_READY" "$cafca_dir/data/.states" | cut -d= -f2)

[[ $GAME_READY -eq 0 ]] && exit

# ----------------------------------------------------------------------------------------

getLoadTime() {
  local timer_file="$cafca_dir/data/tmp/start_time"
  local T_LOAD=$(cat "$timer_file")
  local ELAPSED=$(( T - T_LOAD )); [[ $ELAPSED -eq 1 ]] && ELAPSED=2
  local GAME=$(grep 'ACTIVE_GAME' "$cafca_dir/data/.settings" | cut -d\' -f2 | cut -d/ -f2)
  local SYSTEM=$(grep 'ACTIVE_GAME' "$cafca_dir/data/.settings" | cut -d\' -f2 | cut -d/ -f1)
  local T_STORED=$(grep -w -m1 "^$GAME" "$cafca_dir/data/${SYSTEM}/timers" | grep -o '[^ ]*$')

  #[[ $T_STORED -lt 0 ]] && sed -i "/^$GAME/ s/\(.\)$/${ELAPSED}/g" "$cafca_dir/data/${SYSTEM}/timers"
  [[ $T_STORED -lt 0 ]] && sed -i "/^$GAME/ s/\(-[0-9]*\)$/${ELAPSED}/g" "$cafca_dir/data/${SYSTEM}/timers"
  echo "$ELAPSED" >> "$timer_file"
}

# ----------------------------------------------------------------------------------------

c=$(cat "$cafca_dir/data/credits.log" | grep ':' | grep -wi -m1 'C' | cut -d\: -f2)
s=$(cat "$cafca_dir/data/credits.log" | grep ':' | grep -wi -m1 'S' | cut -d\: -f2)

if   [[ "${key,,}" == c ]]; then
  c=$(( c + 1 ));
  sed -i 's/C[:].*$/C:'"$c"'/I' "$cafca_dir/data/credits.log"
elif [[ "${key,,}" == s ]]; then
  if [[ "$c" -gt 0 ]] && [[ "$ELAPSED" -gt $threshold ]]; then
    s=$(( s + 1 ))
    sed -i 's/S[:].*$/S:'"$s"'/I' "$cafca_dir/data/credits.log"
    sed -i 's/T[:].*$/T:'"$T"'/I' "$cafca_dir/data/credits.log"
  fi
fi

if [[ "$s" -le "$c" ]] && [[ "$c" -gt 0 ]]; then
  x=$(( c - s ))
  sed -i 's/X[:].*$/X:'"$x"'/I' "$cafca_dir/data/credits.log"
fi

[[ $c -eq 1 ]] && getLoadTime 2>/dev/null

exit
