#!/bin/bash

ARG="$@"
SCRIPT=$(readlink -f "$0"); PID=$$
DIR=$(cd "$(dirname $SCRIPT)" && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)

assets_path="$HOMEDIR/ADMIN/MENU/.assets"
index="$assets_path/index"

declare -g MENU_W=$(( $(cat /sys/class/graphics/fb0/virtual_size | cut -d, -f1) / 10 ))
declare -g MENU_H=$(( $(cat /sys/class/graphics/fb0/virtual_size | cut -d, -f2) / 12 ))

level=0; offset=1; start=0; choice='0: '; level_index=''; nav_string=''

declare -a entries=()
declare -a last_items=()

source "$assets_path/helpers/commands.sh"; commands_set_globals

# ------------------------------------------------------------------------------------------------------------

Menu() {
  level_index=$(grep -v '^$\|^\s*#' $index | grep -Pn "^(\t){$level}[[:graph:]].*$")
  items=$(echo "$level_index" | awk -F: -v n="$start" '{if ($1 > n ) { if ( $2 ~ "@" ) { exit } else { print }}}')
  entries=()

  for n in $(seq 1 $(echo "$items" | wc -l)); do
    item=$(echo "$items" | awk -v n="$n" 'NR==n' | sed 's/\t//g;s/\(.*\)://g' | sed '/\]$/! s/$/ >/g;/\]$/ s/[][]\(.*\)//g')
    entries+=("$n" "$item")
  done

  offset=$( whiptail --title "A R C A N G E L" --menu "$(navString)" $MENU_H $MENU_W 8 "${entries[@]}" 3>&2 2>&1 1>&3 ); exit_code=$?

  [[ $exit_code -gt 0 ]] && [[ $level -lt 1 ]] && exit

  if [[ $offset -le $(echo "$items" | wc -l) ]]; then
    if [[ ${#offset} -gt 0 ]]; then
      if [[ ! $(echo "$items" | awk -v n="$offset" 'NR==n' | sed 's/\t//g') =~ .*"[".* ]]; then
        (( level++ ))
        last_items[$level]="$choice"; choice=$(echo "$items" | awk -v n="$offset" 'NR==n' | sed 's/\t//g')
      else
        line=$(echo "$items" | awk -v n="$offset" 'NR==n' | sed 's/\t//g');
        id=$(echo "${line##*:}" | sed 's/[][]\(.*\)//g')
        cmd=$(echo "${line##*:}" | sed 's/^.*\[\(.*\)\].*$/\1/;s/\x27//g' | cut -d' ' -f1)
        params=$(echo "${line##*:}" | sed 's/^.*\[\(.*\)\].*$/\1/;s/\x27//g' | cut -d' ' -f2-)

        runCmd "$cmd" "$params"

      fi
    else
      choice="${last_items[$level]}"
      unset last_items[$level]
      (( level-- ))
    fi
    start=${choice%%:*}
  fi
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

runCmd() {
  local ARGS=("${@}")
  local CMD="${ARGS[0]}"; local params="${ARGS[@]:1}"

  [ ${#CMD} -lt 1 ] && return
  clear

  [ ! -z $CMD ] && [[ "${commands[@]}" =~ "$CMD" ]] && $cmd "${params}" 3>&1 1>&2 2>"$DIR/.log/errors.log" #|| { echo "command '$CMD' not found."; sleep 1; }

  checkErrors
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

checkErrors() {
  local errors=$(cat "$DIR/.log/errors.log" | wc -l)
  [[ $errors -gt 0 ]] && whiptail --msgbox "$(echo -e "ERRORS:\n"; cat $DIR/.log/errors.log)" 0 0 2>&1 1>/dev/tty
  printf '' > "$DIR/.log/errors.log"
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

navString() {
 nav_string="$(echo -e '\nMENU ')"

 if [[ $level -gt 0 ]]; then
   nav_string+="> "
   for i in "${last_items[@]:2}"; do nav_string+="$( echo "${i##*:}" | sed 's/ //g') > "; done
   nav_string+="${choice##*:}"
 fi
 echo "$nav_string"
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

loadSettings() {
  while read line; do
    key=$(echo "$line" | cut -d= -f1)
    val=$(echo "$line" | cut -d= -f2- | sed "s/'//g")
    declare -g "${key}"="$val"; #echo "$key : $val"
  done< <(sed -n '/# GLOBAL\|# MAIN/,/# EOF_GLOBAL\|# EOF_MAIN/ { s/#.*$//; /^\s*$/d; p }' "$assets_path/.settings")
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

exitFunc() {
  local signal=$1

  [ -f "$HOMEDIR/.dialogrc" ] && sudo rm "$HOMEDIR/.dialogrc"

  JOBS=($(jobs -p))
  [[ ${#JOBS[@]} -gt 0 ]] && sudo kill -9 "${JOBS[@]}" &> /dev/null

  sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --remove joystick;
  #sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --mode term

  [[ $TERM == linux ]] && echo -en "\e]P700FC00" #[[ $TERM == linux ]] && export PS1="$(cat /boot/sys_settings | grep -w -m1 'VAR PS_str' | cut -d\' -f2)" #export PS1="$PS1_STORED"

  echo "VFD 4  G O O D B Y E" > /tmp/serial.fifo

  export PS1="$PS1_STORED"
  stty -F /dev/tty1 sane ; sudo setterm --cursor on

  clear
  exit $signal
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

Init() {
  sudo -u pi bash -c "dialog --create-rc /home/pi/.dialogrc; cp -f /home/pi/ADMIN/MENU/.assets/config/.dialogrc /home/pi/.dialogrc"

  local boot_games_menu=$(grep -w -m1 'boot_games_menu' "$HOMEDIR/ADMIN/.sys/.settings" | cut -d= -f2)

  if [[ "${ARG^^}" == BOOT ]]; then
    [[ $boot_games_menu -eq 1 ]] && [[ "${commands[@]}" =~ run_games_menu ]] && run_games_menu BOOT
  fi
  loadSettings

  [[ $mono_colors -eq 1 ]] && export NEWT_COLORS="$(cat $assets_path/config/whiptail_theme.cfg)"
  [[ $TERM == linux ]] && echo -en "\e]P7C0C0C0"

  trap '[[ $? -eq 42 ]] && exitFunc 42 || exitFunc 0' EXIT; trap 'exit 1' INT HUP SIGINT SIGHUP TERM

  sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --grab joystick; sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --mode admin

  #printf %x 159)%0.s" $(seq 1 16))" > /tmp/serial.fifo
  printf '' > "$DIR/.log/errors.log"

  clear
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


Init

while true; do Menu; done

exit
















# ------------------------------------------------------------------------------------------------------------

# ORIGINAL

clear

while true; do
  level_index=$(grep -Pn "^(\t){$level}[[:graph:]].*$" $index)
  items=$(echo "$level_index" | awk -F: -v n="$start" '{if ($1 > n ) { if ( $2 ~ "@" ) { exit } else { print }}}')
  entries=()

  for n in $(seq 1 $(echo "$items" | wc -l)); do
    item=$(echo "$items" | awk -v n="$n" 'NR==n' | sed 's/\t//g;s/\(.*\)://g' | sed '/\]$/! s/$/ >/g;/\]$/ s/[][]\(.*\)//g')
    entries+=("$n" "$item")
  done

  offset=$( whiptail --title "MENU" --menu "$(echo $choice | cut -d: -f2-)" 0 0 4 "${entries[@]}" 3>&2 2>&1 1>&3 ); exit_code=$?

  [[ $exit_code -gt 0 ]] && [[ $level -lt 1 ]] && exit

  if [[ $offset -le $(echo "$items" | wc -l) ]]; then
    if [[ ${#offset} -gt 0 ]]; then
      if [[ ! $(echo "$items" | awk -v n="$offset" 'NR==n' | sed 's/\t//g') =~ .*"[".* ]]; then
        (( level++ ))
        last_items[$level]="$choice"
        choice=$(echo "$items" | awk -v n="$offset" 'NR==n' | sed 's/\t//g')
      else
        line=$(echo "$items" | awk -v n="$offset" 'NR==n' | sed 's/\t//g')
        id=$(echo "${line##*:}" | sed 's/[][]\(.*\)//g')
        cmd=$(echo "${line##*:}" | sed 's/^.*\[\(.*\)\].*$/\1/')
        echo -e "\nCOMMAND: '$id':$cmd\n"; exit
      fi
    else
      choice="${last_items[$level]}"
      (( level-- ))
    fi
    start=${choice%%:*}
  fi
done

exit

