#!/bin/bash

ARG="$@"; PID=$$; PS1_STORED=$PS1

UNMARK="$(echo -e "\e[0m")"
  MARK="$(echo -e "\e[7m")"
    NC="$(echo -e "\033[0m")"
     C="$(echo -e "\033[32m")"

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# PATHS

SCRIPT=$(readlink -f "$0")
DIR=$(cd "$(dirname $SCRIPT)" && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)

assets_path="$DIR/.assets"
media_path="$assets_path/media"
list_path="$assets_path/list"
font="$assets_path/fonts/Calvin_S.flf"

serial_path=$(sed -n '/fifo_com/ { s/\(.*\)=//g; s/\x27//g; p }' "$HOMEDIR/ADMIN/.sys/.settings")
roms_path=$(grep -w -m1 'dir_roms' "$HOMEDIR/ADMIN/.sys/.settings" | cut -d\' -f2)

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

width=$(echo "$(tput cols)"); [[ $(( width % 2 )) > 0 ]] && (( width-- ))
height=$(echo "$(tput lines)"); maxPage=$(( height - 3 ));

declare -A pageTitles=();
#declare -a pages=(); declare -a list=(); declare -a indexes=();

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# REM ?

debug=0

HEIGHT=$(cat /sys/class/graphics/fb0/virtual_size | cut -d, -f2)
WIDTH=$(cat /sys/class/graphics/fb0/stride)

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

Init() {
  loadSettings

  for arr in pages list indexes offsets headers; do declare -ag "${arr}"; done
  for var in navigated idle_count pageIndex page offset active prev total_files vpos header_height; do declare -g "${var}"=0; done

  createPages

  [[ $remap -eq 1 ]] && { declare -Ag remaps=(); for rmp in `echo ${remapping}`; do remaps["${rmp%%=*}"]="${rmp##*=}"; done; }
  [[ $hide_term -eq 1 ]] && { PS1=; stty -F /dev/tty1 -echo; sudo setterm --cursor off; }

  [ ! -f "$assets_path/fb0.dump" ] && { touch "$assets_path/fb0.dump"; for fb in $assets_path/fb0.dump; do touch $fb; chmod 775 $fb; chown pi:root $fb; done; }

  trap 'exitFunc' EXIT; trap 'exit 1' INT HUP SIGINT SIGHUP TERM
  sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --mode menu; sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --grab joystick

  sendSerial "VFD 1 $( (( test_mode )) && echo 'EDIT MODE' || echo 'GAMES MENU' )"
  debug "\npage: $pageIndex - $page (${pageTitles[$page]})\n" #"maxPage: $maxPage\n"
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

Main() {
  Init
  setPage

  while true; do
    input=$(readInput)

    if [[ ${#input} -gt 0 ]]; then
      navigate "${input}"
    else (( idle_count++ ));
      [[ $idle_count -gt $(( t_title * 10 )) ]] && [[ $navigated -eq 1 ]] && { showTitle; navigated=0; }
    fi
  done
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

navigate() {
  local key="${@}"
  [[ $remap -eq 1 ]] && [[ ! -z "${remaps[$input]}" ]] && key="${remaps[$input]}"

  if [[ $test_input -lt 1 ]]; then
    case "${key}" in
      'UP')     prev=$active; (( active-- )); checkList; navigated=1 ;;
      'DOWN')   prev=$active; (( active++ )); checkList; navigated=1 ;;
      'LEFT')   (( pageIndex-- )); changePage ;;
      'RIGHT')  (( pageIndex++ )); changePage ;;
      'PGUP')   [[ ${#offsets[@]} -gt 1 ]] && { (( offset-- )); makeList; drawScreen; navigated=1; } ;;
      'PGDOWN') [[ ${#offsets[@]} -gt 1 ]] && { (( offset++ )); makeList; drawScreen; navigated=1; } ;;
      'ENTER')  ;;
      'START')  ;;
      'SPACE')  ;;
      'ESC')    ;;
    esac
  else debug "$input -> $key";
  fi

  idle_count=0; title_shown=0
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

makeList() {
  [[ $show_header -eq 1 ]] && header

  offset=$(( offset % ${#offsets[@]} ))
  list=(); active=0

  for x in $(seq ${offsets[$offset]} $(( (${offsets[$offset]} + maxPage)-1 ))); do
    [[ $x -ge $total_files ]] && break;
    title=$(sed "${indexes[$x]}q;d" "$list_path" | cut -d\' -f4 | awk -F'  |\(' '{if (NF < 3){ print $1 } else { print $1,"("$3}}')
    list+=("$title")
  done

  for i in $(seq 0 $(( ${#list[@]}-1 ))); do printer "${list[$i]}" 0; done

  [[ $show_footer -eq 1 ]] && footer
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

checkList() {
  if [[ $active -lt 0 ]]; then
    [[ ${#offsets[@]} -gt 1 ]] && { (( offset-- )); makeList; active=$((${#list[@]}-1)); } || { active=0; }
  elif [[ $active -ge ${#list[@]} ]]; then
    [[ ${#offsets[@]} -gt 1 ]] && { (( offset++ )); makeList; active=0; } || { active=${#list[@]}; }
  fi

  drawScreen
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

drawScreen() {
  tput sc; tput cup $(( vpos + prev )) 0;   printer "${list[$prev]}" 0; tput rc
  tput sc; tput cup $(( vpos + active )) 0; printer "${list[$active]}" 1; tput rc
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

changePage() {
  pageIndex=$(( pageIndex % ${#pages[@]} )); page="${pages[$pageIndex]}"
  sendSerial "VFD 3 ${pageTitles[$page]}"
  setPage; navigated=0;
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

setPage() {
  [[ $page == ALL ]] && pg=' ' || pg="$page"
  indexes=($(cat "$list_path" | awk -F'\[|\]' -v p="$pg" '$2 ~ p {split($0,i," "); print i[1]}')); total_files=${#indexes[@]};
  offsets=($( for x in $(seq 0 $maxPage $(( ${#indexes[@]} - 1))); do echo $x; done)); offset=0

  makeList; drawScreen
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

sortPages() { pages=();
  for i in $(seq 1 $#); do [[ "${!i}" == $start_page ]] && { shift $((i-1)); break; } || pages+=("${!i}"); done; pages=( "${@}" "ALL" "${pages[@]}" )
  for p in $(seq 0 $(( ${#pages[@]}-1))); do [[ "${pages[$p]}" == "${start_page}" ]] && { pageIndex=$p; page="${pages[$pageIndex]}"; }; done
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

createPages() {
  local key=; local str=; local text=;

  while read line; do key="${line%%=*}"; str="${line##*=}"; pageTitles["${key}"]="${str//\"/}"; done< <(sed -n '/# GLOBAL\|# GAMES/,/# EOF_GLOBAL\|# EOF_GAMES/ { s/#.*$//; /^\s*$/d; /^page_titles/ { s/^[^=]*=//; s/\x27//g; s/\s*$//; p; q } }' "$assets_path/.settings" | sed 's/[,]/\n/g' | awk '{$1=$1;print}')
  declare -ag pages=($(sed -n '/\[ \([^]]*\) \]/ { s/.*\[ \([^]]*\) \].*/\1/; s/ /\n/g;/^$/d; p }' $list_path | sort -u));

  sortPages "${pages[@]}"

  for p in $(seq 0 $(( ${#pages[@]}-1))); do
    str=$(printf "${pageTitles[${pages[$p]}]}" | sed 's/8/B/g; s/0/O/g'); text=$(printf "$(figlet -w $width -c ${str,,} -f $font)"); headers+=("$(printf "${text}")");
    [ $header_height -eq 0 ] && { header_height="$( echo "${headers[-1]}" | wc -l)"; maxPage=$(( maxPage - ( $header_height + 2 ) )); }
  done
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

printer() {
  [[ $# -lt 1 ]] && return
  txt="${1}"; pad=''; str=''; mark="${2:-0}" #; mid="${3:-$center}";

  [[ $colors -gt 0 ]] && str="${C}";
  str+="${txt}"; strlen=${#str}

  if [[ $center -gt 0 ]]; then
    [[ $(( strlen % 2 )) > 0 ]] && strlen=$(( strlen - 1 ))
    strlen=$(( strlen / 2 )); length=$(( width / 2 )); length=$(( length - strlen ))
    printf -v pad '%*s' "$length"
  fi

  [[ $mark -gt 0 ]] && str="${MARK}${str}${UNMARK}"; str="${pad}${str}";
  [[ $colors -gt 0 ]] && str+="${NC}"

  echo -e "${str}"
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

header() {
  local text=$(printf "${headers[$pageIndex]}"); [[ $colors -gt 0 ]] && text=${C}${text}${NC}
  local line=$(printf "$(for i in $(seq 0 $(( width-1 ))); do printf '.'; done)"); [[ $colors -gt 0 ]] && line=${C}${line}${NC}

  clear
  tput cup 0 0; echo "${text}"; vpos=$header_height
  tput cup $vpos 0; printf "${line}"; (( vpos+=2 ))
  tput cup $vpos 0; tput sc
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

footer() {


  local msg="${page}: $total_files GAMES"
  local line=$(printf "$(for i in $(seq 0 $(( width-1 ))); do printf '.'; done)")
  local info=$(echo "$(for x in $(seq 0 ${#offsets[@]});do [[ ${offsets[$x]} =~ ${offsets[$offset]} ]] && { echo $((x+1));break; };done) / ${#offsets[@]}")
  local spacing=$(( ${#info}+1 ))
  local bottom=$(( $(tput lines)-3 ))

  [[ $colors -gt 0 ]] && { info=${C}${info}${NC}; msg=${C}${msg}${NC}; line=${C}${line}${NC}; }

  tput sc; tput cup $bottom 0; echo "${line}"
  tput cup $((bottom+1)) 0; printf "${msg}"
  tput cup $((bottom+1)) $(( width-spacing )); printf "${info}";
  tput rc
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

readInput() {
  Event=''
  read -rs -N 1 -t 0.1 Event1 >/dev/null #-u 6 Event1 6<$(tty) >/dev/null

  [[ $? -gt 127 ]] && return

  case "$Event1" in
    $'\163')        Event="START" ;;
    $'\n')            Event="ENTER"   ;;
    ' ')              Event="SPACE"   ;;
    [[:blank:]])      Event="TAB"     ;;
    *)
      read -rsn5 -t 0.01 Event2 >/dev/null #-u 6 Event2 6<$(tty) >/dev/null

      case "$Event2" in
        "[A")         Event="UP"      ;;
        "[B")         Event="DOWN"    ;;
        "[D")         Event="LEFT"    ;;
        "[C")         Event="RIGHT"   ;;
        "[5~")        Event="PGUP"    ;;
        "[6~")        Event="PGDOWN"  ;;
        "OS"|"[[D")   Event="F4"      ;;
        *)
          case "$Event1$Event2" in
            $'\E')    Event="ESC"     ;;
          esac
          ;;
      esac
  esac

  printf "${Event}"
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

loadSettings() {
  debug "\nSETTINGS:"
  while read line; do
    key=$(echo "$line" | cut -d= -f1)
    val=$(echo "$line" | cut -d= -f2- | sed "s/'//g")
    declare -g "${key}"="$val"
    debug " - $key = $val"
  done< <(sed -n '/# GLOBAL\|# GAMES/,/# EOF_GLOBAL\|# EOF_GAMES/ { /^page.*$/d; /path$/d; s/#.*$//;/^\s*$/d; s/\s*$//; p }' "$assets_path/.settings")
  debug ""
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

showTitle() {
  local title="TITLE"
  #sendSerial "VFD 3 $title"
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

sendSerial() {
  [ $# -ge 1 ] && echo -e "$@" > $serial_path || return
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

debug() { [[ $debug -eq 1 ]] && echo -e "$@"; }

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

exitFunc() {
  local signal=$1
  local JOBS=($(jobs -p)); [[ ${#JOBS[@]} -gt 0 ]] && sudo kill -9 "${JOBS[@]}" &> /dev/null

  sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --remove joystick #; sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --mode term

  [[ $hide_term -eq 1 ]] && { stty -F /dev/tty1 sane; sudo setterm --cursor on; }
  [[ $post_clear -eq 1 ]] && { clear; tput cup 0 0; tput sc; }

  export PS1="$PS1_STORED"; exit $signal
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

Main
exit

# ________________________________________________________________________________________________________________________________________________________________________________________________________

