#!/bin/bash

settings='/home/pi/ADMIN/.sys/.settings'
arg=

[[ ${#} -gt 0 ]] && arg=$(echo "${@}" | tr '[:upper:]' '[:lower:]')

main() {
  [[ $arg == overscan ]] && overscan_toggle
}

overscan_toggle() {
  state=$(grep overscan "$settings" | cut -d= -f2)

  sudo cp -f /boot/config.txt /boot/config.txt.bak && sleep 1

  if [[ $state -gt 0 ]]; then
    new_state=0
    str_in='overscan_'; str_out='#overscan_'
  else
    new_state=1
    str_in='#overscan_'; str_out='overscan_'
  fi

  echo -e "\nSet overscan to $new_state and reboot?\n(y/Y to confirm)"

  read -srN1 choice

  case $choice in
    [yY])
      sed -i "/overscan/ s|overscan=$state|overscan=$new_state|" "$settings"
      sed -i "/overscan_/ s|$str_in|$str_out|" /boot/config.txt

      echo -e "\nRebooting.."
      sleep 1
      reboot
      ;;
    *)
      echo -e "\nUser cancelled.."
      ;;
  esac
}

#overscan_toggle() {
#  overscan_state=$(grep overscan "$settings" | cut -d= -f2)
#
#  sudo cp -f /boot/config.txt /boot/config.txt.bak && sleep 1
#
#  if [[ $overscan_state -gt 0 ]]; then
#    sed -i "/overscan_/ s|overscan_|#overscan_|" /boot/config.txt
#    sed -i "/overscan/ s|overscan=1|overscan=0|" "$settings"
#  else
#    sed -i "/overscan_/ s|#overscan_|overscan_|" /boot/config.txt
#    sed -i "/overscan/ s|overscan=0|overscan=1|" "$settings"
#  fi
#}

main
