#!/bin/bash

HOMEDIR=$(getent passwd pi | cut -d: -f6)
SCRIPT=$(readlink -f "$0")
DIR=$(cd "$(dirname $SCRIPT)" && pwd)

# ----------------------------------------------------------------

cleanKill() {
  trap_cmds=($(trap -l | awk '{print $0"\t"}' | awk 'BEGIN{RS="\t"}{$1=$1}1' | grep -o '[^ ]*$')); trap_cmds[130]='EXIT'; #echo "${trap_cmds[$1]}"
  exit 0;
}

trap 'cleanKill $?' EXIT INT SIGINT

# ----------------------------------------------------------------
# SET VARS:

names=('' 'action' 'target' 'second' 'param'); name=''
for (( i=1; i<=$#; i++ )); do var="$(eval echo \${$i#--})"; declare "${names[$i]}"="${var,,}"; done

while read line; do
  n=$(echo "$line" | cut -d= -f1); p=$(echo "$line" | cut -d\' -f2); declare "${n}"="${p}"
  [[ $(echo ${p,,} | grep -wc $target) -gt 0 ]] && name="$n"
done< <(cat "$HOMEDIR/ADMIN/.sys/.settings" | cut -d' ' -f2- | grep -Ew '^teensy|^joystick|^gun|^udev')

if [[ $action == @(add|remove|grab) ]]; then
  [[ $action == grab ]] && { action='add'; grab=1; }
  [[ "$target" == @(teensy|joystick|gun|udev) ]] && { name="$target" ; target=$(eval echo \${$target}); }
  ! ( [[ $second == tag ]] && [[ ${#param} -gt 0 ]] ) && { second='tag'; param="$name"; }
fi

# ----------------------------------------------------------------
# TH-CMD:

cmd='sudo th-cmd --socket /run/thd.socket '

[[ $grab -gt 0 ]] && cmd+="--grab "
[[ ${#action} -gt 0 ]] && [[ ${#target} -gt 0 ]] && cmd+="--$action $target "
[[ ${#second} -gt 0 ]] && [[ ${#param} -gt 0 ]]  && cmd+="--$second $param "

sudo bash -c "$cmd"

# ----------------------------------------------------------------
# LOG:

cmd="`date '+%F %T'` : $cmd"
sudo sed -n -i "p;1a ${cmd}" "$DIR/states.log"


#cat "$DIR/states.log" | sort -n --output="$DIR/states.log"
#echo "$(date '+%F %T') : $cmd" >> "$DIR/states.log"
#cat "$DIR/states.log" | sort -nr --output="$DIR/states.log"

declare -A MODES=( ["none"]=0 ["term"]=1 ["es"]=2 ["menu"]=2 ["admin"]=2 ["game"]=3 ["mc"]=4 )

if [[ $action == @(add|remove) ]]; then
  sed -i "/^\t${name}/d" "$DIR/devices.log"
  [[ $action == add ]] && { echo -e "\t${name} $([[ $grab -gt 0 ]] && echo '(grab)')" >> "$DIR/devices.log"; }
elif [[ $action == mode ]]; then
  sed -i 's|mode:[\t].*$|mode:\t'"$target"'|g' "$DIR/devices.log"
  [[ "${!MODES[@]}" =~ "${target}" ]] && { echo -e "UI ${MODES[$target]}" > /tmp/serial.fifo; }
fi

exit

# ----------------------------------------------------------------
