#!/bin/bash

list_path=/home/pi/ADMIN/MENU/.assets/list; pg=' '
declare -a indexes=($(cat "$list_path" | awk -F'\[|\]' -v p="$pg" '$2 ~ p {split($0,i," "); print i[1]}'))
declare -a offset=(0 16 32)
offset=0; active=${1:-0}

showMarquee() {
  local name=$(awk -F'\x27' -v l="${indexes[$((${offsets[$offset]}+active))]}" 'NR==l {print $2}' "$list_path")
  echo "NAME: '$name'"
}

showMarquee_bak() {
  local entry=$(( offset + active ))
  local idx=${indexes[$entry]}
  local name=$(awk -F'\x27' -v l="$idx" 'NR==l {print $2}' "$list_path")
  local file=$(find "$media_path/marquees" -type f -iname "$name*.ppm" -print -quit)

  if [ -f "$file" ] && [[ $show_marquee -gt 0 ]]; then
    H="${file##*/}"; H="${H/.*/}"; H="${H##*_}"; PAD=$(( (HEIGHT - H) / 2 ))
    sudo cat /dev/fb0 > "$assets_path/fb0.dump" & wait $!
    ( dd if="$file" bs=1 skip=$(( WIDTH * PAD )) count=$(( WIDTH * H )) iflag=skip_bytes,count_bytes | dd seek=$(( WIDTH * PAD )) oflag=seek_bytes of=/dev/fb0 ) >/dev/null 2>&1
  fi
}

title=$(awk -F'\x27' -v l="${indexes[$((${offsets[$offset]}+active))]}" 'NR==l {split($4,t," - "); print t[1],"("$6")","["$8"]"}' "$list_path")
echo "TITLE: '$title'"
showMarquee
