#!/bin/bash

[[ $# -lt 2 ]] && exit 1
action="${1,,}"; param=''

#declare -Ag modes=( ["none"]=0 ["term"]=1 ["menu"]=2 ["game"]=3 )
declare -Ag modes=( ["none"]=0 ["term"]=1 ["menu"]=2 ["game"]=3 ["slide"]=4)

dir=$(dirname "$0")
home_dir='/home/pi'
sys_dir="$home_dir/ADMIN/.sys"
boot_mode=$(cat "$sys_dir/.settings" | grep -w -m1 'boot_mode' | cut -d\' -f2)
joy_dev=$(cat "$sys_dir/.settings" | grep -w -m1 'DEV joystick' | cut -d\' -f2)
log="$home_dir/ADMIN/.log/_states.log"
err_log="$dir/err.log"
dump="$dir/dump"
device_logger="$dir/thd_devices.sh"
device_log="$home_dir/ADMIN/.log/_thd_devices.log"

valid=0; mode=

exec 1>> "$log" 2> "$err_log"

if [[ $action  == device ]]; then
  echo -e "$(date +%F' '%T):\n"; #echo -e ':\n'
  param=("${@:2}")
  #read th_cmd_out< <(sudo bash "$device_logger" "${param[@]}"); echo "    $(echo $th_cmd_out | sed 's/sudo th-cmd //g')"
  sudo bash "$device_logger" "${param[@]}"
elif [[ $action == mode ]]; then
  state="${2,,}"
  [[ $# -gt 2 ]] && param="${3}"
  [[ $# -gt 3 ]] && caller="${4}" || caller=''

  if [[ $state != sleep ]]; then
    echo -n "$(date +%F' '%T)";
    [[ ${#caller} -gt 0 ]] && echo -e " - ${caller}:\n" || echo -e ':\n'

    for k in "${!modes[@]}"; do [[ $state == "$k" ]] && valid=1; done
    [[ ${#param} -gt 0 ]] && [[ "${param}" == force ]] && valid=1
    [[ $valid -lt 1 ]] && { echo "INVALID STATE: $state"; exit 1; }

    mode="${modes[$state]}"
    [[ $mode -le 3 ]] && { echo -e "UI $mode" > /tmp/serial.fifo; sudo sed -i 's|UI[=].*$|UI='"$mode"'|g' "$sys_dir/.states"; }

    sudo th-cmd --socket /run/thd.socket --mode "$state"; echo -e "  th-cmd\n    --mode $state"

    if [[ $state == game ]]; then
      #read th_cmd_out< <(sudo bash "$device_logger" --remove "$joy_dev" --tag joy); echo "    $(echo $th_cmd_out | sed 's/sudo th-cmd //g')"
      sudo bash "$device_logger" --remove "$joy_dev" --tag joy
      sudo cp -r "$home_dir/CAFCA/data/.states.default" "$home_dir/CAFCA/data/.states"

      [[ ${#param} -gt 0 ]] && { \
        game=$(echo "$param" | awk -F/ '{split($NF,n,"."); print $(NF-1)"/"n[1]}'); \
        sudo sed -i 's|ACTIVE_GAME[=].*$|ACTIVE_GAME='"\x27$game\x27"'|g' "$home_dir/CAFCA/data/.states" ; \
      }
    elif [[ $state == menu ]]; then
      [[ $caller == ES ]] && joy_name='joy_es' || joy_name='joy'
      #sudo th-cmd --socket /run/thd.socket --grab --add "$joy_dev" --tag "$joy_name"
      read th_cmd_out< <(sudo bash "$device_logger" --grab --add "$joy_dev" --tag "$joy_name"); echo "    $(echo $th_cmd_out | sed 's/sudo th-cmd //g')"
    fi
  else # if $state == sleep
    if [[ $boot_mode == es ]]; then
      [[ ${#param} -gt 0 ]] && [[ "$param" =~ ^[0-9]+$ ]] && { \
        echo -e "ASLEEP ${param}" > /tmp/serial.fifo ; \
        sudo sed -i 's|ASLEEP[=].*$|ASLEEP='"${param}"'|g' "$sys_dir/.states" ; \
      }
    else
      echo -e "ASLEEP 1" > /tmp/serial.fifo; sed -i 's|ASLEEP[=].*$|ASLEEP=1|g' "$sys_dir/.states"
      while read c; do echo "$c" | sudo tee -a "$home_dir/wake_event" &> /dev/null && break; done< <( sudo thd --socket /run/thd.socket  --dump /dev/input/event*)
      echo -e "ASLEEP 0" > /tmp/serial.fifo; sed -i 's|ASLEEP[=].*$|ASLEEP=0|g' "$sys_dir/.states"
    fi
  fi
fi

#echo -e "\n$(cat $device_log)"
#[[ $(cat $err_log | wc -c) -gt 0 ]] && echo -e "\nerrors:\n$(cat $err_log)" | tee -a "$log" &> /dev/null

if [[ $(cat $err_log | wc -c) -gt 0 ]]; then
 echo -e "\n  errors:" | tee -a "$log" &> /dev/null
 while read line; do echo -e "    $line" | tee -a "$log" &> /dev/null; done< <(cat "$err_log")
fi

echo -e "\n--------------------------------------------------------------------------------\n"

lines=$(awk -v p="$(date '+%Y')" -v n="$(grep -c 2024 $log)" '$0~p{i++}i==n' "$log" | wc -l) &>/dev/null

touch "$dump" && printf '' | tee "$dump" &>/dev/null
cat "$log" | tail -n $lines | tee "$dump" &>/dev/null
cat "$log" | head -n -$lines | tee -a "$dump" &>/dev/null
cat "$dump" | tee "$log" &>/dev/null
rm "$dump" &> /dev/null

# --------------------------------------------------------------------------------------------
