#!/bin/bash

SCRIPT=$(readlink -f "$0"); PID=$$
DIR=$(cd "$(dirname $SCRIPT)" && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)

assets="$HOMEDIR/ADMIN/MENU/.assets"

export NEWT_COLORS="$(cat $assets/config/whiptail_theme.cfg)"

pageEditor() {
  #export NEWT_COLORS="$(cat $assets/config/whiptail_theme.cfg)"

  pages=(); choice="${1}"; items="${2}"
  name=$(sed -n "${choice}p" "$assets/list" | awk -F'\x27' '{print $2}')

  for line in `echo "$(grep -w -m1 '^pages*' $assets/.settings | cut -d\' -f2)"`; do
    [[ "${items}" =~ "$line" ]] && pages+=("$line" "" ON) || pages+=("$line" "" OFF)
  done

  settings=$( \
    whiptail \
      --title "    Toggle page filters    " \
      --checklist "\ngame: ${name}" 0 0 4 \
      "${pages[@]}" 3>&2 2>&1 1>&3 \
  )

  if [ $? -eq 0 ]; then
    settings=$(echo "$settings" | sed 's/\x22//g')
    sudo cp "$assets/list" "$assets/.list/list.bak$(date +%y%m%d%H%M%S)"
    sed -i "$choice s:\[.*\]:[ $settings ]:g" "$assets/list"
  fi
}


# ---------------------------------------------------------------------------------------------------------------------------

if [[ "${BASH_SOURCE[0]}" == "${0}" ]]; then
  entries=(); choices=(); count=0

  for i in $(seq 1 $(tput lines)); do
    line=$(sed "${i}q;d"  "$assets/list")
    name=$(echo $line | awk -F\' '{print $2," "}')
    str=$(echo $line | awk -F\' '{gsub(/\[\ /, "", $(NF-1));print "[ ALL",$(NF-1)," "}')
    entries+=("$(echo -n $name; printf '%*s' $(( $(tput cols) - ( ${#name} + ${#str} ) )); echo ${str})")
  done

  for entry in "${entries[@]}"; do
    line=$(echo "${entry}" | awk '{$1=$1;print}')
    choices+=("$count" "$(echo $line | awk -F'\[|\]' '{print $1}')"); (( count++ ));
  done

  choice=$(whiptail --title "Menu example" --menu "Choose an option" 16 0 16 "${choices[@]}" 3>&2 2>&1 1>&3)
  items=$(echo "${entries[$choice]}" | awk -F'\[|\]' '{print $2}'); (( choice++ ))

  pageEditor "$choice" "$items"
#else
#  [ $# -gt 1 ] && pageEditor "${1}" "${2}"
fi

#clear; { for ((n = 0 ; n <= 100 ; n+=5)); do sleep 0.1; echo $n; done; } | whiptail --gauge "Please wait while we are sleeping..." 6 50 0 #&
