#!/bin/bash

SCRIPT=$(readlink -f "$0")
DIR=$(cd "$(dirname $SCRIPT)" && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)
assets_path="$HOMEDIR/ADMIN/MENU/.assets"

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

exitFunc() {
  echo "VFD 3 SAVER END" > /tmp/serial.fifo
  sudo kill -9 $(jobs -p) > /dev/null 2>&1; wait
  sudo pkill -9 omxplayer > /dev/null 2>&1
  echo "$1" > "$assets_path/saver/exit_code"
  exit $1
}

trap '[[ $? -eq 42 ]] && exitFunc 42 || exitFunc 0' EXIT; trap 'exit 1' INT HUP SIGINT SIGHUP TERM

source "$assets_path/saver/.source.sh"

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

fbSaver() {
  terminalLines GREEN; sleep 1
  drawStatic 50
  drawRGBLines
  fillScreenLines $BLACK; clearBuffer
  fullColorRandom
  fillScreenLines $BLACK; clearBuffer
  tilesThin 8
  fillScreenLines $BLACK; clearBuffer
  tiles
  fillScreenLines $BLACK; clearBuffer
  drawColumns
  fullColorRandom
  gradients
  vapor
  vertRandLines
  scanlines_thick
  fillScreenLines
  vaporGlitch
  fillScreenLines $BLACK
  clearBuffer
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

videoSaver() {
  local video_path=$(sed -n '/# GLOBAL\|# MAIN/,/# EOF_GLOBAL\|# EOF_MAIN/ { /^vidsaver_path/ { s/.*=//; s/\x27//g; s/#.*$//; s/\s*$//; p; q } }' "$assets_path/.settings")
  local play_music=$(sed -n '/# GLOBAL\|# MAIN/,/# EOF_GLOBAL\|# EOF_MAIN/ { /^play_music/ { s/.*=//; s/\x27//g; s/#.*$//; s/\s*$//; p; q } }' "$assets_path/.settings")
  local exit_code=0

  if [ -f "$video_path" ]; then
    #[[ $play_music -gt 0 ]] && playMusic
    #exit_code=$(omxplayer --aspect-mode fill --key-config "$assets_path/config/omx_config.cfg" "$video_path" 2>&1 | grep -c '^Stopped at:*')
    exit_code=$(omxplayer --genlog --pos 00:03:00 --aspect-mode fill --key-config "$assets_path/config/omx_config.cfg" "$video_path" 2>&1 | grep -c '^Stopped at:*')
    [[ $exit_code -lt 1 ]] && { return 42; } || { return 1; }
 fi
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

playMusic() {
  [ $# -gt 0 ] && music_path="${@}" || music_path=$(sed -n '/# GLOBAL\|# GAMES/,/# EOF_GLOBAL\|# EOF_GAMES/ { s/#.*$//; /^\s*$/d; /^music_path/ { s/.*=//; s/\x27//g; p; q } }' "$assets_path/.settings")
  [ -e "$music_path" ] && [[ $(pgrep -c 'ffplay') -lt 1 ]] && ffplay -volume $snd_vol -nodisp -autoexit -infbuf -loglevel quiet "$music_path" >/dev/null 2>&1 &
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

echo "VFD 3 SAVER START" > /tmp/serial.fifo

#fbSaver >/dev/null 2>&1
videoSaver; exit $?

#videoSaver; ec=$?; printf '\010' > /tmp/vkbdd.fifo; exit $ec

# ______________________________________________________________________________________________
