#!/bin/bash

SCRIPT=$(readlink -f "$0")
DIR=$(cd "$(dirname $SCRIPT)" && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)
assets_path="$HOMEDIR/ADMIN/MENU/.assets"
#thd_log="$HOMEDIR/ADMIN/.sys/thd/devices.log"
thd_log="$DIR/saver_test_state.log"

t_blank=60
blank_time=$t_blank


#exitFunc() { sudo pkill thd; exit; }
#trap 'exitFunc' EXIT INT TERM HUP SIGINT SIGTERM SIGHUP

bgSaver() {
  exit_code=$(omxplayer --genlog --pos 00:03:00 --aspect-mode fill --key-config "$assets_path/config/omx_config.cfg" "$video_path" 2>&1 | grep -c '^Stopped at:*')
  [[ $exit_code -lt 1 ]] && { return 42; } || { return 1; }
}


menuSaver() {
  local timeout=10
  local elapsed=$(cat /tmp/elapsed.fifo)
  local elapsed_last=$elapsed
  local saver_state=0
  local saver_pid=
  local mode='admin'
  local stored_mode=$mode

  printf '\010' > /tmp/vkbdd.fifo
  printf '' > "$assets_path/saver/exit_code"
  printf "$mode" > $thd_log # REM

  while true; do IFS=$'\n' read -sr elapsed >/dev/null 2>&1
    if [[ $elapsed =~ ^[0-9]+$ ]]; then echo "elapsed: $elapsed";
      if [[ $elapsed -lt $elapsed_last ]]; then
        if [[ $saver_state -eq 1 ]]; then saver_state=0
          saver_pid=; mode=$stored_mode; echo -e "mode:\t$mode" > $thd_log
          echo "SAVER OFF - mode='$mode' (stored: '$stored_mode')"
        fi
      elif [[ $elapsed -ge $timeout ]]; then
        if [[ $saver_state -eq 0 ]]; then saver_state=1
          stored_mode=$(sed -n '1 {s/\(^.*\t\)//g;p}' "$thd_log"); mode='saver'; echo -e "mode:\t$mode" > $thd_log
          saver_pid=$(( RANDOM % 10000 ));
          echo "SAVER ON (pid:$saver_pid) - mode='$mode' (stored: '$stored_mode')"
        fi
      else # ( elapsed -ge elapsed_last ) && ( elapsed -lt timeout )
        if [[ $saver_state -eq 1 ]]; then
          [[ $elapsed -ge $(( timeout * 2 )) ]] && { saver_pid=; printf '42' > "$assets_path/saver/exit_code"; } # SIMULATE EXIT CODE

          if [[ $asleep -eq 0 ]] && [[ ${#saver_pid} -lt 1 ]]; then #[[ $(pgrep -fc 'bgSaver') -lt 1 ]]; then
            exit_code=$(cat "$assets_path/saver/exit_code")
            [[ $exit_code -eq 42 ]] && { echo "ASLEEP 1"; asleep=1; }
          fi
        fi
      fi
    fi
    elapsed_last=$elapsed
  done< <( cat <>/tmp/elapsed.fifo )
}
menuSaver
exit

menuSaver_old() {
  local timeout=10
  local elapsed=$(cat /tmp/elapsed.fifo)
  local elapsed_last=$elapsed
  local saver_state=0
  local saver_pid=
  local mode='admin'
  local stored_mode=$mode

  printf '\010' > /tmp/vkbdd.fifo
  printf '' > "$assets_path/saver/exit_code"

  while true; do IFS=$'\n' read -sr elapsed >/dev/null 2>&1
    if [[ $elapsed =~ ^[0-9]+$ ]]; then echo "elapsed: $elapsed"
      if [[ $saver_state -eq 0 ]]; then
        if [[ $elapsed -ge $timeout ]]; then saver_state=1;
          stored_mode=$(sed -n '1 {s/\(^.*\t\)//g;p}' "$thd_log"); mode='saver'; echo -e "mode:\t$mode" > $thd_log; echo "mode: $mode (stored: $stored_mode)" # states.sh --mode $mode
          saver_pid=$(( RANDOM % 10000 )); echo "bgSaver & pid=$saver_pid";
          [[ $elapsed -ge $(( timeout * 2 )) ]] && printf '42' > "$assets_path/saver/exit_code"; # SIMULATE EXIT CODE
        fi
      elif [[ $saver_state -eq 1 ]]; then
        if [[ $elapsed -lt $elapsed_last ]]; then saver_state=0;
          echo "killing bgSaver (pid=$saver_pid)"; saver_pid=
          mode=$stored_mode; stored_mode=$(sed -n '1 {s/\(^.*\t\)//g;p}' "$thd_log"); echo -e "mode:\t$mode" > $thd_log; echo "mode: $mode (stored: $stored_mode)" # states.sh --mode $mode
          [[ $asleep -eq 1 ]] && { echo "ASLEEP 0"; asleep=0; }
        else
          if [[ $asleep -eq 0 ]]; then #[[ $(pgrep -fc 'bgSaver') -lt 1 ]]; then
            exit_code=$(cat "$assets_path/saver/exit_code")
            [[ $exit_code -eq 42 ]] && { echo "ASLEEP 1"; asleep=1; }
          fi
        fi
      fi
      elapsed_last=$elapsed
    fi
  done< <( cat <>/tmp/elapsed.fifo )
  exit #return 0

  while true; do IFS=$'\n' read -sr elapsed >/dev/null 2>&1
    if [[ $elapsed =~ ^[0-9]+$ ]]; then
      if [[ $saver_state -eq 0 ]] && [[ $elapsed -ge $timeout ]]; then saver_state=1;
        [ ! -f "$assets_path/fb0.dump" ] && { sudo cat /dev/fb0 > "$assets_path/fb0.dump" & wait $!; }
        stored_mode=$(sed -n '1 {s/\(^.*\t\)//g;p}' "$HOMEDIR/ADMIN/.sys/thd/devices.log"); sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --mode saver
        sudo bash "$assets_path/saver/bgSaver.sh" & saver_pid=$!
        setBlankTime 0
      elif [[ $saver_state -eq 1 ]]; then
        if [[ $elapsed -lt $elapsed_last ]]; then saver_state=0
          sudo pkill -f 'bgSaver'; saver_pid=
          [ -f "$assets_path/fb0.dump" ] && { sudo cat "$assets_path/fb0.dump" > /dev/fb0; sudo rm "$assets_path/fb0.dump"; }
          [[ $asleep -eq 1 ]] && { echo "ASLEEP 0" > /tmp/serial.fifo; asleep=0; }
          sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --mode $stored_mode; setBlankTime "$(( t_blank / 60 ))"
        else
          if [[ $asleep -eq 0 ]] && [[ $(pgrep -fc 'bgSaver') -lt 1 ]] && [[ $asleep -eq 0 ]]; then
            exit_code=$(cat "$assets_path/saver/exit_code")
            [[ $exit_code -eq 42 ]] && { echo "ASLEEP 1" > /tmp/serial.fifo; asleep=1; printf '' > "$assets_path/saver/exit_code"; }
          sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --mode $stored_mode; setBlankTime "$(( t_blank / 60 ))"
          fi
        fi
      fi
      elapsed_last=$elapsed
    fi
  done< <( cat <>/tmp/elapsed.fifo )
}

menuSaver
