#!/bin/bash

#SCRIPT=$(readlink -f "$0")
#DIR=$(cd "$(dirname $SCRIPT)" && pwd)

HOMEDIR=$(getent passwd pi | cut -d: -f6)
DIR="$HOMEDIR/ADMIN/MENU/.assets/saver"
assets_path="$HOMEDIR/ADMIN/MENU/.assets"

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -



#exitFunc() { sudo kill -9 $(jobs -p) &> /dev/null; wait; echo "VFD 6   A W O K E N" > /tmp/serial.fifo; clear; exit; }
#trap 'exitFunc' EXIT; trap 'exit 1' INT HUP SIGINT SIGHUP TERM

exitFunc() { echo "exit code: $1"; echo "$1" > "$assets_path/saver/exit_code"; exit $1; }
trap '[[ $? -eq 42 ]] && exitFunc 42 || exitFunc 0' EXIT; trap 'exit 42' INT HUP SIGINT SIGHUP TERM
#trap '[[ $? -eq 42 ]] && exitFunc 42 || exitFunc 0' EXIT; trap 'exit 1' INT HUP SIGINT SIGHUP TERM

source "$assets_path/saver/.source.sh"

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

while true; do sleep 1; done
exit 42

video_path=$(sed -n '/# GLOBAL\|# MAIN/,/# EOF_GLOBAL\|# EOF_MAIN/ { s/#.*$//; /^\s*$/d; /^vidsaver_path/ { s/.*=//; s/\x27//g; p; q } }' "$assets_path/.settings")
play_music=$(sed -n '/# GLOBAL\|# MAIN/,/# EOF_GLOBAL\|# EOF_MAIN/ { s/#.*$//; /^\s*$/d; /^play_music/ { s/.*=//; s/\x27//g; p; q } }' "$assets_path/.settings")
echo -e "vid path: $video_path\nplay_music: $play_music"

videoSaver() { local exit_code=42; echo "videoSaver"; return $exit_code; }
videoSaver
exit $?

#exit 42

fbSaver() {
  terminalLines GREEN; sleep 1
  drawStatic 50
  drawRGBLines
  fillScreenLines $BLACK; clearBuffer
  fullColorRandom
  fillScreenLines $BLACK; clearBuffer
  tilesThin 8
  fillScreenLines $BLACK; clearBuffer
  tiles
  fillScreenLines $BLACK; clearBuffer
  drawColumns
  fullColorRandom
  gradients
  vapor
  vertRandLines
  scanlines_thick
  fillScreenLines
  vaporGlitch
  fillScreenLines $BLACK
  clearBuffer
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -



videoSaver() {
  local video_path=$(sed -n '/# GLOBAL\|# GAMES/,/# EOF_GLOBAL\|# EOF_GAMES/ { s/#.*$//; /^\s*$/d; /^vidsaver_path/ { s/.*=//; s/\x27//g; p; q } }' "$assets_path/.settings")
  local play_music=$(sed -n '/# GLOBAL\|# GAMES/,/# EOF_GLOBAL\|# EOF_GAMES/ { s/#.*$//; /^\s*$/d; /^vidsaver_path/ { s/.*=//; s/\x27//g; p; q } }' "$assets_path/.settings")
  local exit_code=0

  if [ -e "$video_path" ] && [[ $play_video -gt 0 ]]; then
    [[ $play_music -gt 0 ]] && playMusic
    exit_code=$(omxplayer --aspect-mode fill --key-config "$assets_path/config/omx_config.cfg" "$video_path" 2>&1 | grep -c '^Stopped at:*')
    [[ $exit_code -lt 1 ]] && return 42 || return 1
 fi
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

playMusic() {
  [ $# -gt 0 ] && music_path="${@}" || music_path=$(sed -n '/# GLOBAL\|# GAMES/,/# EOF_GLOBAL\|# EOF_GAMES/ { s/#.*$//; /^\s*$/d; /^music_path/ { s/.*=//; s/\x27//g; p; q } }' "$assets_path/.settings")

  [ -e "$music_path" ] && [[ $(pgrep -c 'ffplay') -lt 1 ]] && ffplay -volume $snd_vol -nodisp -autoexit -infbuf -loglevel quiet "$music_path" >/dev/null 2>&1 &
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

#sudo setterm --cursor off
echo "VFD 3 SAVER START" > /tmp/serial.fifo

fbSaver >/dev/null 2>&1
videoSaver
exit $?

# ______________________________________________________________________________________________
