#!/usr/bin/env bash

SCRIPT=$(readlink -f $0)
SCRIPT_DIR=$(cd $(dirname $SCRIPT) && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)
CMD=$(echo "$SCRIPT" | awk -F'/' '{print $(NF-1)}' | tr '[:lower:]' '[:upper:]')

LOG="$HOMEDIR/ADMIN/.log/es.log"

echo "[ `date +%F\ -\ %T` ] $CMD $@" >> "$LOG"
sudo sed -i '/SSAVER/ s/SSAVER[=].*$/SSAVER=1/' "$HOMEDIR/ADMIN/.sys/.states"

if [[ $(grep 'screensaver_music' "$HOMEDIR/ADMIN/.sys/.settings" | cut -d= -f2) -gt 1 ]]; then
  SDL_AUDIODRIVER='alsa'; AUDIODEV='hw:1,0'
  ffplay -volume 90 -nodisp -autoexit -infbuf -loglevel quiet /home/pi/downloads/music/Live_to_tell.mp3 &
fi

# --------------------------------------------------------------------

#echo -e "ASLEEP 1" > /tmp/serial.fifo
#sudo th-cmd --socket /run/thd.socket --mode sleep
#sudo th-cmd --socket /run/thd.socket --remove /dev/input/by-id/usb-SHANWAN_Skyuan_F16-event-joystick --tag joy

