#!/bin/bash

ARG="$@"
SCRIPT=$(readlink -f "$0"); PID=$$
DIR=$(cd "$(dirname $SCRIPT)" && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)
menu_path="$HOMEDIR/ADMIN/MENU"
assets_path="$menu_path/.assets"

vkbd=$(sed -n '/fifo_vkbd=/ { s/\(.*\)=//g; s/\x27//g; p }' "$HOMEDIR/ADMIN/.sys/.settings")
timeout=$(sed -n '/saver_timeout=/ { s/\(.*\)=//g; s/\x27//g; p }' "$HOMEDIR/ADMIN/.sys/.settings")


exitFunc() { sudo pkill -f 'bgSaver'; stty sane; clear; sudo setterm --cursor on; exit; }
trap 'exitFunc' EXIT; trap 'exit 1' INT HUP SIGINT SIGHUP TERM


# -----------------------------------------------------------------------------------

menuSaver() {
  local timeout=${1:-10}
  local elapsed=$(cat /tmp/elapsed.fifo)
  local elapsed_last=$elapsed
  local saver_state=0
  local saver_pid=

  #echo -e "timeout: $timeout\n" # REM

  printf '\010' > /tmp/vkbdd.fifo

  while true; do IFS=$'\n' read -sr elapsed >/dev/null
    if [[ $elapsed =~ ^[0-9]+$ ]]; then #echo "elapsed: $elapsed";
      if [[ $saver_state -eq 0 ]] && [[ $elapsed -ge $timeout ]]; then saver_state=1;
        [ ! -f "$assets_path/fb0.dump" ] && { sudo cat /dev/fb0 > "$assets_path/fb0.dump" & wait $!; }
        sudo bash "$DIR/bgSaver.sh" & saver_pid=$!
      elif [[ $saver_state -eq 1 ]] && [[ $elapsed -lt $elapsed_last ]]; then saver_state=0;
        sudo pkill -f 'bgSaver'; tail --pid=$saver_pid -f /dev/null && clear
        saver_pid=
        [ -f "$assets_path/fb0.dump" ] && { sudo cat /dev/fb0 > "$assets_path/fb0.dump" & wait $!; }
      fi
      elapsed_last=$elapsed
    fi
  done< <( cat <>/tmp/elapsed.fifo )

}

menuSaver #$timeout

exit

# ___________________________________________________________________________________




menuSaver() {
  cat /tmp/elapsed.fifo >/dev/null # empty pipe before reading
  local elapsed=$(cat /tmp/elapsed.fifo)
  local count=0

  while true; do
    IFS=$'\n' read -t 0.1 time; [[ ${#time} -gt 0 ]] && elapsed=$time
    echo "$count : $elapsed"; (( count++ ))
  done< <( cat <>/tmp/elapsed.fifo )

}

menuSaver


exit

# ___________________________________________________________________________________

#while IFS=$'\n' read elapsed; do echo "$elapsed"; done< <( cat <>/tmp/elapsed.fifo )

#timeout=$(grep -m1 '^t_fbsaver' "$menu_path/.assets/.settings" | sed 's/\(.*\+=\)//;s/#.*$//')
#sed -n '/# GLOBAL\|# MAIN/,/# EOF_GLOBAL\|# EOF_MAIN/ { s/#.*$//; /^\s*$/d; p }' "$assets_path/.settings"

