#!/bin/bash

[ $# -lt 1 ] && exit 1

thd_devs="/home/pi/ADMIN/.log/_thd_devices.log"

args=("${@}")
grab=0; match='-1'
action=''; action_count=0
name=''; dev=''; output=''

cmd_str='sudo th-cmd --socket /run/thd.socket'

checkArgs() {
  for (( x=0; x<${#args[@]}; x++ )); do
    n="${args[$x]}"; n=$(echo "${n,,}" | sed 's/\-//g')
    if [[ $n == add ]] || [[ $n == remove ]]; then
      action="${n}"; dev="${args[$(( x + 1 ))]}"; (( action_count++ ))
    else
      [[ $n == tag ]]  && name="${args[$(( x + 1 ))]}"
      [[ $n == grab ]] && grab=1
    fi
  done
}

writeFile() {
  #if [[ $(cat "$thd_devs" | grep -wo "$(echo $dev | awk -F'\/dev\/input\/by-id\/usb-' '{print $2}' | wc -l)") -lt 1 ]]; then

  if [[ $(cat "$thd_devs" | grep -wc "$name\|$dev") -lt 1 ]]; then
    if [[ $action == add ]]; then
      cmd_str="${cmd_str} --add ${dev}"
      [[ ${#name} -gt 0 ]] && { cmd_str="${cmd_str} --tag $name"; output="${name} "; } || { output="device "; }
      [[ $grab -gt 0 ]]    && { cmd_str="${cmd_str} --grab";      output="${output}(grabbed) "; } || { output="${output} "; }
      echo -e "${output}${dev}" | sudo tee -a "$thd_devs" &>/dev/null
    fi
  elif [[ $(cat "$thd_devs" | grep -wc "$name\|$dev") -gt 0 ]]; then
    if [[ $action == remove ]]; then
      cmd_str="${cmd_str} --remove ${dev}"
      [[ ${#name} -gt 0 ]] && { cmd_str="${cmd_str} --tag $name"; sed -i "/${name}/Id" "$thd_devs"; } || { sed -i "/${dev}/Id" "$thd_devs"; }
    fi
  fi
  echo "${cmd_str}"; sudo bash -c "$cmd_str"
}

checkArgs

[[ $action_count -eq 1 ]] && \
[[ ${#action} -gt 0 ]] && \
[[ ${#dev} -gt 0 ]] && writeFile

exit

# ------------------------------

writeFile_old() {
  if [[ $(cat "$thd_devs" | grep -wo "$name\|$dev" | wc -l) -lt 1 ]]; then
    if [[ $action == add ]]; then
      [[ ${#name} -gt 0 ]] && output="${name} " || output="device ";
      [[ $grab -gt 0 ]]    && output="${output}(grabbed) " || output="${output} "
      echo -e "${output}${dev}" | sudo tee -a "$thd_devs" &>/dev/null
    fi
  else
    if [[ $action == remove ]]; then
      [[ ${#name} -gt 0 ]] && sed -i "/${name}/Id" "$thd_devs" &>/dev/null || sed -i "/${dev}/Id" "$thd_devs" &>/dev/null
    fi
  fi

  cat "$thd_devs"
}

writeFile_old2() {
  if [[ $(grep -ic "$dev" "$thd_devs") -lt 1 ]] && [[ $action == add ]]; then
    [[ ${#name} -gt 0 ]] && output="${name} " || output="device ";
    [[ $grab -gt 0 ]]    && output="${output}(grabbed) " || output="${output}\t"
    echo -e "${output}\t\t${dev}" | sudo tee -a "$thd_devs" &>/dev/null
  elif [[ $(grep -ic "$dev" "$thd_devs") -gt 0 ]] && [[ $action == remove ]]; then
    [[ ${#name} -gt 0 ]] \
    && sed -i "/${name}/Id" "$thd_devs" &>/dev/null \
    || sed -i "/${dev}/Id" "$thd_devs" &>/dev/null
  fi

  cat "$thd_devs"

  #if   [[ $match -lt 0 ]] && [[ $action == add ]]; then
  #elif [[ $match -ge 0 ]] && [[ $action == remove ]]; then
  #  sed -i "/$name/d" "$thd_devs"
  #fi

  #[[ $match -lt 0 ]] && { [[ $action == add ]] && devs+=("$device") ; } || { [[ $action == remove ]] && unset devs[$match] ; }
  #echo "[${devs[@]}]" | sudo tee "$thd_devs" &>/dev/null; cat "$thd_devs"
}


old() {
for (( x=0; x<$#; x++ )); do
  n="${args[$x]}"; n=$(echo "${n,,}" | sed 's/\-//g')
  if [[ $n == add ]] || [[ $n == remove ]]; then
    action="${n}"; dev="${args[$(( x + 1 ))]}"; (( action_count++ ))
  else
    [[ $n == grab ]] && grab=1
  fi
done

if [[ $action_count -eq 1 ]] && [[ ${#action} -gt 0 ]] && [[ ${#dev} -gt 0 ]]; then
  echo "action: $action, dev: $dev"
  devs=($(cat "$thd_devs" | awk -F'\[|\]' '{print $2}')); match='-1'

  for (( d=0; d < ${#devs[@]}; d++ )); do [[ $dev == "${devs[$d]}" ]] && match=$d; done

  #[[ $match -lt 0 ]] && { [[ $action == add ]] && devs+=("$device") ; } || { [[ $action == remove ]] && unset devs[$match] ; }

  [[ $match -lt 0 ]] \
  && { [[ $action == add ]]    && devs+=("$dev"); } \
  || { [[ $action == remove ]] && unset devs[$match] ; }

  echo "[${devs[@]}]" | sudo tee "$thd_devs" &>/dev/null; cat "$thd_devs"
fi

#[[ $action_count -eq 1 ]] && [[ ${#action} -gt 0 ]] && [[ ${#dev} -gt 0 ]] && { echo "action: $action, dev: $dev $([[ $grab -gt 0 ]] && [[ ${action} == add ]] && echo '(grab)' || echo '')";
#  dev_str=$(cat "$thd_devs" | awk -F'\[|\]' '{print $2}'); \
#  [[ ${action} == add ]] && { \
#    [[ ${#dev_str} -gt 1 ]] && dev_str="${dev_str} ${dev}" || dev_str="${dev}"; \
#    echo "[$dev_str]" | sudo tee "$thd_devs"; \
#  }; \
#  cmd_str="${cmd_str} --${action} ${dev} $([[ $grab -gt 0 ]] && [[ ${action} == add ]] && echo '--grab' || echo '')"; \
#} \
#|| echo "not valid: --$action $dev"
#echo "cmd_str: ${cmd_str}"
}

# ------------------------------





























[[ $# -lt 2 ]] && exit 1 || action="${1,,}"
[[ $# -gt 1 ]] && param="${2}"  || param=''
[[ $# -gt 2 ]] && caller="${3}" || caller=''

#declare -Ag modes=( ["none"]=0 ["term"]=1 ["menu"]=2 ["game"]=3 )
declare -Ag modes=( ["none"]=0 ["term"]=1 ["menu"]=2 ["game"]=3 ["slide"]=4)

home_dir='/home/pi'
sys_dir="$home_dir/ADMIN/.sys"
boot_mode=$(cat "$sys_dir/.settings" | grep -w -m1 'boot_mode' | cut -d\' -f2)
joy_dev=$(cat "$sys_dir/.settings" | grep -w -m1 'DEV joystick' | cut -d\' -f2)
log="$home_dir/ADMIN/.log/_states.log"
err_log="$(dirname $0)/err.log"
dump="$(dirname $0)/dump"

valid=0; mode=

exec 2> "$err_log"

echo -n "$(date +%F' '%T)"; [[ ${#caller} -gt 0 ]] && echo -e " - ${caller}:\n" || echo -e ':\n'

if [[ $state != sleep ]]; then

  for k in "${!modes[@]}"; do [[ $state == $k ]] && valid=1; done
  [[ ${#param} -gt 0 ]] && [[ "${param}" == force ]] && valid=1
  [[ $valid -lt 1 ]] && { echo "INVALID STATE: $state"; exit 1; }

  mode="${modes[$state]}"
  [[ $mode -le 3 ]] && { echo -e "UI $mode" > /tmp/serial.fifo; sudo sed -i 's|UI[=].*$|UI='"$mode"'|g' "$sys_dir/.states"; }

  #sudo th-cmd --socket /run/thd.socket --mode "$state"
  th-cmd --socket /run/thd.socket --mode "$state"
  printf '%*s' " "2 && printf "%s\n" "th-cmd:"; printf '%*s' " "4 && printf "%s\n" "--mode $state";

  if [[ $state == game ]]; then
    sudo th-cmd --socket /run/thd.socket --remove "$joy_dev" --tag joy
    printf '%*s' " "4 && printf "%s\n" "--remove $joy_dev --tag joy"
    sudo cp -r "$home_dir/CAFCA/data/.states.default" "$home_dir/CAFCA/data/.states"
    [[ ${#param} -gt 0 ]] && { \
      game=$(echo "$param" | awk -F/ '{split($NF,n,"."); print $(NF-1)"/"n[1]}'); printf '\n'; printf '%*s' " "2 && printf "%s\n" "GAME: $game"; \
      sudo sed -i 's|ACTIVE_GAME[=].*$|ACTIVE_GAME='"\x27$game\x27"'|g' "$home_dir/CAFCA/data/.states" ; \
    }
  elif [[ $state == menu ]]; then
    [[ $caller == ES ]] && joy_name='joy_es' || joy_name='joy'
    #sudo th-cmd --socket /run/thd.socket --remove "$joy_dev" --tag joy && \
    sudo th-cmd --socket /run/thd.socket --grab --add "$joy_dev" --tag "$joy_name"
    printf '%*s' " "4 && printf "%s\n" "--grab --add $joy_dev --tag joy"
  fi
  [[ $mode -le 3 ]] && { printf "\n"; printf '%*s' " "2; printf "%s -> \x27%s\x27\n" "$sys_dir/.states" "UI=$mode"; }

else # if $state == sleep
  if [[ $boot_mode == es ]]; then
    [[ ${#param} -gt 0 ]] && [[ "$param" =~ ^[0-9]+$ ]] && { \
      echo -e "ASLEEP ${param}" > /tmp/serial.fifo ; printf '%*s' " "2 && printf "%s\n" "ASLEEP: ${param}" ; \
      sudo sed -i 's|ASLEEP[=].*$|ASLEEP='"${param}"'|g' "$sys_dir/.states" ; \
    }
  else
    echo -e "ASLEEP 1" > /tmp/serial.fifo; sed -i 's|ASLEEP[=].*$|ASLEEP=1|g' "$sys_dir/.states" #; printf '%*s' " "2 && printf "%s\n" "ASLEEP: 1"
    while read c; do echo "$c" | sudo tee -a "$home_dir/wake_event" &> /dev/null && break; done< <( sudo thd --socket /run/thd.socket  --dump /dev/input/event*)
    echo -e "ASLEEP 0" > /tmp/serial.fifo; sed -i 's|ASLEEP[=].*$|ASLEEP=0|g' "$sys_dir/.states" #; printf '%*s' " "2 && printf "%s\n" "ASLEEP: 0"
  fi
fi

if [[ $(cat $err_log | wc -c) -gt 0 ]]; then
 echo -e "\n  errors:" | tee -a "$log" &> /dev/null
 while read line; do
   echo -e "    $line" | tee -a "$log" &> /dev/null
 done< <(cat "$err_log")

fi
#[[ $(cat $err_log | wc -c) -gt 0 ]] && echo -e "\nerrors:\n$(cat $err_log)" | tee -a "$log" &> /dev/null

echo -e "\n--------------------------------------------------------------------------------\n"

lines=$(awk -v p="$(date '+%Y')" -v n="$(grep -c 2024 $log)" '$0~p{i++}i==n' "$log" | wc -l) &>/dev/null

#exit

touch "$dump" && printf '' | tee "$dump" &>/dev/null
cat "$log" | tail -n $lines | tee "$dump" &>/dev/null
cat "$log" | head -n -$lines | tee -a "$dump" &>/dev/null
cat "$dump" | tee "$log" &>/dev/null
rm "$dump" &> /dev/null

# --------------------------------------------------------------------------------------------
