#!/bin/bash

SCRIPT=$(readlink -f "$0")
DIR=$(cd "$(dirname $SCRIPT)" && pwd)
HOMEDIR=$(getent passwd pi | cut -d: -f6)
assets_path="$HOMEDIR/ADMIN/MENU/.assets"

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

exitFunc() {
  echo "VFD 3 SAVER END" > /tmp/serial.fifo
  exec 3<&-
  #[ $(ps --no-header -p $fb_pid | wc -l) -gt 0 ]] && sudo kill -9 $fb_pid >/dev/null 2>&1
  sudo kill -9 $fb_pid >/dev/null 2>&1
  sudo pkill omxplayer >/dev/null 2>&1
  local JOBS=($(jobs -p)); for job in ${JOBS[@]}; do echo "$(ps --no-header -c $job | awk '{$1=$1;print}')"; done > /home/pi/jobs
  #sudo kill -9 $(jobs -p) > /dev/null 2>&1
  exit $1
}

trap 'exitFunc $?' EXIT; trap 'exit 1' INT HUP SIGINT SIGHUP TERM
#trap 'exit 1' INT HUP SIGINT SIGHUP TERM

source "$assets_path/saver/.source.sh"

fb_pid=

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

fbSaver() {
  terminalLines GREEN; sleep 1
  drawStatic 50
  drawRGBLines
  fillScreenLines $BLACK; clearBuffer
  fullColorRandom
  fillScreenLines $BLACK; clearBuffer
  tilesThin 8
  fillScreenLines $BLACK; clearBuffer
  tiles
  fillScreenLines $BLACK; clearBuffer
  drawColumns
  fullColorRandom
  gradients
  vapor
  vertRandLines
  scanlines_thick
  fillScreenLines
  vaporGlitch
  fillScreenLines $BLACK
  clearBuffer
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

videoSaver() {
  local video_path=$(sed -n '/# GLOBAL\|# MAIN/,/# EOF_GLOBAL\|# EOF_MAIN/ { /^vidsaver_path/ { s/.*=//; s/\x27//g; s/#.*$//; s/\s*$//; p; q } }' "$assets_path/.settings")
  local music_path=$(sed -n '/# GLOBAL\|# MAIN/,/# EOF_GLOBAL\|# EOF_MAIN/ { /^music_path/ { s/.*=//; s/\x27//g; s/#.*$//; s/\s*$//; p; q } }' "$assets_path/.settings")
  local play_music=$(sed -n '/# GLOBAL\|# MAIN/,/# EOF_GLOBAL\|# EOF_MAIN/ { /^play_music/ { s/.*=//; s/\x27//g; s/#.*$//; s/\s*$//; p; q } }' "$assets_path/.settings")
  local snd_vol=$(sed -n '/# GLOBAL\|# MAIN/,/# EOF_GLOBAL\|# EOF_MAIN/ { /^snd_vol/ { s/.*=//; s/\x27//g; s/#.*$//; s/\s*$//; p; q } }' "$assets_path/.settings")
  local exit_code=0

  if [ -f "$video_path" ]; then
    [[ $play_music -gt 0 ]] && ffplay -volume $snd_vol -nodisp -autoexit -infbuf -loglevel quiet "$music_path" >/dev/null 2>&1 &

    sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --mode omx
    exec 3<> /tmp/omxctrl.fifo
    #omxplayer --pos 00:03:00 --aspect-mode fill --key-config "$assets_path/config/omx_config.cfg" "$video_path" <&3 2>&1 | grep -c '^Stopped at:*' | tee "$assets_path/saver/exit_code" &>/dev/null
    omxplayer --aspect-mode fill --key-config "$assets_path/config/omx_config.cfg" "$video_path" <&3 2>&1 | grep -c '^Stopped at:*' | tee "$assets_path/saver/exit_code" &>/dev/null
    exec 3<&-
    sudo bash "$HOMEDIR/ADMIN/.sys/thd/states.sh" --mode saver
    declare -c exit_code=$(cat "$assets_path/saver/exit_code")

    if [[ $(pgrep -c ffplay) -gt 0 ]]; then
      [[ $exit_code -gt 0 ]] && sudo pkill ffplay &>/dev/null || sudo setterm --blank force --term linux </dev/tty1 &>/dev/null
    fi
    #[[ $exit_code -eq 0 ]] && [[ $(pgrep -c ffplay) -gt 0 ]] && sudo setterm --blank force --term linux </dev/tty1 &>/dev/null #--term linux &>/dev/null

    return $exit_code
 fi
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

playMusic() {
  [ $# -gt 0 ] && music_path="${@}" || music_path=$(sed -n '/# GLOBAL\|# GAMES/,/# EOF_GLOBAL\|# EOF_GAMES/ { s/#.*$//; /^\s*$/d; /^music_path/ { s/.*=//; s/\x27//g; p; q } }' "$assets_path/.settings")
  [ -e "$music_path" ] && [[ $(pgrep -c 'ffplay') -lt 1 ]] && ffplay -volume $snd_vol -nodisp -autoexit -infbuf -loglevel quiet "$music_path" >/dev/null 2>&1 &
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

#echo "VFD 3 SAVER START" > /tmp/serial.fifo

fbSaver &> /dev/null & fb_pid=$!; wait $fb_pid
[ -f "$assets_path/fb0.dump" ] && sudo cat "$assets_path/fb0.dump" > /dev/fb0
videoSaver; exit $?


# ______________________________________________________________________________________________
