#!/bin/bash

# HARDWARE:
   # Model:
   data_model=$(cat /proc/cpuinfo | grep Model | cut -d':' -f2 | sed 's/ //')
   data_serno=$(cat /proc/cpuinfo | grep Serial | cut -d ' ' -f 2 | cut -c 9- | awk '{print "0x" $0}')
   data_ip=$(hostname -I | cut -d' ' -f1)
   echo -e "`date`\n"
   echo -e "MODEL: $data_model"
   echo -e "SERIAL: $data_serno\n"
   echo -e "IP ADDR: $data_ip\n"


# BOOT-INFO:
   # boot times:
   sudo systemd-analyze | xargs | sed 's/(//g; s/)//g' | awk -F' ' '{print "BOOT TIMES:\n" $5 "\t\t" $4 "\n" $8 "\t" $7 "\n" $1 "\t\t" $10}'

# SYSTEM:
   # free disk space:
   echo -e "\nDISK USAGE:"

   freekeys=($(free --total | awk 'NR==1' | sed -e "s/ \+/\n/g" | tail -n6))
   freevals=($(free --total | awk 'NR==2' | sed -e "s/ \+/\n/g" | tail -n6))

   for i in "${!freekeys[@]}"; do
      [ "$i" -lt 4 ] && tabstr="\t\t" || tabstr="\t"
      echo -e "${freekeys[i]}$tabstr${freevals[i]}"
      #printf "%s %s\n" "${freekeys[i]}" "${freevals[i]}"
   done

sleep 2

# NETWORK:
  # WLAN
   echo -e "\nWLAN (IWConfig):\n"
  iwconf=$(sudo iwconfig wlan0 | sed -e "s/ \+/ /g")

  echo "$iwconf" | cut -d' ' -f 2- | awk -F' ' 'NR==1' | cut -d' ' -f -2
  echo "$iwconf" | cut -d' ' -f 2- | awk -F' ' 'NR==1' | cut -d' ' -f 3- | sed -e "s/:/ /g; s/\"/'/g" | cut -c 2-
  echo "$iwconf" | cut -d' ' -f 5- | awk -F' ' 'NR==2 {print $1 "_" substr($2,0,length($2)) " " $3}'
  echo "$iwconf" | awk -F' ' 'NR==3 {print $1"_"$2$3}' | sed 's/=/ /g'
  echo "$iwconf" | cut -d' ' -f 3- | awk -F' ' 'NR==2 {print $1 " " $2}' | sed -e "s/:/ /g"
  echo "$iwconf" | awk -F' ' 'NR==7' | cut -d' ' -f 2,3 | sed 's/ /_/g; s/=/ /g'
  echo "$iwconf" | awk -F' ' 'NR==7' | cut -d' ' -f 4,5,6 | sed 's/ /_/; s/=/ /'
  #echo "$iwconf" | cut -d':' -f 1- | awk -F' ' 'NR==4 {print $1"_"$2"_"$3}' | sed 's/:/ /g'
  #echo "$iwconf" | cut -d' ' -f 2- | awk -F' ' 'NR==2 {print $1}' | sed -e "s/:/ /g"
  #echo "$iwconf" | awk -F' ' 'NR==6' | cut -d' ' -f 2,3 | sed 's/ /_/g; s/:/ /g'

  #echo "$iwconf" | awk -F' ' 'NR==4' | cut -d' ' -f 5,6 | sed 's/ /_/g; s/:/ /g'
  #echo "$iwconf" | awk -F':' 'NR==9' | cut -d' ' -f 7,8 | sed 's/ /_/g; s/:/ /g'
  #echo "$iwconf" | awk -F' ' 'NR==5' | cut -d' ' -f 2,3 | sed 's/ /_/g; s/:/ /g'
  #echo "$iwconf" | awk -F':' 'NR==9' | cut -d' ' -f 2,3,4 | sed 's/ /_/g; s/:/ /g'
  #echo "$iwconf" | awk -F' ' 'NR==4' | cut -d' ' -f 7,8 | sed 's/ /_/g; s/:/ /g'
  #echo "$iwconf" | awk -F':' 'NR==8' | cut -d' ' -f 5,6,7 | sed 's/ /_/g; s/:/ /g'
  #echo "$iwconf" | awk -F':' 'NR==8' | cut -d' ' -f 8,9,10 | sed 's/ /_/g; s/:/ /g'
  #echo "$iwconf" | awk -F':' 'NR==8' | cut -d' ' -f -4 | sed 's/ //; s/ /_/g; s/:/ /'
  #echo "$iwconf" | awk -F':' 'NR==9' | cut -d' ' -f 5,6 | sed 's/ /_/g; s/:/ /g'


  # APPEND LOGS:
  #cat /var/log/messages | cut -d']' -f 2-
